/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.SortedList;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class CoprocessorHost<C extends Coprocessor, E extends CoprocessorEnvironment<C>> {
    public static final String REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.region.classes";
    public static final String REGIONSERVER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.regionserver.classes";
    public static final String USER_REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.user.region.classes";
    public static final String MASTER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.master.classes";
    public static final String WAL_COPROCESSOR_CONF_KEY = "hbase.coprocessor.wal.classes";
    public static final String ABORT_ON_ERROR_KEY = "hbase.coprocessor.abortonerror";
    public static final boolean DEFAULT_ABORT_ON_ERROR = true;
    public static final String COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.enabled";
    public static final boolean DEFAULT_COPROCESSORS_ENABLED = true;
    public static final String USER_COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.user.enabled";
    public static final boolean DEFAULT_USER_COPROCESSORS_ENABLED = true;
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorHost.class);
    protected Abortable abortable;
    protected final SortedList<E> coprocEnvironments = new SortedList<CoprocessorEnvironment>(new EnvironmentPriorityComparator());
    protected Configuration conf;
    protected String pathPrefix;
    protected AtomicInteger loadSequence = new AtomicInteger();
    private static Set<String> coprocessorNames = Collections.synchronizedSet(new HashSet());
    private static final Set<Class<? extends Coprocessor>> legacyWarning = new ConcurrentSkipListSet<Class<? extends Coprocessor>>(new Comparator<Class<? extends Coprocessor>>(){

        @Override
        public int compare(Class<? extends Coprocessor> c1, Class<? extends Coprocessor> c2) {
            if (c1.equals(c2)) {
                return 0;
            }
            return c1.getName().compareTo(c2.getName());
        }
    });

    public CoprocessorHost(Abortable abortable) {
        this.abortable = abortable;
        this.pathPrefix = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getLoadedCoprocessors() {
        Set<String> set = coprocessorNames;
        synchronized (set) {
            return new HashSet<String>(coprocessorNames);
        }
    }

    public Set<String> getCoprocessors() {
        TreeSet<String> returnValue = new TreeSet<String>();
        for (CoprocessorEnvironment e : this.coprocEnvironments) {
            returnValue.add(e.getInstance().getClass().getSimpleName());
        }
        return returnValue;
    }

    protected void loadSystemCoprocessors(Configuration conf, String confKey) {
        boolean coprocessorsEnabled = conf.getBoolean(COPROCESSORS_ENABLED_CONF_KEY, true);
        if (!coprocessorsEnabled) {
            return;
        }
        String[] defaultCPClasses = conf.getStrings(confKey);
        if (defaultCPClasses == null || defaultCPClasses.length == 0) {
            return;
        }
        int priority = 0x1FFFFFFF;
        for (String className : defaultCPClasses) {
            if (this.findCoprocessor(className = className.trim()) != null) {
                LOG.warn("Attempted duplicate loading of " + className + "; skipped");
                continue;
            }
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                Class<?> implClass = cl.loadClass(className);
                E env = this.checkAndLoadInstance(implClass, priority, conf);
                if (env == null) continue;
                this.coprocEnvironments.add(env);
                LOG.info("System coprocessor {} loaded, priority={}.", (Object)className, (Object)priority);
                ++priority;
            }
            catch (Throwable t) {
                this.abortServer(className, t);
            }
        }
    }

    public E load(Path path, String className, int priority, Configuration conf) throws IOException {
        String[] includedClassPrefixes = null;
        if (conf.get("hbase.coprocessor.classloader.included.classes") != null) {
            String prefixes = conf.get("hbase.coprocessor.classloader.included.classes");
            includedClassPrefixes = prefixes.split(";");
        }
        return this.load(path, className, priority, conf, includedClassPrefixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E load(Path path, String className, int priority, Configuration conf, String[] includedClassPrefixes) throws IOException {
        Class implClass;
        LOG.debug("Loading coprocessor class " + className + " with path " + path + " and priority " + priority);
        CoprocessorClassLoader cl = null;
        if (path == null) {
            try {
                implClass = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("No jar path specified for " + className);
            }
        }
        cl = CoprocessorClassLoader.getClassLoader((Path)path, (ClassLoader)this.getClass().getClassLoader(), (String)this.pathPrefix, (Configuration)conf);
        try {
            implClass = cl.loadClass(className, includedClassPrefixes);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load external coprocessor class " + className, e);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader hostClassLoader = currentThread.getContextClassLoader();
        try {
            E cpInstance;
            currentThread.setContextClassLoader((ClassLoader)cl);
            E e = cpInstance = this.checkAndLoadInstance(implClass, priority, conf);
            return e;
        }
        finally {
            currentThread.setContextClassLoader(hostClassLoader);
        }
    }

    @VisibleForTesting
    public void load(Class<? extends C> implClass, int priority, Configuration conf) throws IOException {
        E env = this.checkAndLoadInstance(implClass, priority, conf);
        this.coprocEnvironments.add(env);
    }

    public E checkAndLoadInstance(Class<?> implClass, int priority, Configuration conf) throws IOException {
        C impl;
        try {
            impl = this.checkAndGetInstance(implClass);
            if (impl == null) {
                LOG.error("Cannot load coprocessor " + implClass.getSimpleName());
                return null;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
        E env = this.createEnvironment(impl, priority, this.loadSequence.incrementAndGet(), conf);
        assert (env instanceof BaseEnvironment);
        ((BaseEnvironment)env).startup();
        coprocessorNames.add(implClass.getName());
        return env;
    }

    public abstract E createEnvironment(C var1, int var2, int var3, Configuration var4);

    public abstract C checkAndGetInstance(Class<?> var1) throws InstantiationException, IllegalAccessException;

    public void shutdown(E e) {
        assert (e instanceof BaseEnvironment);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stop coprocessor " + e.getInstance().getClass().getName());
        }
        ((BaseEnvironment)e).shutdown();
    }

    public C findCoprocessor(String className) {
        for (CoprocessorEnvironment env : this.coprocEnvironments) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return (C)env.getInstance();
        }
        return null;
    }

    @VisibleForTesting
    public <T extends C> T findCoprocessor(Class<T> cls) {
        for (CoprocessorEnvironment env : this.coprocEnvironments) {
            if (!cls.isAssignableFrom(env.getInstance().getClass())) continue;
            return (T)env.getInstance();
        }
        return null;
    }

    public <T extends C> List<T> findCoprocessors(Class<T> cls) {
        ArrayList<Coprocessor> ret = new ArrayList<Coprocessor>();
        for (CoprocessorEnvironment env : this.coprocEnvironments) {
            Coprocessor cp = env.getInstance();
            if (cp == null || !cls.isAssignableFrom(cp.getClass())) continue;
            ret.add(cp);
        }
        return ret;
    }

    @VisibleForTesting
    public E findCoprocessorEnvironment(String className) {
        for (CoprocessorEnvironment env : this.coprocEnvironments) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return (E)env;
        }
        return null;
    }

    Set<ClassLoader> getExternalClassLoaders() {
        HashSet<ClassLoader> externalClassLoaders = new HashSet<ClassLoader>();
        ClassLoader systemClassLoader = this.getClass().getClassLoader();
        for (CoprocessorEnvironment env : this.coprocEnvironments) {
            ClassLoader cl = env.getInstance().getClass().getClassLoader();
            if (cl == systemClassLoader) continue;
            externalClassLoaders.add(cl);
        }
        return externalClassLoaders;
    }

    protected void abortServer(E environment, Throwable e) {
        this.abortServer(environment.getInstance().getClass().getName(), e);
    }

    protected void abortServer(String coprocessorName, Throwable e) {
        String message = "The coprocessor " + coprocessorName + " threw " + e.toString();
        LOG.error(message, e);
        if (this.abortable != null) {
            this.abortable.abort(message, e);
        } else {
            LOG.warn("No available Abortable, process was not aborted");
        }
    }

    protected void handleCoprocessorThrowable(E env, Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (!env.getConfiguration().getBoolean(ABORT_ON_ERROR_KEY, true)) {
            if (env instanceof RegionCoprocessorEnvironment) {
                String tableName = ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable().getNameAsString();
                LOG.error("Removing coprocessor '" + env.toString() + "' from table '" + tableName + "'", e);
            } else {
                LOG.error("Removing coprocessor '" + env.toString() + "' from environment", e);
            }
            this.coprocEnvironments.remove(env);
            try {
                this.shutdown(env);
            }
            catch (Exception x) {
                LOG.error("Uncaught exception when shutting down coprocessor '" + env.toString() + "'", (Throwable)x);
            }
            throw new DoNotRetryIOException("Coprocessor: '" + env.toString() + "' threw: '" + e + "' and has been removed from the active coprocessor set.", e);
        }
        this.abortServer(env, e);
    }

    protected <O, R> R execOperationWithResult(ObserverOperationWithResult<O, R> observerOperation) throws IOException {
        boolean bypass = this.execOperation(observerOperation);
        R result = observerOperation.getResult();
        return (R)(bypass == observerOperation.isBypassable() ? result : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <O> boolean execOperation(ObserverOperation<O> observerOperation) throws IOException {
        boolean bypass = false;
        if (observerOperation == null) {
            return bypass;
        }
        List<E> envs = this.coprocEnvironments.get();
        for (CoprocessorEnvironment env : envs) {
            observerOperation.prepare(env);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                observerOperation.callObserver();
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            observerOperation.postEnvCall();
            if (!(bypass |= observerOperation.shouldBypass())) continue;
            break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <O> boolean execShutdown(ObserverOperation<O> observerOperation) throws IOException {
        if (observerOperation == null) {
            return false;
        }
        boolean bypass = false;
        List<E> envs = this.coprocEnvironments.get();
        for (CoprocessorEnvironment env : envs) {
            observerOperation.prepare(env);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                observerOperation.callObserver();
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= observerOperation.shouldBypass();
        }
        for (CoprocessorEnvironment env : envs) {
            observerOperation.prepare(env);
            observerOperation.postEnvCall();
        }
        return bypass;
    }

    public abstract class ObserverOperationWithResult<O, R>
    extends ObserverOperation<O> {
        private R result;

        protected abstract R call(O var1) throws IOException;

        public ObserverOperationWithResult(ObserverGetter<C, O> observerGetter, R result) {
            this(observerGetter, result, false);
        }

        public ObserverOperationWithResult(ObserverGetter<C, O> observerGetter, R result, boolean bypassable) {
            this(observerGetter, result, null, bypassable);
        }

        public ObserverOperationWithResult(ObserverGetter<C, O> observerGetter, R result, User user) {
            this(observerGetter, result, user, false);
        }

        private ObserverOperationWithResult(ObserverGetter<C, O> observerGetter, R result, User user, boolean bypassable) {
            super(observerGetter, user, bypassable);
            this.result = result;
        }

        protected R getResult() {
            return this.result;
        }

        @Override
        void callObserver() throws IOException {
            Optional observer = (Optional)this.observerGetter.apply(this.getEnvironment().getInstance());
            if (observer.isPresent()) {
                this.result = this.call(observer.get());
            }
        }
    }

    public abstract class ObserverOperationWithoutResult<O>
    extends ObserverOperation<O> {
        protected abstract void call(O var1) throws IOException;

        public ObserverOperationWithoutResult(ObserverGetter<C, O> observerGetter) {
            super(observerGetter);
        }

        public ObserverOperationWithoutResult(ObserverGetter<C, O> observerGetter, User user) {
            super(observerGetter, user);
        }

        public ObserverOperationWithoutResult(ObserverGetter<C, O> observerGetter, User user, boolean bypassable) {
            super(observerGetter, user, bypassable);
        }

        @Override
        void callObserver() throws IOException {
            Optional observer = (Optional)this.observerGetter.apply(this.getEnvironment().getInstance());
            if (observer.isPresent()) {
                this.call(observer.get());
            }
        }
    }

    private abstract class ObserverOperation<O>
    extends ObserverContextImpl<E> {
        ObserverGetter<C, O> observerGetter;

        ObserverOperation(ObserverGetter<C, O> observerGetter) {
            this(observerGetter, null);
        }

        ObserverOperation(ObserverGetter<C, O> observerGetter, User user) {
            this(observerGetter, user, false);
        }

        ObserverOperation(ObserverGetter<C, O> observerGetter, boolean bypassable) {
            this(observerGetter, null, bypassable);
        }

        ObserverOperation(ObserverGetter<C, O> observerGetter, User user, boolean bypassable) {
            super(user != null ? user : (User)RpcServer.getRequestUser().orElse(null), bypassable);
            this.observerGetter = observerGetter;
        }

        abstract void callObserver() throws IOException;

        protected void postEnvCall() {
        }
    }

    @FunctionalInterface
    public static interface ObserverGetter<C, O>
    extends Function<C, Optional<O>> {
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }
}

