// Autogenerated Jamon implementation
// /Users/stack/checkouts/hbase.git/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RSGroupListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 5
import java.util.Collections;
// 28, 5
import java.util.List;
// 29, 5
import java.util.Map;
// 30, 5
import java.util.Set;
// 31, 5
import java.util.stream.Collectors;
// 32, 5
import org.apache.hadoop.hbase.master.HMaster;
// 33, 5
import org.apache.hadoop.hbase.RegionMetrics;
// 34, 5
import org.apache.hadoop.hbase.ServerMetrics;
// 35, 5
import org.apache.hadoop.hbase.Size;
// 36, 5
import org.apache.hadoop.hbase.RSGroupTableAccessor;
// 37, 5
import org.apache.hadoop.hbase.master.ServerManager;
// 38, 5
import org.apache.hadoop.hbase.net.Address;
// 39, 5
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
// 40, 5
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RSGroupListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.Intf

{
  private final HMaster master;
  private final ServerManager serverManager;
  protected static org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RSGroupListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    serverManager = p_implData.getServerManager();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 42, 1
    
List<RSGroupInfo> groups = RSGroupTableAccessor.getAllRSGroupInfo(master.getConnection());

    // 46, 1
    if ((groups != null && groups.size() > 0))
    {
      // 46, 45
      jamonWriter.write("\n\n");
      // 48, 1
      
RSGroupInfo [] rsGroupInfos = groups.toArray(new RSGroupInfo[groups.size()]);
Map<Address, ServerMetrics> collectServers = Collections.emptyMap();
if (master.getServerManager() != null) {
  collectServers =
      master.getServerManager().getOnlineServers().entrySet().stream()
          .collect(Collectors.toMap(p -> p.getKey().getAddress(), Map.Entry::getValue));
}

      // 58, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_rsgroup_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_rsgroup_baseStats\">\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__rsgroup_baseStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 68, 97
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_memoryStats\">\n            ");
      // 71, 13
      {
        // 71, 13
        __jamon_innerUnit__rsgroup_memoryStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 71, 99
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_requestStats\">\n            ");
      // 74, 13
      {
        // 74, 13
        __jamon_innerUnit__rsgroup_requestStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 74, 100
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_storeStats\">\n            ");
      // 77, 13
      {
        // 77, 13
        __jamon_innerUnit__rsgroup_storeStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 77, 98
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_compactStats\">\n            ");
      // 80, 13
      {
        // 80, 13
        __jamon_innerUnit__rsgroup_compactStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 80, 100
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 85, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 356, 1
  private void __jamon_innerUnit__rsGroupLink(final java.io.Writer jamonWriter, final String rsGroupName)
    throws java.io.IOException
  {
    // 360, 5
    jamonWriter.write("<a href=rsgroup.jsp?name=");
    // 360, 30
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
    // 360, 47
    jamonWriter.write(">");
    // 360, 48
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
    // 360, 65
    jamonWriter.write("</a>\n");
  }
  
  
  // 87, 1
  private void __jamon_innerUnit__rsgroup_baseStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 92, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Online Servers</th>\n    <th>Num. Dead Servers</th>\n    <th>Num. Tables</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n    <th>Average Load</th>\n</tr>\n");
    // 102, 1
    
    int totalOnlineServers = 0;
    int totalDeadServers = 0;
    int totalTables = 0;
    int totalRequests = 0;
    int totalRegions = 0;
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      int onlineServers = 0;
      int deadServers = 0;
      int tables = 0;
      long requestsPerSecond = 0;
      int numRegionsOnline = 0;
      Set<Address> servers = rsGroupInfo.getServers();
      for (Address server : servers) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          requestsPerSecond += sl.getRequestCountPerSecond();
          numRegionsOnline += sl.getRegionMetrics().size();
          //rsgroup total
          totalRegions += sl.getRegionMetrics().size();
          totalRequests += sl.getRequestCountPerSecond();
          totalOnlineServers++;
          onlineServers++;
        } else {
          totalDeadServers++;
          deadServers++;
        }
      }
      tables = rsGroupInfo.getTables().size();
      totalTables += tables;
      double avgLoad = onlineServers == 0 ? 0 :
            (double)numRegionsOnline / (double)onlineServers;

    // 136, 1
    jamonWriter.write("<tr>\n    <td>");
    // 137, 9
    {
      // 137, 9
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 137, 52
    jamonWriter.write("</td>\n    <td>");
    // 138, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(onlineServers), jamonWriter);
    // 138, 28
    jamonWriter.write("</td>\n    <td>");
    // 139, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(deadServers), jamonWriter);
    // 139, 26
    jamonWriter.write("</td>\n    <td>");
    // 140, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(tables), jamonWriter);
    // 140, 21
    jamonWriter.write("</td>\n    <td>");
    // 141, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(requestsPerSecond), jamonWriter);
    // 141, 32
    jamonWriter.write("</td>\n    <td>");
    // 142, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 142, 31
    jamonWriter.write("</td>\n    <td>");
    // 143, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(avgLoad), jamonWriter);
    // 143, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 145, 1
    
}

    // 148, 1
    jamonWriter.write("<tr><td>Total:");
    // 148, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupInfos.length), jamonWriter);
    // 148, 40
    jamonWriter.write("</td>\n<td>");
    // 149, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalOnlineServers), jamonWriter);
    // 149, 29
    jamonWriter.write("</td>\n<td>");
    // 150, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalDeadServers), jamonWriter);
    // 150, 27
    jamonWriter.write("</td>\n<td>");
    // 151, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalTables), jamonWriter);
    // 151, 22
    jamonWriter.write("</td>\n<td>");
    // 152, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 152, 24
    jamonWriter.write("</td>\n<td>");
    // 153, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 153, 23
    jamonWriter.write("</td>\n<td>");
    // 154, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager().getAverageLoad()), jamonWriter);
    // 154, 53
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 305, 1
  private void __jamon_innerUnit__rsgroup_compactStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 310, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 318, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      int numStores = 0;
      long totalCompactingCells = 0;
      long totalCompactedCells = 0;
      long remainingCells = 0;
      long compactionProgress  = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rl : sl.getRegionMetrics().values()) {
            totalCompactingCells += rl.getCompactingCellCount();
            totalCompactedCells += rl.getCompactedCellCount();
          }
        }
      }
      remainingCells = totalCompactingCells - totalCompactedCells;
      String percentDone = "";
      if  (totalCompactingCells > 0) {
           percentDone = String.format("%.2f", 100 *
              ((float) totalCompactedCells / totalCompactingCells)) + "%";
      }

    // 342, 1
    jamonWriter.write("<tr>\n<td>");
    // 343, 5
    {
      // 343, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 343, 48
    jamonWriter.write("</td>\n<td>");
    // 344, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells), jamonWriter);
    // 344, 31
    jamonWriter.write("</td>\n<td>");
    // 345, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactedCells), jamonWriter);
    // 345, 30
    jamonWriter.write("</td>\n<td>");
    // 346, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(remainingCells), jamonWriter);
    // 346, 25
    jamonWriter.write("</td>\n<td>");
    // 347, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 347, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 349, 1
    
}

    // 352, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 159, 1
  private void __jamon_innerUnit__rsgroup_memoryStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 164, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 172, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      long usedHeap = 0;
      long maxHeap = 0;
      long memstoreSize = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          usedHeap += (long) sl.getUsedHeapSize().get(Size.Unit.MEGABYTE);
          maxHeap += (long) sl.getMaxHeapSize().get(Size.Unit.MEGABYTE);
          memstoreSize += (long) sl.getRegionMetrics().values().stream().mapToDouble(
            rm -> rm.getMemStoreSize().get(Size.Unit.MEGABYTE)).sum();
        }
      }

    // 188, 1
    jamonWriter.write("<tr>\n    <td>");
    // 189, 9
    {
      // 189, 9
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 189, 52
    jamonWriter.write("</td>\n    <td>");
    // 190, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(usedHeap
            * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 191, 61
    jamonWriter.write("</td>\n    <td>");
    // 192, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(maxHeap
            * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 193, 61
    jamonWriter.write("</td>\n    <td>");
    // 194, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(memstoreSize
            * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 195, 61
    jamonWriter.write("</td>\n\n</tr>\n");
    // 198, 1
    
}

    // 201, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 204, 1
  private void __jamon_innerUnit__rsgroup_requestStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 209, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 216, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      long requestsPerSecond = 0;
      long readRequests = 0;
      long writeRequests = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rm : sl.getRegionMetrics().values()) {
            readRequests += rm.getReadRequestCount();
            writeRequests += rm.getWriteRequestCount();
          }
          requestsPerSecond += sl.getRequestCountPerSecond();
        }
      }

    // 233, 1
    jamonWriter.write("<tr>\n<td>");
    // 234, 5
    {
      // 234, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 234, 48
    jamonWriter.write("</td>\n<td>");
    // 235, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(requestsPerSecond), jamonWriter);
    // 235, 28
    jamonWriter.write("</td>\n<td>");
    // 236, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(readRequests), jamonWriter);
    // 236, 23
    jamonWriter.write("</td>\n<td>");
    // 237, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(writeRequests), jamonWriter);
    // 237, 24
    jamonWriter.write("</td>\n</tr>\n");
    // 239, 1
    
}

    // 242, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 246, 1
  private void __jamon_innerUnit__rsgroup_storeStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 251, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 261, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      int numStores = 0;
      long numStorefiles = 0;
      long uncompressedStorefileSize  = 0;
      long storefileSize  = 0;
      long indexSize  = 0;
      long bloomSize  = 0;
      int count = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rm : sl.getRegionMetrics().values()) {
            numStores += rm.getStoreCount();
            numStorefiles += rm.getStoreFileCount();
            uncompressedStorefileSize += rm.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
            storefileSize += rm.getStoreFileSize().get(Size.Unit.MEGABYTE);
            indexSize += rm.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
            bloomSize += rm.getBloomFilterSize().get(Size.Unit.KILOBYTE);
          }
          count++;
        }
      }

    // 286, 1
    jamonWriter.write("<tr>\n<td>");
    // 287, 5
    {
      // 287, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 287, 48
    jamonWriter.write("</td>\n<td>");
    // 288, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numStores), jamonWriter);
    // 288, 20
    jamonWriter.write("</td>\n<td>");
    // 289, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numStorefiles), jamonWriter);
    // 289, 24
    jamonWriter.write("</td>\n<td>");
    // 290, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
    uncompressedStorefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 291, 79
    jamonWriter.write("</td>\n<td>");
    // 292, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
    storefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 293, 67
    jamonWriter.write("</td>\n<td>");
    // 294, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
    indexSize * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 295, 63
    jamonWriter.write("</td>\n<td>");
    // 296, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
    bloomSize * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 297, 63
    jamonWriter.write("</td>\n</tr>\n");
    // 299, 1
    
}

    // 302, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
