/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AuthResult {
    private boolean allowed;
    private final String namespace;
    private final TableName table;
    private final Permission.Action action;
    private final String request;
    private String reason;
    private final User user;
    private Params params;
    private final byte[] family;
    private final byte[] qualifier;
    private final Map<byte[], ? extends Collection<?>> families;

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
        this.action = action;
        this.families = null;
        this.namespace = null;
        this.params = new Params().setTableName(table).setFamily(family).setQualifier(qualifier);
    }

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.table = table;
        this.family = null;
        this.qualifier = null;
        this.action = action;
        this.families = families;
        this.namespace = null;
        this.params = new Params().setTableName(table).setFamilies(families);
    }

    public AuthResult(boolean allowed, String request, String reason, User user, Permission.Action action, String namespace) {
        this.allowed = allowed;
        this.request = request;
        this.reason = reason;
        this.user = user;
        this.namespace = namespace;
        this.action = action;
        this.table = null;
        this.family = null;
        this.qualifier = null;
        this.families = null;
        this.params = new Params().setNamespace(namespace);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public User getUser() {
        return this.user;
    }

    public String getReason() {
        return this.reason;
    }

    public TableName getTableName() {
        return this.table;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public Permission.Action getAction() {
        return this.action;
    }

    public String getRequest() {
        return this.request;
    }

    public Params getParams() {
        return this.params;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    private static String toFamiliesString(Map<byte[], ? extends Collection<?>> families, byte[] family, byte[] qual) {
        StringBuilder sb = new StringBuilder();
        if (families != null) {
            boolean first = true;
            for (Map.Entry<byte[], Collection<?>> entry : families.entrySet()) {
                String familyName = Bytes.toString((byte[])entry.getKey());
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    for (Object o : entry.getValue()) {
                        String qualifier;
                        if (o instanceof byte[]) {
                            qualifier = Bytes.toString((byte[])((byte[])o));
                        } else if (o instanceof Cell) {
                            Cell c = (Cell)o;
                            qualifier = Bytes.toString((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength());
                        } else {
                            qualifier = o.toString();
                        }
                        if (!first) {
                            sb.append("|");
                        }
                        first = false;
                        sb.append(familyName).append(":").append(qualifier);
                    }
                    continue;
                }
                if (!first) {
                    sb.append("|");
                }
                first = false;
                sb.append(familyName);
            }
        } else if (family != null) {
            sb.append(Bytes.toString((byte[])family));
            if (qual != null) {
                sb.append(":").append(Bytes.toString((byte[])qual));
            }
        }
        return sb.toString();
    }

    public String toContextString() {
        String paramsString;
        StringBuilder sb = new StringBuilder();
        String familiesString = AuthResult.toFamiliesString(this.families, this.family, this.qualifier);
        sb.append("(user=").append(this.user != null ? this.user.getName() : "UNKNOWN").append(", ");
        sb.append("scope=").append(this.namespace != null ? this.namespace : (this.table == null ? "GLOBAL" : this.table.getNameWithNamespaceInclAsString())).append(", ");
        if (this.namespace == null && familiesString.length() > 0) {
            sb.append("family=").append(familiesString).append(", ");
        }
        if ((paramsString = this.params.toString()).length() > 0) {
            sb.append("params=[").append(paramsString).append("],");
        }
        sb.append("action=").append(this.action != null ? this.action.toString() : "").append(")");
        return sb.toString();
    }

    public String toString() {
        return "AuthResult" + this.toContextString();
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, String namespace) {
        return new AuthResult(true, request, reason, user, action, namespace);
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        return new AuthResult(true, request, reason, user, action, table, family, qualifier);
    }

    public static AuthResult allow(String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        return new AuthResult(true, request, reason, user, action, table, families);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, String namespace) {
        return new AuthResult(false, request, reason, user, action, namespace);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, TableName table, byte[] family, byte[] qualifier) {
        return new AuthResult(false, request, reason, user, action, table, family, qualifier);
    }

    public static AuthResult deny(String request, String reason, User user, Permission.Action action, TableName table, Map<byte[], ? extends Collection<?>> families) {
        return new AuthResult(false, request, reason, user, action, table, families);
    }

    public String toFamilyString() {
        return AuthResult.toFamiliesString(this.families, this.family, this.qualifier);
    }

    public static class Params {
        private String namespace = null;
        private TableName tableName = null;
        private Map<byte[], ? extends Collection<?>> families = null;
        byte[] family = null;
        byte[] qualifier = null;

        public Params setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Params setTableName(TableName table) {
            this.tableName = table;
            return this;
        }

        public Params setFamilies(Map<byte[], ? extends Collection<?>> families) {
            this.families = families;
            return this;
        }

        public Params setFamily(byte[] family) {
            this.family = family;
            return this;
        }

        public Params setQualifier(byte[] qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public String toString() {
            String familiesString = AuthResult.toFamiliesString(this.families, this.family, this.qualifier);
            Object[] params = new String[]{this.namespace != null ? "namespace=" + this.namespace : null, this.tableName != null ? "table=" + this.tableName.getNameWithNamespaceInclAsString() : null, familiesString.length() > 0 ? "family=" + familiesString : null};
            return Joiner.on((String)",").skipNulls().join(params);
        }
    }
}

