/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.policies.AbstractViolationPolicyEnforcement;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DefaultViolationPolicyEnforcement
extends AbstractViolationPolicyEnforcement {
    @Override
    public void enable() throws IOException {
    }

    @Override
    public void disable() throws IOException {
    }

    @Override
    public String getPolicyName() {
        return "BulkLoadVerifying";
    }

    @Override
    public void check(Mutation m) throws SpaceLimitingException {
    }

    @Override
    public boolean shouldCheckBulkLoads() {
        return SpaceQuotaSnapshot.getNoSuchSnapshot() != this.quotaSnapshot;
    }

    @Override
    public void checkBulkLoad(FileSystem fs, List<String> paths) throws SpaceLimitingException {
        long sizeAvailableForBulkLoads = this.quotaSnapshot.getLimit() - this.quotaSnapshot.getUsage();
        long size = 0L;
        for (String path : paths) {
            if ((size += this.addSingleFile(fs, path)) > sizeAvailableForBulkLoads) break;
        }
        if (size > sizeAvailableForBulkLoads) {
            throw new SpaceLimitingException(this.getPolicyName(), "Bulk load of " + paths + " is disallowed because the file(s) exceed the limits of a space quota.");
        }
    }

    private long addSingleFile(FileSystem fs, String path) throws SpaceLimitingException {
        FileStatus status;
        try {
            status = fs.getFileStatus(new Path(Objects.requireNonNull(path)));
        }
        catch (IOException e) {
            throw new SpaceLimitingException(this.getPolicyName(), "Could not verify length of file to bulk load", e);
        }
        if (!status.isFile()) {
            throw new IllegalArgumentException(path + " is not a file.");
        }
        return status.getLen();
    }
}

