/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultOperationQuota
implements OperationQuota {
    private static final Log LOG = LogFactory.getLog(DefaultOperationQuota.class);
    private final List<QuotaLimiter> limiters;
    private long writeAvailable = 0L;
    private long readAvailable = 0L;
    private long writeConsumed = 0L;
    private long readConsumed = 0L;
    private final long[] operationSize;

    public DefaultOperationQuota(QuotaLimiter ... limiters) {
        this(Arrays.asList(limiters));
    }

    public DefaultOperationQuota(List<QuotaLimiter> limiters) {
        this.limiters = limiters;
        int size = OperationQuota.OperationType.values().length;
        this.operationSize = new long[size];
        for (int i = 0; i < size; ++i) {
            this.operationSize[i] = 0L;
        }
    }

    @Override
    public void checkQuota(int numWrites, int numReads, int numScans) throws ThrottlingException {
        this.writeConsumed = this.estimateConsume(OperationQuota.OperationType.MUTATE, numWrites, 100L);
        this.readConsumed = this.estimateConsume(OperationQuota.OperationType.GET, numReads, 100L);
        this.readConsumed += this.estimateConsume(OperationQuota.OperationType.SCAN, numScans, 1000L);
        this.writeAvailable = Long.MAX_VALUE;
        this.readAvailable = Long.MAX_VALUE;
        for (QuotaLimiter limiter : this.limiters) {
            if (limiter.isBypass()) continue;
            limiter.checkQuota(this.writeConsumed, this.readConsumed);
            this.readAvailable = Math.min(this.readAvailable, limiter.getReadAvailable());
            this.writeAvailable = Math.min(this.writeAvailable, limiter.getWriteAvailable());
        }
        for (QuotaLimiter limiter : this.limiters) {
            limiter.grabQuota(this.writeConsumed, this.readConsumed);
        }
    }

    @Override
    public void close() {
        long writeDiff = this.operationSize[OperationQuota.OperationType.MUTATE.ordinal()] - this.writeConsumed;
        long readDiff = this.operationSize[OperationQuota.OperationType.GET.ordinal()] + this.operationSize[OperationQuota.OperationType.SCAN.ordinal()] - this.readConsumed;
        for (QuotaLimiter limiter : this.limiters) {
            if (writeDiff != 0L) {
                limiter.consumeWrite(writeDiff);
            }
            if (readDiff == 0L) continue;
            limiter.consumeRead(readDiff);
        }
    }

    @Override
    public long getReadAvailable() {
        return this.readAvailable;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeAvailable;
    }

    @Override
    public void addGetResult(Result result) {
        int n = OperationQuota.OperationType.GET.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(result);
    }

    @Override
    public void addScanResult(List<Result> results) {
        int n = OperationQuota.OperationType.SCAN.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(results);
    }

    @Override
    public void addMutation(Mutation mutation) {
        int n = OperationQuota.OperationType.MUTATE.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateMutationSize(mutation);
    }

    private long estimateConsume(OperationQuota.OperationType type, int numReqs, long avgSize) {
        if (numReqs > 0) {
            return avgSize * (long)numReqs;
        }
        return 0L;
    }
}

