/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CacheStats {
    static final int DEFAULT_WINDOW_PERIODS = 5;
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder primaryHitCount = new LongAdder();
    private final LongAdder hitCachingCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder primaryMissCount = new LongAdder();
    private final LongAdder missCachingCount = new LongAdder();
    private final LongAdder evictionCount = new LongAdder();
    private final LongAdder evictedBlockCount = new LongAdder();
    private final LongAdder primaryEvictedBlockCount = new LongAdder();
    private final AtomicLong failedInserts = new AtomicLong(0L);
    private final LongAdder dataMissCount = new LongAdder();
    private final LongAdder leafIndexMissCount = new LongAdder();
    private final LongAdder bloomChunkMissCount = new LongAdder();
    private final LongAdder metaMissCount = new LongAdder();
    private final LongAdder rootIndexMissCount = new LongAdder();
    private final LongAdder intermediateIndexMissCount = new LongAdder();
    private final LongAdder fileInfoMissCount = new LongAdder();
    private final LongAdder generalBloomMetaMissCount = new LongAdder();
    private final LongAdder deleteFamilyBloomMissCount = new LongAdder();
    private final LongAdder trailerMissCount = new LongAdder();
    private final LongAdder dataHitCount = new LongAdder();
    private final LongAdder leafIndexHitCount = new LongAdder();
    private final LongAdder bloomChunkHitCount = new LongAdder();
    private final LongAdder metaHitCount = new LongAdder();
    private final LongAdder rootIndexHitCount = new LongAdder();
    private final LongAdder intermediateIndexHitCount = new LongAdder();
    private final LongAdder fileInfoHitCount = new LongAdder();
    private final LongAdder generalBloomMetaHitCount = new LongAdder();
    private final LongAdder deleteFamilyBloomHitCount = new LongAdder();
    private final LongAdder trailerHitCount = new LongAdder();
    private final int numPeriodsInWindow;
    private final long[] hitCounts;
    private final long[] hitCachingCounts;
    private final long[] requestCounts;
    private final long[] requestCachingCounts;
    private long lastHitCount = 0L;
    private long lastHitCachingCount = 0L;
    private long lastRequestCount = 0L;
    private long lastRequestCachingCount = 0L;
    private int windowIndex = 0;
    private FastLongHistogram ageAtEviction;
    private long startTime = System.nanoTime();

    public CacheStats(String name) {
        this(name, 5);
    }

    public CacheStats(String name, int numPeriodsInWindow) {
        this.numPeriodsInWindow = numPeriodsInWindow;
        this.hitCounts = new long[numPeriodsInWindow];
        this.hitCachingCounts = new long[numPeriodsInWindow];
        this.requestCounts = new long[numPeriodsInWindow];
        this.requestCachingCounts = new long[numPeriodsInWindow];
        this.ageAtEviction = new FastLongHistogram();
    }

    public String toString() {
        AgeSnapshot snapshot = this.getAgeAtEvictionSnapshot();
        return "hitCount=" + this.getHitCount() + ", hitCachingCount=" + this.getHitCachingCount() + ", missCount=" + this.getMissCount() + ", missCachingCount=" + this.getMissCachingCount() + ", evictionCount=" + this.getEvictionCount() + ", evictedBlockCount=" + this.getEvictedCount() + ", primaryMissCount=" + this.getPrimaryMissCount() + ", primaryHitCount=" + this.getPrimaryHitCount() + ", evictedAgeMean=" + snapshot.getMean();
    }

    public void miss(boolean caching, boolean primary, BlockType type) {
        this.missCount.increment();
        if (primary) {
            this.primaryMissCount.increment();
        }
        if (caching) {
            this.missCachingCount.increment();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataMissCount.increment();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexMissCount.increment();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkMissCount.increment();
                break;
            }
            case META: {
                this.metaMissCount.increment();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexMissCount.increment();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexMissCount.increment();
                break;
            }
            case FILE_INFO: {
                this.fileInfoMissCount.increment();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaMissCount.increment();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomMissCount.increment();
                break;
            }
            case TRAILER: {
                this.trailerMissCount.increment();
                break;
            }
        }
    }

    public void hit(boolean caching, boolean primary, BlockType type) {
        this.hitCount.increment();
        if (primary) {
            this.primaryHitCount.increment();
        }
        if (caching) {
            this.hitCachingCount.increment();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataHitCount.increment();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexHitCount.increment();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkHitCount.increment();
                break;
            }
            case META: {
                this.metaHitCount.increment();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexHitCount.increment();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexHitCount.increment();
                break;
            }
            case FILE_INFO: {
                this.fileInfoHitCount.increment();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaHitCount.increment();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomHitCount.increment();
                break;
            }
            case TRAILER: {
                this.trailerHitCount.increment();
                break;
            }
        }
    }

    public void evict() {
        this.evictionCount.increment();
    }

    public void evicted(long t, boolean primary) {
        if (t > this.startTime) {
            this.ageAtEviction.add((t - this.startTime) / 1000000000L, 1L);
        }
        this.evictedBlockCount.increment();
        if (primary) {
            this.primaryEvictedBlockCount.increment();
        }
    }

    public long failInsert() {
        return this.failedInserts.incrementAndGet();
    }

    public long getDataMissCount() {
        return this.dataMissCount.sum();
    }

    public long getLeafIndexMissCount() {
        return this.leafIndexMissCount.sum();
    }

    public long getBloomChunkMissCount() {
        return this.bloomChunkMissCount.sum();
    }

    public long getMetaMissCount() {
        return this.metaMissCount.sum();
    }

    public long getRootIndexMissCount() {
        return this.rootIndexMissCount.sum();
    }

    public long getIntermediateIndexMissCount() {
        return this.intermediateIndexMissCount.sum();
    }

    public long getFileInfoMissCount() {
        return this.fileInfoMissCount.sum();
    }

    public long getGeneralBloomMetaMissCount() {
        return this.generalBloomMetaMissCount.sum();
    }

    public long getDeleteFamilyBloomMissCount() {
        return this.deleteFamilyBloomMissCount.sum();
    }

    public long getTrailerMissCount() {
        return this.trailerMissCount.sum();
    }

    public long getDataHitCount() {
        return this.dataHitCount.sum();
    }

    public long getLeafIndexHitCount() {
        return this.leafIndexHitCount.sum();
    }

    public long getBloomChunkHitCount() {
        return this.bloomChunkHitCount.sum();
    }

    public long getMetaHitCount() {
        return this.metaHitCount.sum();
    }

    public long getRootIndexHitCount() {
        return this.rootIndexHitCount.sum();
    }

    public long getIntermediateIndexHitCount() {
        return this.intermediateIndexHitCount.sum();
    }

    public long getFileInfoHitCount() {
        return this.fileInfoHitCount.sum();
    }

    public long getGeneralBloomMetaHitCount() {
        return this.generalBloomMetaHitCount.sum();
    }

    public long getDeleteFamilyBloomHitCount() {
        return this.deleteFamilyBloomHitCount.sum();
    }

    public long getTrailerHitCount() {
        return this.trailerHitCount.sum();
    }

    public long getRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getRequestCachingCount() {
        return this.getHitCachingCount() + this.getMissCachingCount();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    public long getPrimaryMissCount() {
        return this.primaryMissCount.sum();
    }

    public long getMissCachingCount() {
        return this.missCachingCount.sum();
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getPrimaryHitCount() {
        return this.primaryHitCount.sum();
    }

    public long getHitCachingCount() {
        return this.hitCachingCount.sum();
    }

    public long getEvictionCount() {
        return this.evictionCount.sum();
    }

    public long getEvictedCount() {
        return this.evictedBlockCount.sum();
    }

    public long getPrimaryEvictedCount() {
        return this.primaryEvictedBlockCount.sum();
    }

    public double getHitRatio() {
        return (double)this.getHitCount() / (double)this.getRequestCount();
    }

    public double getHitCachingRatio() {
        return (double)this.getHitCachingCount() / (double)this.getRequestCachingCount();
    }

    public double getMissRatio() {
        return (double)this.getMissCount() / (double)this.getRequestCount();
    }

    public double getMissCachingRatio() {
        return (double)this.getMissCachingCount() / (double)this.getRequestCachingCount();
    }

    public double evictedPerEviction() {
        return (double)this.getEvictedCount() / (double)this.getEvictionCount();
    }

    public long getFailedInserts() {
        return this.failedInserts.get();
    }

    public void rollMetricsPeriod() {
        this.hitCounts[this.windowIndex] = this.getHitCount() - this.lastHitCount;
        this.lastHitCount = this.getHitCount();
        this.hitCachingCounts[this.windowIndex] = this.getHitCachingCount() - this.lastHitCachingCount;
        this.lastHitCachingCount = this.getHitCachingCount();
        this.requestCounts[this.windowIndex] = this.getRequestCount() - this.lastRequestCount;
        this.lastRequestCount = this.getRequestCount();
        this.requestCachingCounts[this.windowIndex] = this.getRequestCachingCount() - this.lastRequestCachingCount;
        this.lastRequestCachingCount = this.getRequestCachingCount();
        this.windowIndex = (this.windowIndex + 1) % this.numPeriodsInWindow;
    }

    public long getSumHitCountsPastNPeriods() {
        return CacheStats.sum(this.hitCounts);
    }

    public long getSumRequestCountsPastNPeriods() {
        return CacheStats.sum(this.requestCounts);
    }

    public long getSumHitCachingCountsPastNPeriods() {
        return CacheStats.sum(this.hitCachingCounts);
    }

    public long getSumRequestCachingCountsPastNPeriods() {
        return CacheStats.sum(this.requestCachingCounts);
    }

    public double getHitRatioPastNPeriods() {
        double ratio = (double)this.getSumHitCountsPastNPeriods() / (double)this.getSumRequestCountsPastNPeriods();
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public double getHitCachingRatioPastNPeriods() {
        double ratio = (double)this.getSumHitCachingCountsPastNPeriods() / (double)this.getSumRequestCachingCountsPastNPeriods();
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public AgeSnapshot getAgeAtEvictionSnapshot() {
        return new AgeSnapshot(this.ageAtEviction);
    }

    private static long sum(long[] counts) {
        return Arrays.stream(counts).sum();
    }
}

