/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FavoredNodeLoadBalancer
extends BaseLoadBalancer
implements FavoredNodesPromoter {
    private static final Log LOG = LogFactory.getLog(FavoredNodeLoadBalancer.class);
    private RackManager rackManager;
    private Configuration conf;
    private FavoredNodesManager fnm;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public synchronized void initialize() throws HBaseIOException {
        super.initialize();
        super.setConf(this.conf);
        this.fnm = this.services.getFavoredNodesManager();
        this.rackManager = new RackManager(this.conf);
        super.setConf(this.conf);
    }

    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<RegionInfo>> clusterState) {
        ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
        SnapshotOfRegionAssignmentFromMeta snaphotOfRegionAssignment = new SnapshotOfRegionAssignmentFromMeta(this.services.getConnection());
        try {
            snaphotOfRegionAssignment.initialize();
        }
        catch (IOException ie) {
            LOG.warn((Object)("Not running balancer since exception was thrown " + ie));
            return plans;
        }
        HashMap<ServerName, ServerName> serverNameWithoutCodeToServerName = new HashMap<ServerName, ServerName>();
        ServerManager serverMgr = this.services.getServerManager();
        for (ServerName serverName : serverMgr.getOnlineServersList()) {
            ServerName s = ServerName.valueOf((String)serverName.getHostname(), (int)serverName.getPort(), (long)-1L);
            serverNameWithoutCodeToServerName.put(s, serverName);
        }
        for (Map.Entry entry : clusterState.entrySet()) {
            ServerName currentServer = (ServerName)entry.getKey();
            ServerName currentServerWithoutStartCode = ServerName.valueOf((String)currentServer.getHostname(), (int)currentServer.getPort(), (long)-1L);
            List list = (List)entry.getValue();
            for (RegionInfo region : list) {
                List<ServerName> favoredNodes;
                if (!FavoredNodesManager.isFavoredNodeApplicable(region) || (favoredNodes = this.fnm.getFavoredNodes(region)) == null || favoredNodes.get(0).equals((Object)currentServerWithoutStartCode)) continue;
                ServerName destination = null;
                destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(0));
                if (destination == null) {
                    if (currentServerWithoutStartCode.equals((Object)favoredNodes.get(1)) || currentServerWithoutStartCode.equals((Object)favoredNodes.get(2))) continue;
                    ServerLoad l1 = this.services.getServerManager().getLoad((ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1)));
                    ServerLoad l2 = this.services.getServerManager().getLoad((ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2)));
                    if (l1 != null && l2 != null) {
                        destination = l1.getLoad() > l2.getLoad() ? (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2)) : (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1));
                    } else if (l1 != null) {
                        destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(1));
                    } else if (l2 != null) {
                        destination = (ServerName)serverNameWithoutCodeToServerName.get(favoredNodes.get(2));
                    }
                }
                if (destination == null) continue;
                RegionPlan plan = new RegionPlan(region, currentServer, destination);
                plans.add(plan);
            }
        }
        return plans;
    }

    @Override
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        Map<ServerName, List<RegionInfo>> assignmentMap;
        try {
            FavoredNodeAssignmentHelper assignmentHelper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
            assignmentHelper.initialize();
            if (!assignmentHelper.canPlaceFavoredNodes()) {
                return super.roundRobinAssignment(regions, servers);
            }
            Pair<Map<ServerName, List<RegionInfo>>, List<RegionInfo>> segregatedRegions = this.segregateRegionsAndAssignRegionsWithFavoredNodes(regions, servers);
            Map regionsWithFavoredNodesMap = (Map)segregatedRegions.getFirst();
            List regionsWithNoFavoredNodes = (List)segregatedRegions.getSecond();
            assignmentMap = new HashMap<ServerName, List<RegionInfo>>();
            this.roundRobinAssignmentImpl(assignmentHelper, assignmentMap, regionsWithNoFavoredNodes, servers);
            assignmentMap.putAll(regionsWithFavoredNodesMap);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Encountered exception while doing favored-nodes assignment " + ex + " Falling back to regular assignment"));
            assignmentMap = super.roundRobinAssignment(regions, servers);
        }
        return assignmentMap;
    }

    @Override
    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) throws HBaseIOException {
        try {
            FavoredNodeAssignmentHelper assignmentHelper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
            assignmentHelper.initialize();
            ServerName primary = super.randomAssignment(regionInfo, servers);
            if (!FavoredNodesManager.isFavoredNodeApplicable(regionInfo) || !assignmentHelper.canPlaceFavoredNodes()) {
                return primary;
            }
            List<ServerName> favoredNodes = this.fnm.getFavoredNodes(regionInfo);
            if (favoredNodes != null) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.availableServersContains(servers, s);
                    if (serverWithLegitStartCode == null) continue;
                    return serverWithLegitStartCode;
                }
            }
            ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(1);
            regions.add(regionInfo);
            HashMap<RegionInfo, ServerName> primaryRSMap = new HashMap<RegionInfo, ServerName>(1);
            primaryRSMap.put(regionInfo, primary);
            this.assignSecondaryAndTertiaryNodesForRegion(assignmentHelper, regions, primaryRSMap);
            return primary;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Encountered exception while doing favored-nodes (random)assignment " + ex + " Falling back to regular assignment"));
            return super.randomAssignment(regionInfo, servers);
        }
    }

    private Pair<Map<ServerName, List<RegionInfo>>, List<RegionInfo>> segregateRegionsAndAssignRegionsWithFavoredNodes(List<RegionInfo> regions, List<ServerName> availableServers) {
        HashMap<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes = new HashMap<ServerName, List<RegionInfo>>(regions.size() / 2);
        ArrayList<RegionInfo> regionsWithNoFavoredNodes = new ArrayList<RegionInfo>(regions.size() / 2);
        for (RegionInfo region : regions) {
            List<ServerName> favoredNodes = this.fnm.getFavoredNodes(region);
            ServerName primaryHost = null;
            ServerName secondaryHost = null;
            ServerName tertiaryHost = null;
            if (favoredNodes != null) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.availableServersContains(availableServers, s);
                    if (serverWithLegitStartCode == null) continue;
                    FavoredNodesPlan.Position position = FavoredNodesPlan.getFavoredServerPosition(favoredNodes, s);
                    if (FavoredNodesPlan.Position.PRIMARY.equals((Object)position)) {
                        primaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (FavoredNodesPlan.Position.SECONDARY.equals((Object)position)) {
                        secondaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (!FavoredNodesPlan.Position.TERTIARY.equals((Object)position)) continue;
                    tertiaryHost = serverWithLegitStartCode;
                }
                this.assignRegionToAvailableFavoredNode(assignmentMapForFavoredNodes, region, primaryHost, secondaryHost, tertiaryHost);
            }
            if (primaryHost != null || secondaryHost != null || tertiaryHost != null) continue;
            regionsWithNoFavoredNodes.add(region);
        }
        return new Pair(assignmentMapForFavoredNodes, regionsWithNoFavoredNodes);
    }

    private ServerName availableServersContains(List<ServerName> servers, ServerName favoredNode) {
        for (ServerName server : servers) {
            if (!ServerName.isSameAddress((ServerName)favoredNode, (ServerName)server)) continue;
            return server;
        }
        return null;
    }

    private void assignRegionToAvailableFavoredNode(Map<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes, RegionInfo region, ServerName primaryHost, ServerName secondaryHost, ServerName tertiaryHost) {
        if (primaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, primaryHost);
        } else if (secondaryHost != null && tertiaryHost != null) {
            ServerLoad tertiaryLoad = this.services.getServerManager().getLoad(tertiaryHost);
            ServerLoad secondaryLoad = this.services.getServerManager().getLoad(secondaryHost);
            ServerName s = secondaryLoad.getLoad() < tertiaryLoad.getLoad() ? secondaryHost : tertiaryHost;
            this.addRegionToMap(assignmentMapForFavoredNodes, region, s);
        } else if (secondaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, secondaryHost);
        } else if (tertiaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, tertiaryHost);
        }
    }

    private void addRegionToMap(Map<ServerName, List<RegionInfo>> assignmentMapForFavoredNodes, RegionInfo region, ServerName host) {
        List<RegionInfo> regionsOnServer = null;
        regionsOnServer = assignmentMapForFavoredNodes.get(host);
        if (regionsOnServer == null) {
            regionsOnServer = new ArrayList<RegionInfo>();
            assignmentMapForFavoredNodes.put(host, regionsOnServer);
        }
        regionsOnServer.add(region);
    }

    public synchronized List<ServerName> getFavoredNodes(RegionInfo regionInfo) {
        return this.fnm.getFavoredNodes(regionInfo);
    }

    private void roundRobinAssignmentImpl(FavoredNodeAssignmentHelper assignmentHelper, Map<ServerName, List<RegionInfo>> assignmentMap, List<RegionInfo> regions, List<ServerName> servers) throws IOException {
        HashMap<RegionInfo, ServerName> primaryRSMap = new HashMap<RegionInfo, ServerName>();
        assignmentHelper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        this.assignSecondaryAndTertiaryNodesForRegion(assignmentHelper, regions, primaryRSMap);
    }

    private void assignSecondaryAndTertiaryNodesForRegion(FavoredNodeAssignmentHelper assignmentHelper, List<RegionInfo> regions, Map<RegionInfo, ServerName> primaryRSMap) throws IOException {
        Map<RegionInfo, ServerName[]> secondaryAndTertiaryRSMap = assignmentHelper.placeSecondaryAndTertiaryRS(primaryRSMap);
        HashMap regionFNMap = Maps.newHashMap();
        for (RegionInfo region : regions) {
            ArrayList<ServerName> favoredNodesForRegion = new ArrayList<ServerName>(3);
            ServerName sn = primaryRSMap.get(region);
            favoredNodesForRegion.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)-1L));
            ServerName[] secondaryAndTertiaryNodes = secondaryAndTertiaryRSMap.get(region);
            if (secondaryAndTertiaryNodes != null) {
                favoredNodesForRegion.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[0].getHostname(), (int)secondaryAndTertiaryNodes[0].getPort(), (long)-1L));
                favoredNodesForRegion.add(ServerName.valueOf((String)secondaryAndTertiaryNodes[1].getHostname(), (int)secondaryAndTertiaryNodes[1].getPort(), (long)-1L));
            }
            regionFNMap.put(region, favoredNodesForRegion);
        }
        this.fnm.updateFavoredNodes(regionFNMap);
    }

    @Override
    public void generateFavoredNodesForDaughter(List<ServerName> servers, RegionInfo parent, RegionInfo regionA, RegionInfo regionB) throws IOException {
        HashMap<RegionInfo, List<ServerName>> result = new HashMap<RegionInfo, List<ServerName>>();
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
        helper.initialize();
        List<ServerName> parentFavoredNodes = this.getFavoredNodes(parent);
        if (parentFavoredNodes == null) {
            LOG.debug((Object)("Unable to find favored nodes for parent, " + parent + " generating new favored nodes for daughter"));
            result.put(regionA, helper.generateFavoredNodes(regionA));
            result.put(regionB, helper.generateFavoredNodes(regionB));
        } else {
            Set<ServerName> regionAFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.SECONDARY);
            result.put(regionA, Lists.newArrayList(regionAFN));
            Set<ServerName> regionBFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.TERTIARY);
            result.put(regionB, Lists.newArrayList(regionBFN));
        }
        this.fnm.updateFavoredNodes(result);
    }

    private Set<ServerName> getInheritedFNForDaughter(FavoredNodeAssignmentHelper helper, List<ServerName> parentFavoredNodes, FavoredNodesPlan.Position primary, FavoredNodesPlan.Position secondary) throws IOException {
        LinkedHashSet daughterFN = Sets.newLinkedHashSet();
        if (parentFavoredNodes.size() >= primary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(primary.ordinal()));
        }
        if (parentFavoredNodes.size() >= secondary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(secondary.ordinal()));
        }
        while (daughterFN.size() < 3) {
            ServerName newNode = helper.generateMissingFavoredNode(Lists.newArrayList((Iterable)daughterFN));
            daughterFN.add(newNode);
        }
        return daughterFN;
    }

    @Override
    public void generateFavoredNodesForMergedRegion(RegionInfo merged, RegionInfo regionA, RegionInfo regionB) throws IOException {
        HashMap regionFNMap = Maps.newHashMap();
        regionFNMap.put(merged, this.getFavoredNodes(regionA));
        this.fnm.updateFavoredNodes(regionFNMap);
    }

    @Override
    public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<RegionInfo>> clusterState) throws HBaseIOException {
        return this.balanceCluster(clusterState);
    }
}

