/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;

@InterfaceAudience.LimitedPrivate(value={"Coprocessor"})
public class StoreFileScanner
implements KeyValueScanner {
    private static final Log LOG = LogFactory.getLog(HStore.class);
    private final StoreFile.Reader reader;
    private final HFileScanner hfs;
    private Cell cur = null;
    private boolean closed = false;
    private boolean realSeekDone;
    private boolean delayedReseek;
    private Cell delayedSeekKV;
    private final boolean enforceMVCC;
    private final boolean hasMVCCInfo;
    private boolean stopSkippingKVsIfNextRow = false;
    private static AtomicLong seekCount;
    private final boolean canOptimizeForNonNullColumn;
    private final long readPt;
    private final long scannerOrder;

    public StoreFileScanner(StoreFile.Reader reader, HFileScanner hfs, boolean useMVCC, boolean hasMVCC, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        this.readPt = readPt;
        this.reader = reader;
        this.hfs = hfs;
        this.enforceMVCC = useMVCC;
        this.hasMVCCInfo = hasMVCC;
        this.scannerOrder = scannerOrder;
        this.canOptimizeForNonNullColumn = canOptimizeForNonNullColumn;
    }

    boolean isPrimaryReplica() {
        return this.reader.isPrimaryReplicaReader();
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, long readPt) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, false, false, readPt);
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, boolean useDropBehind, long readPt) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, useDropBehind, null, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, boolean canUseDrop, ScanQueryMatcher matcher, long readPt, boolean isPrimaryReplica) throws IOException {
        ArrayList<StoreFileScanner> scanners = new ArrayList<StoreFileScanner>(files.size());
        ArrayList<StoreFile> sorted_files = new ArrayList<StoreFile>(files);
        Collections.sort(sorted_files, StoreFile.Comparators.SEQ_ID);
        boolean succ = false;
        try {
            for (int i = 0; i < sorted_files.size(); ++i) {
                StoreFile.Reader r = ((StoreFile)sorted_files.get(i)).createReader(canUseDrop);
                r.setReplicaStoreFile(isPrimaryReplica);
                StoreFileScanner scanner = r.getStoreFileScanner(cacheBlocks, usePread, isCompaction, readPt, i, matcher != null ? !matcher.hasNullColumnInQuery() : false);
                scanners.add(scanner);
            }
            succ = true;
        }
        finally {
            if (!succ) {
                for (StoreFileScanner scanner : scanners) {
                    scanner.close();
                }
            }
        }
        return scanners;
    }

    public static List<StoreFileScanner> getScannersForStoreFiles(Collection<StoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, boolean canUseDrop, ScanQueryMatcher matcher, long readPt) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, canUseDrop, matcher, readPt, true);
    }

    public String toString() {
        return "StoreFileScanner[" + this.hfs.toString() + ", cur=" + this.cur + "]";
    }

    @Override
    public Cell peek() {
        return this.cur;
    }

    @Override
    public Cell next() throws IOException {
        Cell retKey = this.cur;
        try {
            if (this.cur != null) {
                this.hfs.next();
                this.setCurrentCell(this.hfs.getKeyValue());
                if (this.hasMVCCInfo || this.reader.isBulkLoaded()) {
                    this.skipKVsNewerThanReadpoint();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Could not iterate " + this, e);
        }
        return retKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean seek(Cell key) throws IOException {
        if (seekCount != null) {
            seekCount.incrementAndGet();
        }
        try {
            try {
                if (!StoreFileScanner.seekAtOrAfter(this.hfs, key)) {
                    this.cur = null;
                    boolean bl = false;
                    return bl;
                }
                this.setCurrentCell(this.hfs.getKeyValue());
                if (!this.hasMVCCInfo && this.reader.isBulkLoaded()) {
                    boolean bl = this.skipKVsNewerThanReadpoint();
                    return bl;
                }
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not seek " + this + " to key " + key, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reseek(Cell key) throws IOException {
        if (seekCount != null) {
            seekCount.incrementAndGet();
        }
        try {
            try {
                if (!StoreFileScanner.reseekAtOrAfter(this.hfs, key)) {
                    this.cur = null;
                    boolean bl = false;
                    return bl;
                }
                this.setCurrentCell(this.hfs.getKeyValue());
                if (!this.hasMVCCInfo && this.reader.isBulkLoaded()) {
                    boolean bl = this.skipKVsNewerThanReadpoint();
                    return bl;
                }
                boolean bl = !this.hasMVCCInfo ? true : this.skipKVsNewerThanReadpoint();
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not reseek " + this + " to key " + key, ioe);
        }
    }

    protected void setCurrentCell(Cell newVal) throws IOException {
        this.cur = newVal;
        if (this.cur != null && this.reader.isBulkLoaded()) {
            CellUtil.setSequenceId((Cell)this.cur, (long)this.reader.getSequenceID());
        }
    }

    protected boolean skipKVsNewerThanReadpoint() throws IOException {
        Cell startKV = this.cur;
        while (this.enforceMVCC && this.cur != null && this.cur.getMvccVersion() > this.readPt) {
            boolean hasNext = this.hfs.next();
            this.setCurrentCell(this.hfs.getKeyValue());
            if (!hasNext || !this.stopSkippingKVsIfNextRow || this.getComparator().compareRows(this.cur.getRowArray(), this.cur.getRowOffset(), (int)this.cur.getRowLength(), startKV.getRowArray(), startKV.getRowOffset(), (int)startKV.getRowLength()) <= 0) continue;
            return false;
        }
        return this.cur != null;
    }

    @Override
    public void close() {
        this.cur = null;
        if (this.closed) {
            return;
        }
        if (this.reader != null) {
            this.reader.decrementRefCount();
        }
        this.closed = true;
        this.hfs.close();
    }

    public static boolean seekAtOrAfter(HFileScanner s, Cell k) throws IOException {
        int result = s.seekTo(k);
        if (result < 0) {
            if (result == -2) {
                return true;
            }
            return s.seekTo();
        }
        if (result > 0) {
            return s.next();
        }
        return true;
    }

    static boolean reseekAtOrAfter(HFileScanner s, Cell k) throws IOException {
        int result = s.reseekTo(k);
        if (result <= 0) {
            if (result == -2) {
                return true;
            }
            if (!s.isSeeked()) {
                return s.seekTo();
            }
            return true;
        }
        return s.next();
    }

    @Override
    public long getScannerOrder() {
        return this.scannerOrder;
    }

    @Override
    public boolean requestSeek(Cell kv, boolean forward, boolean useBloom) throws IOException {
        if (kv.getFamilyLength() == 0) {
            useBloom = false;
        }
        boolean haveToSeek = true;
        if (useBloom) {
            if (this.reader.getBloomFilterType() == BloomType.ROWCOL) {
                haveToSeek = this.reader.passesGeneralBloomFilter(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
            } else if (this.canOptimizeForNonNullColumn && (CellUtil.isDeleteFamily((Cell)kv) || CellUtil.isDeleteFamilyVersion((Cell)kv))) {
                haveToSeek = this.reader.passesDeleteFamilyBloomFilter(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
            }
        }
        this.delayedReseek = forward;
        this.delayedSeekKV = kv;
        if (haveToSeek) {
            this.realSeekDone = false;
            long maxTimestampInFile = this.reader.getMaxTimestamp();
            long seekTimestamp = kv.getTimestamp();
            if (seekTimestamp > maxTimestampInFile) {
                this.setCurrentCell((Cell)KeyValueUtil.createFirstOnRowColTS((Cell)kv, (long)maxTimestampInFile));
            } else {
                this.enforceSeek();
            }
            return this.cur != null;
        }
        this.setCurrentCell((Cell)KeyValueUtil.createLastOnRowCol((Cell)kv));
        this.realSeekDone = true;
        return true;
    }

    StoreFile.Reader getReader() {
        return this.reader;
    }

    KeyValue.KVComparator getComparator() {
        return this.reader.getComparator();
    }

    @Override
    public boolean realSeekDone() {
        return this.realSeekDone;
    }

    @Override
    public void enforceSeek() throws IOException {
        if (this.realSeekDone) {
            return;
        }
        if (this.delayedReseek) {
            this.reseek(this.delayedSeekKV);
        } else {
            this.seek(this.delayedSeekKV);
        }
    }

    @Override
    public boolean isFileScanner() {
        return true;
    }

    static final long getSeekCount() {
        return seekCount.get();
    }

    static final void instrument() {
        seekCount = new AtomicLong();
    }

    @Override
    public boolean shouldUseScanner(Scan scan, Store store, long oldestUnexpiredTS) {
        byte[] cf = store.getFamily().getName();
        TimeRange timeRange = (TimeRange)scan.getColumnFamilyTimeRange().get(cf);
        if (timeRange == null) {
            timeRange = scan.getTimeRange();
        }
        return this.reader.passesTimerangeFilter(timeRange, oldestUnexpiredTS) && this.reader.passesKeyRangeFilter(scan) && this.reader.passesBloomFilter(scan, (SortedSet)scan.getFamilyMap().get(cf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean seekToPreviousRow(Cell originalKey) throws IOException {
        try {
            try {
                boolean keepSeeking = false;
                Cell key = originalKey;
                do {
                    boolean resultOfSkipKVs;
                    KeyValue seekKey = KeyValueUtil.createFirstOnRow((byte[])key.getRowArray(), (int)key.getRowOffset(), (short)key.getRowLength());
                    if (seekCount != null) {
                        seekCount.incrementAndGet();
                    }
                    if (!this.hfs.seekBefore(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength())) {
                        this.cur = null;
                        boolean bl = false;
                        return bl;
                    }
                    KeyValue firstKeyOfPreviousRow = KeyValueUtil.createFirstOnRow((byte[])this.hfs.getKeyValue().getRowArray(), (int)this.hfs.getKeyValue().getRowOffset(), (short)this.hfs.getKeyValue().getRowLength());
                    if (seekCount != null) {
                        seekCount.incrementAndGet();
                    }
                    if (!StoreFileScanner.seekAtOrAfter(this.hfs, (Cell)firstKeyOfPreviousRow)) {
                        this.close();
                        boolean bl = false;
                        return bl;
                    }
                    this.setCurrentCell(this.hfs.getKeyValue());
                    this.stopSkippingKVsIfNextRow = true;
                    try {
                        resultOfSkipKVs = this.skipKVsNewerThanReadpoint();
                    }
                    finally {
                        this.stopSkippingKVsIfNextRow = false;
                    }
                    if (!resultOfSkipKVs || this.getComparator().compareRows(this.cur, (Cell)firstKeyOfPreviousRow) > 0) {
                        keepSeeking = true;
                        key = firstKeyOfPreviousRow;
                        continue;
                    }
                    keepSeeking = false;
                } while (keepSeeking);
                boolean bl = true;
                return bl;
            }
            finally {
                this.realSeekDone = true;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new IOException("Could not seekToPreviousRow " + this + " to key " + originalKey, ioe);
        }
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        byte[] lastRow = this.reader.getLastRowKey();
        if (lastRow == null) {
            return false;
        }
        KeyValue seekKey = KeyValueUtil.createFirstOnRow((byte[])lastRow);
        if (this.seek((Cell)seekKey)) {
            return true;
        }
        return this.seekToPreviousRow((Cell)seekKey);
    }

    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        this.seek(key);
        if (this.cur == null || this.getComparator().compareRows(this.cur.getRowArray(), this.cur.getRowOffset(), (int)this.cur.getRowLength(), key.getRowArray(), key.getRowOffset(), (int)key.getRowLength()) > 0) {
            return this.seekToPreviousRow(key);
        }
        return true;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.hfs.getNextIndexedKey();
    }
}

