/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.exceptions.OperationConflictException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerIdGenerator;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenPriorityRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RSRpcServices
implements HBaseRPCErrorHandler,
AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
PriorityFunction,
ConfigurationObserver {
    protected static final Log LOG = LogFactory.getLog(RSRpcServices.class);
    public static final String REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.region.server.rpc.scheduler.factory.class";
    private static final String REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = "hbase.region.server.rpc.minimum.scan.time.limit.delta";
    private static final long DEFAULT_REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = 10L;
    static final String BATCH_ROWS_THRESHOLD_NAME = "hbase.rpc.rows.warning.threshold";
    static final int BATCH_ROWS_THRESHOLD_DEFAULT = 5000;
    final Counter requestCount = new Counter();
    final Counter rpcGetRequestCount = new Counter();
    final Counter rpcScanRequestCount = new Counter();
    final Counter rpcMultiRequestCount = new Counter();
    final Counter rpcMutateRequestCount = new Counter();
    final RpcServerInterface rpcServer;
    final InetSocketAddress isa;
    private final HRegionServer regionServer;
    private final long maxScannerResultSize;
    private final PriorityFunction priority;
    private ScannerIdGenerator scannerIdGenerator;
    private final ConcurrentMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap<String, RegionScannerHolder>();
    private final Cache<String, String> closedScanners;
    private final int scannerLeaseTimeoutPeriod;
    private final int rpcTimeout;
    private final long minimumScanTimeLimitDelta;
    private final int rowSizeWarnThreshold;
    private static LogDelegate DEFAULT_LOG_DELEGATE = new LogDelegate(){

        @Override
        public void logBatchWarning(String firstRegionName, int sum, int rowSizeWarnThreshold) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Large batch operation detected (greater than " + rowSizeWarnThreshold + ") (HBASE-18023)." + " Requested Number of Rows: " + sum + " Client: " + RpcServer.getRequestUserName() + "/" + RpcServer.getRemoteAddress() + " first region in multi=" + firstRegionName));
            }
        }
    };
    private final LogDelegate ld;
    @Deprecated
    private static final IOException SCANNER_ALREADY_CLOSED = new IOException(){
        private static final long serialVersionUID = -4305297078988180130L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.Result r, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((ClientProtos.Result)r), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((Throwable)e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }

    private boolean startNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup) throws IOException, OperationConflictException {
        if (this.regionServer.nonceManager == null || !mutation.hasNonce()) {
            return true;
        }
        boolean canProceed = false;
        try {
            canProceed = this.regionServer.nonceManager.startOperation(nonceGroup, mutation.getNonce(), this.regionServer);
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("Nonce start operation interrupted");
        }
        return canProceed;
    }

    private void endNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup, boolean success) {
        if (this.regionServer.nonceManager != null && mutation.hasNonce()) {
            this.regionServer.nonceManager.endOperation(nonceGroup, mutation.getNonce(), success);
        }
    }

    private boolean isClientCellBlockSupport() {
        return this.isClientCellBlockSupport(RpcServer.getCurrentCall());
    }

    private boolean isClientCellBlockSupport(RpcCallContext context) {
        return context != null && context.isClientCellBlockSupported();
    }

    private void addResult(ClientProtos.MutateResponse.Builder builder, Result result, HBaseRpcController rpcc) {
        if (result == null) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            builder.setResult(ProtobufUtil.toResultNoData((Result)result));
            rpcc.setCellScanner(result.cellScanner());
        } else {
            ClientProtos.Result pbr = ProtobufUtil.toResult((Result)result);
            builder.setResult(pbr);
        }
    }

    private void addResults(ClientProtos.ScanResponse.Builder builder, List<Result> results, HBaseRpcController controller, boolean isDefaultRegion) {
        builder.setStale(!isDefaultRegion);
        if (results.isEmpty()) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            for (Result res : results) {
                builder.addCellsPerResult(res.size());
                builder.addPartialFlagPerResult(res.mayHaveMoreCellsInRow());
            }
            controller.setCellScanner(CellUtil.createCellScanner(results));
        } else {
            for (Result res : results) {
                ClientProtos.Result pbr = ProtobufUtil.toResult((Result)res);
                builder.addResults(pbr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutateRows(Region region, List<ClientProtos.Action> actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder) throws IOException {
        int countOfCompleteMutation = 0;
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            RowMutations rm = null;
            int i = 0;
            ClientProtos.ResultOrException.Builder resultOrExceptionOrBuilder = ClientProtos.ResultOrException.newBuilder();
            for (ClientProtos.Action action : actions) {
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                if (rm == null) {
                    rm = new RowMutations(action.getMutation().getRow().toByteArray());
                }
                switch (type) {
                    case PUT: {
                        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, (Mutation)put);
                        rm.add(put);
                        break;
                    }
                    case DELETE: {
                        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        rm.add(delete);
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
                    }
                }
                resultOrExceptionOrBuilder.clear();
                resultOrExceptionOrBuilder.setIndex(i++);
                builder.addResultOrException(resultOrExceptionOrBuilder.build());
            }
            region.mutateRow(rm);
        }
        finally {
            for (int i = countOfCompleteMutation; i < actions.size(); ++i) {
                this.skipCellsForMutation(actions.get(i), cellScanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndRowMutate(Region region, List<ClientProtos.Action> actions, CellScanner cellScanner, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, ClientProtos.RegionActionResult.Builder builder) throws IOException {
        int countOfCompleteMutation = 0;
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            RowMutations rm = null;
            int i = 0;
            ClientProtos.ResultOrException.Builder resultOrExceptionOrBuilder = ClientProtos.ResultOrException.newBuilder();
            for (ClientProtos.Action action : actions) {
                if (action.hasGet()) {
                    throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
                }
                ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                if (rm == null) {
                    rm = new RowMutations(action.getMutation().getRow().toByteArray());
                }
                switch (type) {
                    case PUT: {
                        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        this.checkCellSizeLimit(region, (Mutation)put);
                        rm.add(put);
                        break;
                    }
                    case DELETE: {
                        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner);
                        ++countOfCompleteMutation;
                        rm.add(delete);
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
                    }
                }
                resultOrExceptionOrBuilder.clear();
                resultOrExceptionOrBuilder.setIndex(i++);
                builder.addResultOrException(resultOrExceptionOrBuilder.build());
            }
            boolean bl = region.checkAndRowMutate(row, family, qualifier, compareOp, comparator, rm, Boolean.TRUE);
            return bl;
        }
        finally {
            for (int i = countOfCompleteMutation; i < actions.size(); ++i) {
                this.skipCellsForMutation(actions.get(i), cellScanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result append(Region region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
        this.checkCellSizeLimit(region, (Mutation)append);
        quota.addMutation((Mutation)append);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preAppend(append);
        }
        if (r == null) {
            boolean canProceed = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                long nonce;
                long l = nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                if (canProceed) {
                    r = region.append(append, nonceGroup, nonce);
                } else {
                    List<Cell> results = region.get(ProtobufUtil.toGet((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner), false, nonceGroup, nonce);
                    r = Result.create(results);
                }
                success = true;
            }
            finally {
                if (canProceed) {
                    this.endNonceOperation(mutation, nonceGroup, success);
                }
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postAppend(append, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateAppend(region.getTableDesc().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result increment(Region region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cellScanner, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
        this.checkCellSizeLimit(region, (Mutation)increment);
        quota.addMutation((Mutation)increment);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preIncrement(increment);
        }
        if (r == null) {
            boolean canProceed = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                long nonce;
                long l = nonce = mutation.hasNonce() ? mutation.getNonce() : 0L;
                if (canProceed) {
                    r = region.increment(increment, nonceGroup, nonce);
                } else {
                    List<Cell> results = region.get(ProtobufUtil.toGet((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner), false, nonceGroup, nonce);
                    r = Result.create(results);
                }
                success = true;
            }
            finally {
                if (canProceed) {
                    this.endNonceOperation(mutation, nonceGroup, success);
                }
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postIncrement(increment, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateIncrement(region.getTableDesc().getTableName(), EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CellScannable> doNonAtomicRegionMutation(Region region, OperationQuota quota, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, long nonceGroup) {
        ArrayList<ClientProtos.Action> mutations = null;
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        RpcCallContext context = RpcServer.getCurrentCall();
        MultiActionResultTooLarge sizeIOE = null;
        Object lastBlock = null;
        ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
        boolean hasResultOrException = false;
        for (ClientProtos.Action action : actions.getActionList()) {
            HBaseProtos.NameBytesPair pair;
            hasResultOrException = false;
            resultOrExceptionBuilder.clear();
            try {
                Result r = null;
                if (context != null && context.isRetryImmediatelySupported() && (context.getResponseCellSize() > maxQuotaResultSize || context.getResponseBlockSize() + context.getResponseExceptionSize() > maxQuotaResultSize)) {
                    if (sizeIOE == null) {
                        sizeIOE = new MultiActionResultTooLarge("Max size exceeded CellSize: " + context.getResponseCellSize() + " BlockSize: " + context.getResponseBlockSize());
                        this.rpcServer.getMetrics().exception((Throwable)sizeIOE);
                    }
                    hasResultOrException = true;
                    pair = ResponseConverter.buildException(sizeIOE);
                    resultOrExceptionBuilder.setException(pair);
                    context.incrementResponseExceptionSize(pair.getSerializedSize());
                    resultOrExceptionBuilder.setIndex(action.getIndex());
                    builder.addResultOrException(resultOrExceptionBuilder.build());
                    this.skipCellsForMutation(action, cellScanner);
                    continue;
                }
                if (action.hasGet()) {
                    long before = EnvironmentEdgeManager.currentTime();
                    try {
                        Get get = ProtobufUtil.toGet((ClientProtos.Get)action.getGet());
                        r = region.get(get);
                    }
                    finally {
                        if (this.regionServer.metricsRegionServer != null) {
                            this.regionServer.metricsRegionServer.updateGet(region.getTableDesc().getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                } else if (action.hasServiceCall()) {
                    hasResultOrException = true;
                    try {
                        Message result = this.execServiceOnRegion(region, action.getServiceCall());
                        ClientProtos.CoprocessorServiceResult.Builder serviceResultBuilder = ClientProtos.CoprocessorServiceResult.newBuilder();
                        resultOrExceptionBuilder.setServiceResult(serviceResultBuilder.setValue(serviceResultBuilder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString())));
                    }
                    catch (IOException ioe) {
                        this.rpcServer.getMetrics().exception(ioe);
                        HBaseProtos.NameBytesPair pair2 = ResponseConverter.buildException((Throwable)ioe);
                        resultOrExceptionBuilder.setException(pair2);
                        context.incrementResponseExceptionSize(pair2.getSerializedSize());
                    }
                } else if (action.hasMutation()) {
                    ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                    if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE && mutations != null && !mutations.isEmpty()) {
                        this.doBatchOp(builder, region, quota, mutations, cellScanner);
                        mutations.clear();
                    }
                    switch (type) {
                        case APPEND: {
                            r = this.append(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case INCREMENT: {
                            r = this.increment(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case PUT: 
                        case DELETE: {
                            if (mutations == null) {
                                mutations = new ArrayList<ClientProtos.Action>(actions.getActionCount());
                            }
                            mutations.add(action);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                } else {
                    throw new HBaseIOException("Unexpected Action type");
                }
                if (r != null) {
                    ClientProtos.Result pbResult = null;
                    if (this.isClientCellBlockSupport()) {
                        pbResult = ProtobufUtil.toResultNoData((Result)r);
                        if (cellsToReturn == null) {
                            cellsToReturn = new ArrayList<CellScannable>();
                        }
                        cellsToReturn.add((CellScannable)r);
                    } else {
                        pbResult = ProtobufUtil.toResult((Result)r);
                    }
                    lastBlock = this.addSize(context, r, lastBlock);
                    hasResultOrException = true;
                    resultOrExceptionBuilder.setResult(pbResult);
                }
            }
            catch (IOException ie) {
                this.rpcServer.getMetrics().exception(ie);
                hasResultOrException = true;
                pair = ResponseConverter.buildException((Throwable)ie);
                resultOrExceptionBuilder.setException(pair);
                context.incrementResponseExceptionSize(pair.getSerializedSize());
            }
            if (!hasResultOrException) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (mutations != null && !mutations.isEmpty()) {
            this.doBatchOp(builder, region, quota, (List<ClientProtos.Action>)mutations, cellScanner);
        }
        return cellsToReturn;
    }

    private void checkCellSizeLimit(Region region, Mutation m) throws IOException {
        if (!(region instanceof HRegion)) {
            return;
        }
        HRegion r = (HRegion)region;
        if (r.maxCellSize > 0L) {
            CellScanner cells = m.cellScanner();
            while (cells.advance()) {
                int size = CellUtil.estimatedSerializedSizeOf((Cell)cells.current());
                if ((long)size <= r.maxCellSize) continue;
                String msg = "Cell with size " + size + " exceeds limit of " + r.maxCellSize + " bytes";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msg);
                }
                throw new DoNotRetryIOException(msg);
            }
        }
    }

    private void doBatchOp(ClientProtos.RegionActionResult.Builder builder, Region region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells) {
        Object[] mArray = new Mutation[mutations.size()];
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            HashMap<Put, ClientProtos.Action> mutationActionMap = new HashMap<Put, ClientProtos.Action>();
            int i = 0;
            for (ClientProtos.Action action : mutations) {
                Put mutation;
                ClientProtos.MutationProto m = action.getMutation();
                if (m.getMutateType() == ClientProtos.MutationProto.MutationType.PUT) {
                    mutation = ProtobufUtil.toPut((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsPuts = true;
                } else {
                    mutation = ProtobufUtil.toDelete((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsDelete = true;
                }
                mutationActionMap.put(mutation, action);
                mArray[i++] = mutation;
                this.checkCellSizeLimit(region, (Mutation)mutation);
                quota.addMutation((Mutation)mutation);
            }
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            Arrays.sort(mArray);
            OperationStatus[] codes = region.batchMutate((Mutation[])mArray, 0L, 0L);
            block8: for (i = 0; i < codes.length; ++i) {
                Object currentMutation = mArray[i];
                ClientProtos.Action currentAction = (ClientProtos.Action)mutationActionMap.get(currentMutation);
                int index = currentAction.getIndex();
                NoSuchColumnFamilyException e = null;
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        e = new NoSuchColumnFamilyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SANITY_CHECK_FAILURE: {
                        e = new FailedSanityCheckException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    default: {
                        e = new DoNotRetryIOException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SUCCESS: {
                        builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), index));
                    }
                }
            }
        }
        catch (IOException ie) {
            int processedMutationIndex = 0;
            for (ClientProtos.Action mutation : mutations) {
                if (mArray[processedMutationIndex++] == null) {
                    this.skipCellsForMutation(mutation, cells);
                }
                builder.addResultOrException(RSRpcServices.getResultOrException(ie, mutation.getIndex()));
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            if (batchContainsPuts) {
                this.regionServer.metricsRegionServer.updatePutBatch(region.getTableDesc().getTableName(), after - before);
            }
            if (batchContainsDelete) {
                this.regionServer.metricsRegionServer.updateDeleteBatch(region.getTableDesc().getTableName(), after - before);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus[] doReplayBatchOp(Region region, List<WALSplitter.MutationReplay> mutations, long replaySeqId) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            Iterator<WALSplitter.MutationReplay> it = mutations.iterator();
            while (it.hasNext()) {
                NavigableMap map;
                List metaCells;
                WALSplitter.MutationReplay m = it.next();
                if (m.type == ClientProtos.MutationProto.MutationType.PUT) {
                    batchContainsPuts = true;
                } else {
                    batchContainsDelete = true;
                }
                if ((metaCells = (List)(map = m.mutation.getFamilyCellMap()).get(WALEdit.METAFAMILY)) == null || metaCells.isEmpty()) continue;
                for (Cell metaCell : metaCells) {
                    WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction(metaCell);
                    boolean isDefaultReplica = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
                    HRegion hRegion = (HRegion)region;
                    if (compactionDesc != null) {
                        hRegion.replayWALCompactionMarker(compactionDesc, !isDefaultReplica, isDefaultReplica, replaySeqId);
                        continue;
                    }
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor(metaCell);
                    if (flushDesc != null && !isDefaultReplica) {
                        hRegion.replayWALFlushMarker(flushDesc, replaySeqId);
                        continue;
                    }
                    WALProtos.RegionEventDescriptor regionEvent = WALEdit.getRegionEventDescriptor(metaCell);
                    if (regionEvent != null && !isDefaultReplica) {
                        hRegion.replayWALRegionEventMarker(regionEvent);
                        continue;
                    }
                    WALProtos.BulkLoadDescriptor bulkLoadEvent = WALEdit.getBulkLoadDescriptor(metaCell);
                    if (bulkLoadEvent == null) continue;
                    hRegion.replayWALBulkLoadEventMarker(bulkLoadEvent);
                }
                it.remove();
            }
            this.requestCount.increment();
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] operationStatusArray = region.batchReplay(mutations.toArray(new WALSplitter.MutationReplay[mutations.size()]), replaySeqId);
            return operationStatusArray;
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                long after = EnvironmentEdgeManager.currentTime();
                if (batchContainsPuts) {
                    this.regionServer.metricsRegionServer.updatePutBatch(region.getTableDesc().getTableName(), after - before);
                }
                if (batchContainsDelete) {
                    this.regionServer.metricsRegionServer.updateDeleteBatch(region.getTableDesc().getTableName(), after - before);
                }
            }
        }
    }

    private void closeAllScanners() {
        for (Map.Entry e : this.scanners.entrySet()) {
            try {
                ((RegionScannerHolder)e.getValue()).s.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + (String)e.getKey()), (Throwable)ioe);
            }
        }
    }

    public RSRpcServices(HRegionServer rs) throws IOException {
        this(rs, DEFAULT_LOG_DELEGATE);
    }

    RSRpcServices(HRegionServer rs, LogDelegate ld) throws IOException {
        InetSocketAddress bindAddress;
        InetSocketAddress initialIsa;
        int port;
        String hostname;
        RpcSchedulerFactory rpcSchedulerFactory;
        this.ld = ld;
        this.regionServer = rs;
        this.rowSizeWarnThreshold = rs.conf.getInt(BATCH_ROWS_THRESHOLD_NAME, 5000);
        try {
            Class rpcSchedulerFactoryClass = rs.conf.getClass(REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
            rpcSchedulerFactory = (RpcSchedulerFactory)rpcSchedulerFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this instanceof MasterRpcServices) {
            hostname = RSRpcServices.getHostname(rs.conf, true);
            port = rs.conf.getInt("hbase.master.port", 16000);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.master.ipc.address", hostname), port);
        } else {
            hostname = RSRpcServices.getHostname(rs.conf, false);
            port = rs.conf.getInt("hbase.regionserver.port", 16020);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.regionserver.ipc.address", hostname), port);
        }
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = this.createPriority();
        String name = rs.getProcessName() + "/" + initialIsa.toString();
        ConnectionUtils.setServerSideHConnectionRetriesConfig((Configuration)rs.conf, (String)name, (Log)LOG);
        try {
            this.rpcServer = new RpcServer(rs, name, this.getServices(), bindAddress, rs.conf, rpcSchedulerFactory.create(rs.conf, this, rs));
            this.rpcServer.setRsRpcServices(this);
        }
        catch (BindException be) {
            String configName = this instanceof MasterRpcServices ? "hbase.master.port" : "hbase.regionserver.port";
            throw new IOException(be.getMessage() + ". To switch ports use the '" + configName + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
        this.scannerLeaseTimeoutPeriod = rs.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.maxScannerResultSize = rs.conf.getLong("hbase.server.scanner.max.result.size", 0x6400000L);
        this.rpcTimeout = rs.conf.getInt("hbase.rpc.timeout", 60000);
        this.minimumScanTimeLimitDelta = rs.conf.getLong(REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA, 10L);
        InetSocketAddress address = this.rpcServer.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = new InetSocketAddress(initialIsa.getHostName(), address.getPort());
        this.rpcServer.setErrorHandler(this);
        rs.setName(name);
        this.closedScanners = CacheBuilder.newBuilder().expireAfterAccess((long)this.scannerLeaseTimeoutPeriod, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        if (this.rpcServer instanceof ConfigurationObserver) {
            ((ConfigurationObserver)((Object)this.rpcServer)).onConfigurationChange(newConf);
        }
    }

    protected PriorityFunction createPriority() {
        return new AnnotationReadingPriorityFunction(this);
    }

    public static String getHostname(Configuration conf, boolean isMaster) throws UnknownHostException {
        String hostname = conf.get(isMaster ? "hbase.master.hostname" : "hbase.regionserver.hostname");
        if (hostname == null || hostname.isEmpty()) {
            String masterOrRS = isMaster ? "master" : "regionserver";
            return Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase." + masterOrRS + ".dns.interface", "default"), (String)conf.get("hbase." + masterOrRS + ".dns.nameserver", "default")));
        }
        LOG.info((Object)("hostname is configured to be " + hostname));
        return hostname;
    }

    public RegionScanner getScanner(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = (RegionScannerHolder)this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.s;
        }
        return null;
    }

    public String getScanDetailsWithId(long scannerId) {
        RegionScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("table: ").append(scanner.getRegionInfo().getTable().getNameAsString());
        builder.append(" region: ").append(scanner.getRegionInfo().getRegionNameAsString());
        return builder.toString();
    }

    long getScannerVirtualTime(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = (RegionScannerHolder)this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.getNextCallSeq();
        }
        return 0L;
    }

    Object addSize(RpcCallContext context, Result r, Object lastBlock) {
        if (context != null && r != null && !r.isEmpty()) {
            for (Cell c : r.rawCells()) {
                context.incrementResponseCellSize(CellUtil.estimatedHeapSizeOf((Cell)c));
                byte[] valueArray = c.getValueArray();
                if (valueArray == lastBlock) continue;
                context.incrementResponseBlockSize(valueArray.length);
                lastBlock = valueArray;
            }
        }
        return lastBlock;
    }

    private RegionScannerHolder addScanner(String scannerName, RegionScanner s, Region r, boolean needCursor) throws Leases.LeaseStillHeldException {
        this.regionServer.leases.createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        RegionScannerHolder rsh = new RegionScannerHolder(scannerName, s, r, needCursor);
        RegionScannerHolder existing = this.scanners.putIfAbsent(scannerName, rsh);
        assert (existing == null) : "scannerId must be unique within regionserver's whole lifecycle!";
        return rsh;
    }

    @VisibleForTesting
    public Region getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        ByteString value = regionSpecifier.getValue();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = regionSpecifier.getType();
        switch (type) {
            case REGION_NAME: {
                byte[] regionName = value.toByteArray();
                String encodedRegionName = HRegionInfo.encodeRegionName((byte[])regionName);
                return this.regionServer.getRegionByEncodedName(regionName, encodedRegionName);
            }
            case ENCODED_REGION_NAME: {
                return this.regionServer.getRegionByEncodedName(value.toStringUtf8());
            }
        }
        throw new DoNotRetryIOException("Unsupported region specifier type: " + type);
    }

    @VisibleForTesting
    public PriorityFunction getPriority() {
        return this.priority;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.regionServer.getConfiguration();
    }

    private RegionServerQuotaManager getQuotaManager() {
        return this.regionServer.getRegionServerQuotaManager();
    }

    void start() {
        this.scannerIdGenerator = new ScannerIdGenerator(this.regionServer.serverName);
        this.rpcServer.start();
    }

    void stop() {
        this.closeAllScanners();
        this.rpcServer.stop();
    }

    protected void checkOpen() throws IOException {
        if (this.regionServer.isAborted()) {
            throw new RegionServerAbortedException("Server " + this.regionServer.serverName + " aborting");
        }
        if (this.regionServer.isStopped()) {
            throw new RegionServerStoppedException("Server " + this.regionServer.serverName + " stopping");
        }
        if (!this.regionServer.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
        if (!this.regionServer.isOnline()) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(2);
        bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this), ClientProtos.ClientService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        return bssi;
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        return this.priority.getPriority(header, param, user);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getDeadline(header, param);
    }

    @Override
    public boolean checkOOME(Throwable e) {
        return RSRpcServices.exitIfOOME(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exitIfOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.fatal((Object)("Run out of memory; " + RSRpcServices.class.getSimpleName() + " will abort itself immediately"), e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getDestinationServer()) : null;
        try {
            this.checkOpen();
            if (request.hasServerStartCode()) {
                long serverStartCode = request.getServerStartCode();
                if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                    throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
                }
            }
            String encodedRegionName = ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)request.getRegion());
            this.requestCount.increment();
            LOG.info((Object)("Close " + encodedRegionName + ", moving to " + sn));
            CloseRegionCoordination.CloseRegionDetails crd = this.regionServer.getCoordinatedStateManager().getCloseRegionCoordination().parseFromProtoRequest(request);
            boolean closed = this.regionServer.closeRegion(encodedRegionName, false, crd, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            String familyLogMsg;
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            region.startRegionOperation(Region.Operation.COMPACT_REGION);
            LOG.info((Object)("Compacting " + region.getRegionInfo().getRegionNameAsString()));
            boolean major = false;
            byte[] family = null;
            Store store = null;
            if (request.hasFamily() && (store = region.getStore(family = request.getFamily().toByteArray())) == null) {
                throw new ServiceException((Throwable)new IOException("column family " + Bytes.toString((byte[])family) + " does not exist in region " + region.getRegionInfo().getRegionNameAsString()));
            }
            if (request.hasMajor()) {
                major = request.getMajor();
            }
            if (major) {
                if (family != null) {
                    store.triggerMajorCompaction();
                } else {
                    region.triggerMajorCompaction();
                }
            }
            String string = familyLogMsg = family != null ? " for column family: " + Bytes.toString((byte[])family) : "";
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("User-triggered compaction requested for region " + region.getRegionInfo().getRegionNameAsString() + familyLogMsg));
            }
            String log = "User-triggered " + (major ? "major " : "") + "compaction" + familyLogMsg;
            if (family != null) {
                this.regionServer.compactSplitThread.requestCompaction(region, store, log, 1, null, RpcServer.getRequestUser());
            } else {
                this.regionServer.compactSplitThread.requestCompaction(region, log, 1, null, RpcServer.getRequestUser());
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            LOG.info((Object)("Flushing " + region.getRegionInfo().getRegionNameAsString()));
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getEarliestFlushTimeForAllStores() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean writeFlushWalMarker = request.hasWriteFlushWalMarker() ? request.getWriteFlushWalMarker() : false;
                HRegion.FlushResultImpl flushResult = (HRegion.FlushResultImpl)((HRegion)region).flushcache(true, writeFlushWalMarker);
                boolean compactionNeeded = flushResult.isCompactionNeeded();
                if (compactionNeeded) {
                    this.regionServer.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(flushResult.isFlushSucceeded());
                builder.setWroteFlushWalMarker(flushResult.wroteFlushWalMarker);
            }
            builder.setLastFlushTime(region.getEarliestFlushTimeForAllStores());
            return builder.build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Map<String, Region> onlineRegions = this.regionServer.onlineRegions;
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(onlineRegions.size());
            for (Region region : onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            Collections.sort(list);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            HRegionInfo info = region.getRegionInfo();
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(HRegionInfo.convert((HRegionInfo)info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(region.getCompactionState());
            }
            builder.setIsRecovering(region.isRecovering());
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.requestCount.increment();
        int infoPort = this.regionServer.infoServer != null ? this.regionServer.infoServer.getPort() : -1;
        return ResponseConverter.buildGetServerInfoResponse((ServerName)this.regionServer.serverName, (int)infoPort);
    }

    @QosPriority(priority=100)
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            TreeSet<byte[]> columnFamilies;
            this.checkOpen();
            Region region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getTableDesc().getFamiliesKeys();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region regionA = this.getRegion(request.getRegionA());
            Region regionB = this.getRegion(request.getRegionB());
            boolean forcible = request.getForcible();
            long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
            regionA.startRegionOperation(Region.Operation.MERGE_REGION);
            regionB.startRegionOperation(Region.Operation.MERGE_REGION);
            if (regionA.getRegionInfo().getReplicaId() != 0 || regionB.getRegionInfo().getReplicaId() != 0) {
                throw new ServiceException((Throwable)new MergeRegionException("Can't merge non-default replicas"));
            }
            LOG.info((Object)("Receiving merging request for  " + regionA + ", " + regionB + ",forcible=" + forcible));
            regionA.flush(true);
            regionB.flush(true);
            this.regionServer.compactSplitThread.requestRegionsMerge(regionA, regionB, forcible, masterSystemTime, RpcServer.getRequestUser());
            return AdminProtos.MergeRegionsResponse.newBuilder().build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QosPriority(priority=100)
    @SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="We double up use of an atomic both as monitor and condition variable")
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        this.requestCount.increment();
        if (request.hasServerStartCode()) {
            long serverStartCode = request.getServerStartCode();
            if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
            }
        }
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, HTableDescriptor> htds = new HashMap<TableName, HTableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            HBaseProtos.RegionInfo ri;
            TableName tableName = null;
            if (regionCount == 1 && (ri = request.getOpenInfo(0).getRegion()) != null) {
                tableName = ProtobufUtil.toTableName((TableProtos.TableName)ri.getTableName());
            }
            if (!TableName.META_TABLE_NAME.equals(tableName)) {
                throw new ServiceException((Throwable)ie);
            }
            int timeout = this.regionServer.conf.getInt("hbase.rpc.timeout", 60000) >> 2;
            long endTime = System.currentTimeMillis() + (long)timeout;
            AtomicBoolean atomicBoolean = this.regionServer.online;
            synchronized (atomicBoolean) {
                try {
                    while (System.currentTimeMillis() <= endTime && !this.regionServer.isStopped() && !this.regionServer.isOnline()) {
                        this.regionServer.online.wait(this.regionServer.msgInterval);
                    }
                    this.checkOpen();
                }
                catch (InterruptedException t) {
                    Thread.currentThread().interrupt();
                    throw new ServiceException((Throwable)t);
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
        long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionOpenInfo.getRegion());
            OpenRegionCoordination coordination = this.regionServer.getCoordinatedStateManager().getOpenRegionCoordination();
            OpenRegionCoordination.OpenRegionDetails ord = coordination.parseFromProtoRequest(regionOpenInfo);
            try {
                Boolean previous;
                Region onlineRegion = this.regionServer.getFromOnlineRegions(region.getEncodedName());
                if (onlineRegion != null) {
                    Pair p;
                    if (onlineRegion.getCoprocessorHost() != null) {
                        onlineRegion.getCoprocessorHost().preOpen();
                    }
                    if (this.regionServer.serverName.equals((p = MetaTableAccessor.getRegion((Connection)this.regionServer.getConnection(), (byte[])region.getRegionName())).getSecond())) {
                        Boolean closing = (Boolean)this.regionServer.regionsInTransitionInRS.get(region.getEncodedNameAsBytes());
                        if (!Boolean.FALSE.equals(closing) && this.regionServer.getFromOnlineRegions(region.getEncodedName()) != null) {
                            LOG.warn((Object)("Attempted open of " + region.getEncodedName() + " but already online on this server"));
                            builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED);
                            continue;
                        }
                    } else {
                        LOG.warn((Object)("The region " + region.getEncodedName() + " is online on this server" + " but hbase:meta does not have this server - continue opening."));
                        this.regionServer.removeFromOnlineRegions(onlineRegion, null);
                    }
                }
                LOG.info((Object)("Open " + region.getRegionNameAsString()));
                HTableDescriptor htd = (HTableDescriptor)htds.get(region.getTable());
                if (htd == null) {
                    htd = this.regionServer.tableDescriptors.get(region.getTable());
                    htds.put(region.getTable(), htd);
                }
                if (Boolean.FALSE.equals(previous = this.regionServer.regionsInTransitionInRS.putIfAbsent(region.getEncodedNameAsBytes(), Boolean.TRUE))) {
                    coordination.tryTransitionFromOfflineToFailedOpen(this.regionServer, region, ord);
                    throw new RegionAlreadyInTransitionException("Received OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to CLOSE ");
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info((Object)("Receiving OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to OPEN" + " - ignoring this new request for this region."));
                }
                this.regionServer.removeFromMovedRegions(region.getEncodedName());
                if (previous == null) {
                    if (ZKSplitLog.isRegionMarkedRecoveringInZK(this.regionServer.getZooKeeper(), region.getEncodedName())) {
                        if (!regionOpenInfo.hasOpenForDistributedLogReplay() || regionOpenInfo.getOpenForDistributedLogReplay()) {
                            this.regionServer.recoveringRegions.put(region.getEncodedName(), null);
                        } else {
                            ArrayList<String> tmpRegions = new ArrayList<String>();
                            tmpRegions.add(region.getEncodedName());
                            ZKSplitLog.deleteRecoveringRegionZNodes(this.regionServer.getZooKeeper(), tmpRegions);
                        }
                    }
                    if (htd == null) {
                        throw new IOException("Missing table descriptor for " + region.getEncodedName());
                    }
                    if (region.isMetaRegion()) {
                        this.regionServer.service.submit(new OpenMetaHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime, coordination, ord));
                    } else {
                        this.regionServer.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        if (htd.getPriority() >= 100 || region.getTable().isSystemTable()) {
                            this.regionServer.service.submit(new OpenPriorityRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime, coordination, ord));
                        } else {
                            this.regionServer.service.submit(new OpenRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime, coordination, ord));
                        }
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (KeeperException zooKeeperEx) {
                LOG.error((Object)"Can't retrieve recovering state from zookeeper", (Throwable)zooKeeperEx);
                throw new ServiceException((Throwable)zooKeeperEx);
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed opening region " + region.getRegionNameAsString()), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException((Throwable)ie);
            }
        }
        return builder.build();
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        HBaseProtos.RegionInfo regionInfo = request.getRegionInfo();
        HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionInfo);
        AdminProtos.WarmupRegionResponse response = AdminProtos.WarmupRegionResponse.getDefaultInstance();
        try {
            this.checkOpen();
            String encodedName = region.getEncodedName();
            byte[] encodedNameBytes = region.getEncodedNameAsBytes();
            Region onlineRegion = this.regionServer.getFromOnlineRegions(encodedName);
            if (onlineRegion != null) {
                LOG.info((Object)("Region already online. Skipping warming up " + region));
                return response;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Warming up Region " + region.getRegionNameAsString()));
            }
            HTableDescriptor htd = this.regionServer.tableDescriptors.get(region.getTable());
            if (this.regionServer.getRegionsInTransitionInRS().containsKey(encodedNameBytes)) {
                LOG.info((Object)("Region is in transition. Skipping warmup " + region));
                return response;
            }
            HRegion.warmupHRegion(region, htd, this.regionServer.getWAL(region), this.regionServer.getConfiguration(), this.regionServer, null);
        }
        catch (IOException ie) {
            LOG.error((Object)("Failed warming up region " + region.getRegionNameAsString()), (Throwable)ie);
            throw new ServiceException((Throwable)ie);
        }
        return response;
    }

    @QosPriority(priority=6)
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        CellScanner cells = ((HBaseRpcController)controller).cellScanner();
        try {
            this.checkOpen();
            List entries = request.getEntryList();
            if (entries == null || entries.isEmpty()) {
                AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
                return replicateWALEntryResponse;
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            Region region = this.regionServer.getRegionByEncodedName(regionName.toStringUtf8());
            RegionCoprocessorHost coprocessorHost = ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()) ? region.getCoprocessorHost() : null;
            ArrayList<Pair> walEntries = new ArrayList<Pair>();
            boolean isPrimary = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
            Durability durability = isPrimary ? Durability.USE_DEFAULT : Durability.SKIP_WAL;
            for (AdminProtos.WALEntry entry : entries) {
                if (!regionName.equals((Object)entry.getKey().getEncodedRegionName())) {
                    throw new NotServingRegionException("Replay request contains entries from multiple regions. First region:" + regionName.toStringUtf8() + " , other region:" + entry.getKey().getEncodedRegionName());
                }
                if (this.regionServer.nonceManager != null && isPrimary) {
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    this.regionServer.nonceManager.reportOperationFromWal(nonceGroup, nonce, entry.getKey().getWriteTime());
                }
                Pair walEntry = coprocessorHost == null ? null : new Pair();
                List<WALSplitter.MutationReplay> edits = WALSplitter.getMutationsFromWALEntry(entry, cells, (Pair<WALKey, WALEdit>)walEntry, durability);
                if (coprocessorHost != null) {
                    if (coprocessorHost.preWALRestore(region.getRegionInfo(), (WALKey)walEntry.getFirst(), (WALEdit)walEntry.getSecond())) continue;
                    walEntries.add(walEntry);
                }
                if (edits == null || edits.isEmpty()) continue;
                Collections.sort(edits);
                long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
                OperationStatus[] result = this.doReplayBatchOp(region, edits, replaySeqId);
                for (int i = 0; result != null && i < result.length; ++i) {
                    if (result[i] == OperationStatus.SUCCESS) continue;
                    throw new IOException(result[i].getExceptionMsg());
                }
            }
            WAL wal = this.getWAL(region);
            if (wal != null) {
                wal.sync();
            }
            if (coprocessorHost != null) {
                for (Pair entry : walEntries) {
                    coprocessorHost.postWALRestore(region.getRegionInfo(), (WALKey)entry.getFirst(), (WALEdit)entry.getSecond());
                }
            }
            AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            return replicateWALEntryResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTime() - before);
            }
        }
    }

    WAL getWAL(Region region) {
        return ((HRegion)region).getWAL();
    }

    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            this.checkOpen();
            if (this.regionServer.replicationSinkHandler != null) {
                this.requestCount.increment();
                List entries = request.getEntryList();
                CellScanner cellScanner = ((HBaseRpcController)controller).cellScanner();
                this.regionServer.getRegionServerCoprocessorHost().preReplicateLogEntries(entries, cellScanner);
                this.regionServer.replicationSinkHandler.replicateLogEntries(entries, cellScanner, request.getReplicationClusterId(), request.getSourceBaseNamespaceDirPath(), request.getSourceHFileArchiveDirPath());
                this.regionServer.getRegionServerCoprocessorHost().postReplicateLogEntries(entries, cellScanner);
                return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            }
            throw new ServiceException("Replication services are not initialized yet");
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.regionServer.getRegionServerCoprocessorHost().preRollWALWriterRequest();
            this.regionServer.walRoller.requestRollAll();
            this.regionServer.getRegionServerCoprocessorHost().postRollWALWriterRequest();
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            region.startRegionOperation(Region.Operation.SPLIT_REGION);
            if (region.getRegionInfo().getReplicaId() != 0) {
                throw new IOException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
            }
            LOG.info((Object)("Splitting " + region.getRegionInfo().getRegionNameAsString()));
            region.flush(true);
            byte[] splitPoint = null;
            if (request.hasSplitPoint()) {
                splitPoint = request.getSplitPoint().toByteArray();
            }
            ((HRegion)region).forceSplit(splitPoint);
            this.regionServer.compactSplitThread.requestSplit(region, ((HRegion)region).checkSplit(), RpcServer.getRequestUser());
            return AdminProtos.SplitRegionResponse.newBuilder().build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.requestCount.increment();
        String reason = request.getReason();
        this.regionServer.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        List openInfoList = request.getUpdateInfoList();
        AdminProtos.UpdateFavoredNodesResponse.Builder respBuilder = AdminProtos.UpdateFavoredNodesResponse.newBuilder();
        for (AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo regionUpdateInfo : openInfoList) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionUpdateInfo.getRegion());
            this.regionServer.updateRegionFavoredNodesMapping(hri.getEncodedName(), regionUpdateInfo.getFavoredNodesList());
        }
        respBuilder.setResponse(openInfoList.size());
        return respBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        long start = EnvironmentEdgeManager.currentTime();
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add((Pair<byte[], String>)new Pair((Object)familyPath.getFamily().toByteArray(), (Object)familyPath.getPath()));
            }
            boolean bypass = false;
            if (region.getCoprocessorHost() != null) {
                bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
            }
            boolean loaded = false;
            try {
                if (!bypass) {
                    loaded = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum(), null);
                }
            }
            finally {
                if (region.getCoprocessorHost() != null) {
                    loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
                }
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(loaded);
            ClientProtos.BulkLoadHFileResponse bulkLoadHFileResponse = builder.build();
            return bulkLoadHFileResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateBulkLoad(EnvironmentEdgeManager.currentTime() - start);
            }
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            Message result = this.execServiceOnRegion(region, request.getCall());
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])region.getRegionInfo().getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    private Message execServiceOnRegion(Region region, ClientProtos.CoprocessorServiceCall serviceCall) throws IOException {
        ServerRpcController execController = new ServerRpcController();
        return region.execService((RpcController)execController, serviceCall);
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        ClientProtos.GetResponse getResponse;
        OperationQuota quota;
        block22: {
            HTableDescriptor td;
            MetricsRegionServer mrs;
            long before = EnvironmentEdgeManager.currentTime();
            quota = null;
            Region region = null;
            try {
                ClientProtos.Result pbr;
                this.checkOpen();
                this.requestCount.increment();
                this.rpcGetRequestCount.increment();
                region = this.getRegion(request.getRegion());
                ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
                ClientProtos.Get get = request.getGet();
                Boolean existence = null;
                Result r = null;
                quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.GET);
                if (get.hasClosestRowBefore() && get.getClosestRowBefore()) {
                    if (get.getColumnCount() != 1) {
                        throw new DoNotRetryIOException("get ClosestRowBefore supports one and only one family now, not " + get.getColumnCount() + " families");
                    }
                    byte[] row = get.getRow().toByteArray();
                    byte[] family = get.getColumn(0).getFamily().toByteArray();
                    r = region.getClosestRowBefore(row, family);
                } else {
                    Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get);
                    if (get.getExistenceOnly() && region.getCoprocessorHost() != null) {
                        existence = region.getCoprocessorHost().preExists(clientGet);
                    }
                    if (existence == null) {
                        r = region.get(clientGet);
                        if (get.getExistenceOnly()) {
                            boolean exists = r.getExists();
                            if (region.getCoprocessorHost() != null) {
                                exists = region.getCoprocessorHost().postExists(clientGet, exists);
                            }
                            existence = exists;
                        }
                    }
                }
                if (existence != null) {
                    pbr = ProtobufUtil.toResult((boolean)existence, (region.getRegionInfo().getReplicaId() != 0 ? 1 : 0) != 0);
                    builder.setResult(pbr);
                } else if (r != null) {
                    RpcCallContext call = RpcServer.getCurrentCall();
                    if (this.isClientCellBlockSupport(call) && controller instanceof HBaseRpcController && VersionInfoUtil.hasMinimumVersion(call.getClientVersionInfo(), 1, 3)) {
                        pbr = ProtobufUtil.toResultNoData((Result)r);
                        ((HBaseRpcController)controller).setCellScanner(CellUtil.createCellScanner((Cell[])r.rawCells()));
                        this.addSize(call, r, null);
                    } else {
                        pbr = ProtobufUtil.toResult((Result)r);
                    }
                    builder.setResult(pbr);
                }
                if (r != null) {
                    quota.addGetResult(r);
                }
                getResponse = builder.build();
                mrs = this.regionServer.metricsRegionServer;
                if (mrs == null) break block22;
                HTableDescriptor hTableDescriptor = td = region != null ? region.getTableDesc() : null;
            }
            catch (IOException ie) {
                try {
                    throw new ServiceException((Throwable)ie);
                }
                catch (Throwable throwable) {
                    MetricsRegionServer mrs2 = this.regionServer.metricsRegionServer;
                    if (mrs2 != null) {
                        HTableDescriptor td2;
                        HTableDescriptor hTableDescriptor = td2 = region != null ? region.getTableDesc() : null;
                        if (td2 != null) {
                            mrs2.updateGet(td2.getTableName(), EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                    if (quota != null) {
                        quota.close();
                    }
                    throw throwable;
                }
            }
            if (td != null) {
                mrs.updateGet(td.getTableName(), EnvironmentEdgeManager.currentTime() - before);
            }
        }
        if (quota != null) {
            quota.close();
        }
        return getResponse;
    }

    private void checkBatchSizeAndLogLargeSize(ClientProtos.MultiRequest request) {
        int sum = 0;
        String firstRegionName = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            if (sum == 0) {
                firstRegionName = Bytes.toStringBinary((byte[])regionAction.getRegion().getValue().toByteArray());
            }
            sum += regionAction.getActionCount();
        }
        if (sum > this.rowSizeWarnThreshold) {
            this.ld.logBatchWarning(firstRegionName, sum, this.rowSizeWarnThreshold);
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.checkBatchSizeAndLogLargeSize(request);
        HBaseRpcController controller = (HBaseRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
        List<CellScannable> cellsToReturn = null;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        Boolean processed = null;
        this.rpcMultiRequestCount.increment();
        this.requestCount.increment();
        HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats> regionStats = new HashMap<HBaseProtos.RegionSpecifier, ClientProtos.RegionLoadStats>(request.getRegionActionCount());
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            OperationQuota quota;
            Region region;
            HBaseProtos.RegionSpecifier regionSpecifier;
            block14: {
                regionActionResultBuilder.clear();
                regionSpecifier = regionAction.getRegion();
                try {
                    region = this.getRegion(regionSpecifier);
                    quota = this.getQuotaManager().checkQuota(region, regionAction.getActionList());
                }
                catch (IOException e) {
                    this.rpcServer.getMetrics().exception(e);
                    regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
                    this.skipCellsForMutations(regionAction.getActionList(), cellScanner);
                    continue;
                }
                if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                    try {
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            processed = this.checkAndRowMutate(region, regionAction.getActionList(), cellScanner, row, family, qualifier, compareOp, comparator, regionActionResultBuilder);
                            break block14;
                        }
                        this.mutateRows(region, regionAction.getActionList(), cellScanner, regionActionResultBuilder);
                        processed = Boolean.TRUE;
                    }
                    catch (IOException e) {
                        this.rpcServer.getMetrics().exception(e);
                        regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    }
                } else {
                    cellsToReturn = this.doNonAtomicRegionMutation(region, quota, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, nonceGroup);
                }
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            quota.close();
            ClientProtos.RegionLoadStats regionLoadStats = ((HRegion)region).getLoadStatistics();
            if (regionLoadStats == null) continue;
            regionStats.put(regionSpecifier, regionLoadStats);
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List)cellsToReturn));
        }
        if (processed != null) {
            responseBuilder.setProcessed(processed.booleanValue());
        }
        ClientProtos.MultiRegionLoadStats.Builder builder = ClientProtos.MultiRegionLoadStats.newBuilder();
        for (Map.Entry stat : regionStats.entrySet()) {
            builder.addRegion((HBaseProtos.RegionSpecifier)stat.getKey());
            builder.addStat((ClientProtos.RegionLoadStats)stat.getValue());
        }
        responseBuilder.setRegionStatistics(builder);
        return responseBuilder.build();
    }

    private void skipCellsForMutations(List<ClientProtos.Action> actions, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        for (ClientProtos.Action action : actions) {
            this.skipCellsForMutation(action, cellScanner);
        }
    }

    private void skipCellsForMutation(ClientProtos.Action action, CellScanner cellScanner) {
        if (cellScanner == null) {
            return;
        }
        try {
            ClientProtos.MutationProto m;
            if (action.hasMutation() && (m = action.getMutation()).hasAssociatedCellCount()) {
                for (int i = 0; i < m.getAssociatedCellCount(); ++i) {
                    cellScanner.advance();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error while skipping Cells in CellScanner for invalid Region Mutations", (Throwable)e);
        }
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        ClientProtos.MutateResponse mutateResponse;
        block35: {
            HBaseRpcController controller = (HBaseRpcController)rpcc;
            CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
            OperationQuota quota = null;
            RpcCallContext context = RpcServer.getCurrentCall();
            ClientProtos.MutationProto.MutationType type = null;
            Region region = null;
            long before = EnvironmentEdgeManager.currentTime();
            if (controller != null) {
                controller.setCellScanner(null);
            }
            try {
                this.checkOpen();
                this.requestCount.increment();
                this.rpcMutateRequestCount.increment();
                region = this.getRegion(request.getRegion());
                ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
                ClientProtos.MutationProto mutation = request.getMutation();
                if (!region.getRegionInfo().isMetaTable()) {
                    this.regionServer.cacheFlusher.reclaimMemStoreMemory();
                }
                long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
                Result r = null;
                Boolean processed = null;
                type = mutation.getMutateType();
                long mutationSize = 0L;
                quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.MUTATE);
                switch (type) {
                    case APPEND: {
                        r = this.append(region, quota, mutation, cellScanner, nonceGroup);
                        break;
                    }
                    case INCREMENT: {
                        r = this.increment(region, quota, mutation, cellScanner, nonceGroup);
                        break;
                    }
                    case PUT: {
                        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                        this.checkCellSizeLimit(region, (Mutation)put);
                        quota.addMutation((Mutation)put);
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            if (region.getCoprocessorHost() != null) {
                                processed = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put);
                            }
                            if (processed != null) break;
                            boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)put, true);
                            if (region.getCoprocessorHost() != null) {
                                result = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put, result);
                            }
                            processed = result;
                            break;
                        }
                        region.put(put);
                        processed = Boolean.TRUE;
                        break;
                    }
                    case DELETE: {
                        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                        this.checkCellSizeLimit(region, (Mutation)delete);
                        quota.addMutation((Mutation)delete);
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            if (region.getCoprocessorHost() != null) {
                                processed = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, compareOp, comparator, delete);
                            }
                            if (processed != null) break;
                            boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)delete, true);
                            if (region.getCoprocessorHost() != null) {
                                result = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, compareOp, comparator, delete, result);
                            }
                            processed = result;
                            break;
                        }
                        region.delete(delete);
                        processed = Boolean.TRUE;
                        break;
                    }
                    default: {
                        throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                    }
                }
                if (processed != null) {
                    builder.setProcessed(processed.booleanValue());
                }
                this.addResult(builder, r, controller);
                boolean clientCellBlockSupported = this.isClientCellBlockSupport(context);
                if (clientCellBlockSupported) {
                    this.addSize(context, r, null);
                }
                mutateResponse = builder.build();
                if (quota != null) {
                    quota.close();
                }
                if (this.regionServer.metricsRegionServer == null || type == null) break block35;
            }
            catch (IOException ie) {
                try {
                    this.regionServer.checkFileSystem();
                    throw new ServiceException((Throwable)ie);
                }
                catch (Throwable throwable) {
                    if (quota != null) {
                        quota.close();
                    }
                    if (this.regionServer.metricsRegionServer != null && type != null) {
                        long after = EnvironmentEdgeManager.currentTime();
                        switch (type) {
                            case DELETE: {
                                if (request.hasCondition()) {
                                    this.regionServer.metricsRegionServer.updateCheckAndDelete(after - before);
                                    break;
                                }
                                this.regionServer.metricsRegionServer.updateDelete(region == null ? null : region.getRegionInfo().getTable(), after - before);
                                break;
                            }
                            case PUT: {
                                if (request.hasCondition()) {
                                    this.regionServer.metricsRegionServer.updateCheckAndPut(after - before);
                                    break;
                                }
                                this.regionServer.metricsRegionServer.updatePut(region == null ? null : region.getRegionInfo().getTable(), after - before);
                                break;
                            }
                        }
                    }
                    throw throwable;
                }
            }
            long after = EnvironmentEdgeManager.currentTime();
            switch (type) {
                case DELETE: {
                    if (request.hasCondition()) {
                        this.regionServer.metricsRegionServer.updateCheckAndDelete(after - before);
                        break;
                    }
                    this.regionServer.metricsRegionServer.updateDelete(region == null ? null : region.getRegionInfo().getTable(), after - before);
                    break;
                }
                case PUT: {
                    if (request.hasCondition()) {
                        this.regionServer.metricsRegionServer.updateCheckAndPut(after - before);
                        break;
                    }
                    this.regionServer.metricsRegionServer.updatePut(region == null ? null : region.getRegionInfo().getTable(), after - before);
                    break;
                }
            }
        }
        return mutateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScannerHolder getRegionScanner(ClientProtos.ScanRequest request) throws IOException {
        String scannerName = Long.toString(request.getScannerId());
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.get(scannerName);
        if (rsh == null) {
            if (this.closedScanners.getIfPresent((Object)scannerName) != null) {
                throw SCANNER_ALREADY_CLOSED;
            }
            LOG.warn((Object)("Client tried to access missing scanner " + scannerName));
            throw new UnknownScannerException("Unknown scanner '" + scannerName + "'. This can happen due to any of the following " + "reasons: a) Scanner id given is wrong, b) Scanner lease expired because of " + "long wait between consecutive client checkins, c) Server may be closing down, " + "d) RegionServer restart during upgrade.\nIf the issue is due to reason (b), a " + "possible fix would be increasing the value of" + "'hbase.client.scanner.timeout.period' configuration.");
        }
        HRegionInfo hri = rsh.s.getRegionInfo();
        if (this.regionServer.getOnlineRegion(hri.getRegionName()) != rsh.r) {
            String msg = "Region was re-opened after the scanner" + scannerName + " was created: " + hri.getRegionNameAsString();
            LOG.warn((Object)(msg + ", closing..."));
            this.scanners.remove(scannerName);
            try {
                rsh.s.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Getting exception closing " + scannerName), (Throwable)e);
            }
            finally {
                try {
                    this.regionServer.leases.cancelLease(scannerName);
                }
                catch (LeaseException e) {
                    LOG.warn((Object)("Getting exception closing " + scannerName), (Throwable)e);
                }
            }
            throw new NotServingRegionException(msg);
        }
        return rsh;
    }

    private RegionScannerHolder newRegionScanner(ClientProtos.ScanRequest request, ClientProtos.ScanResponse.Builder builder) throws IOException {
        Region region = this.getRegion(request.getRegion());
        ClientProtos.Scan protoScan = request.getScan();
        boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
        Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
        if (!isLoadingCfsOnDemandSet) {
            scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
        }
        if (!scan.hasFamilies()) {
            for (byte[] family : region.getTableDesc().getFamiliesKeys()) {
                scan.addFamily(family);
            }
        }
        RegionScanner scanner = null;
        if (region.getCoprocessorHost() != null) {
            scanner = region.getCoprocessorHost().preScannerOpen(scan);
        }
        if (scanner == null) {
            scanner = region.getScanner(scan);
        }
        if (region.getCoprocessorHost() != null) {
            scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
        }
        long scannerId = this.scannerIdGenerator.generateNewScannerId();
        builder.setScannerId(scannerId);
        builder.setMvccReadPoint(scanner.getMvccReadPoint());
        builder.setTtl(this.scannerLeaseTimeoutPeriod);
        String scannerName = String.valueOf(scannerId);
        return this.addScanner(scannerName, scanner, region, scan.isNeedCursorResult());
    }

    private void checkScanNextCallSeq(ClientProtos.ScanRequest request, RegionScannerHolder rsh) throws OutOfOrderScannerNextException {
        long callSeq;
        if (request.hasNextCallSeq() && !rsh.incNextCallSeq(callSeq = request.getNextCallSeq())) {
            throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.getNextCallSeq() + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString((MessageOrBuilder)request));
        }
    }

    private void addScannerLeaseBack(Leases.Lease lease) {
        try {
            this.regionServer.leases.addLease(lease);
        }
        catch (Leases.LeaseStillHeldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long getTimeLimit(HBaseRpcController controller, boolean allowHeartbeatMessages) {
        if (allowHeartbeatMessages && (this.scannerLeaseTimeoutPeriod > 0 || this.rpcTimeout > 0)) {
            long timeLimitDelta;
            if (this.scannerLeaseTimeoutPeriod > 0 && this.rpcTimeout > 0) {
                timeLimitDelta = Math.min(this.scannerLeaseTimeoutPeriod, this.rpcTimeout);
            } else {
                long l = timeLimitDelta = this.scannerLeaseTimeoutPeriod > 0 ? (long)this.scannerLeaseTimeoutPeriod : (long)this.rpcTimeout;
            }
            if (controller != null && controller.getCallTimeout() > 0) {
                timeLimitDelta = Math.min(timeLimitDelta, (long)controller.getCallTimeout());
            }
            timeLimitDelta = Math.max(timeLimitDelta / 2L, this.minimumScanTimeLimitDelta);
            return System.currentTimeMillis() + timeLimitDelta;
        }
        return -1L;
    }

    private void checkLimitOfRows(int numOfCompleteRows, int limitOfRows, boolean moreRows, ScannerContext scannerContext, ClientProtos.ScanResponse.Builder builder) {
        if (numOfCompleteRows >= limitOfRows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Done scanning, limit of rows reached, moreRows: " + moreRows + " scannerContext: " + scannerContext));
            }
            builder.setMoreResults(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(HBaseRpcController controller, ClientProtos.ScanRequest request, RegionScannerHolder rsh, long maxQuotaResultSize, int maxResults, int limitOfRows, List<Result> results, ClientProtos.ScanResponse.Builder builder, MutableObject lastBlock, RpcCallContext context) throws IOException {
        Region region = rsh.r;
        RegionScanner scanner = rsh.s;
        long maxResultSize = scanner.getMaxResultSize() > 0L ? Math.min(scanner.getMaxResultSize(), maxQuotaResultSize) : maxQuotaResultSize;
        ArrayList<Cell> values = new ArrayList<Cell>(32);
        region.startRegionOperation(Region.Operation.SCAN);
        try {
            int numOfResults = 0;
            int numOfCompleteRows = 0;
            long before = EnvironmentEdgeManager.currentTime();
            RegionScanner regionScanner = scanner;
            synchronized (regionScanner) {
                boolean stale = region.getRegionInfo().getReplicaId() != 0;
                boolean clientHandlesPartials = request.hasClientHandlesPartials() && request.getClientHandlesPartials();
                boolean clientHandlesHeartbeats = request.hasClientHandlesHeartbeats() && request.getClientHandlesHeartbeats();
                boolean serverGuaranteesOrderOfPartials = results.isEmpty();
                boolean allowPartialResults = clientHandlesPartials && serverGuaranteesOrderOfPartials;
                boolean moreRows = false;
                boolean allowHeartbeatMessages = clientHandlesHeartbeats && allowPartialResults;
                long timeLimit = this.getTimeLimit(controller, allowHeartbeatMessages);
                ScannerContext.LimitScope sizeScope = allowPartialResults ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                ScannerContext.LimitScope timeScope = allowHeartbeatMessages ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                boolean trackMetrics = request.hasTrackScanMetrics() && request.getTrackScanMetrics();
                ScannerContext.Builder contextBuilder = ScannerContext.newBuilder(true);
                contextBuilder.setSizeLimit(sizeScope, maxResultSize);
                contextBuilder.setBatchLimit(scanner.getBatch());
                contextBuilder.setTimeLimit(timeScope, timeLimit);
                contextBuilder.setTrackMetrics(trackMetrics);
                ScannerContext scannerContext = contextBuilder.build();
                boolean limitReached = false;
                while (numOfResults < maxResults) {
                    scannerContext.setBatchProgress(0);
                    moreRows = scanner.nextRaw(values, scannerContext);
                    if (!values.isEmpty()) {
                        if (limitOfRows > 0) {
                            if (results.isEmpty()) {
                                if (rsh.rowOfLastPartialResult != null && !CellUtil.matchingRow((Cell)((Cell)values.get(0)), (byte[])rsh.rowOfLastPartialResult)) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            } else {
                                Result lastResult = results.get(results.size() - 1);
                                if (lastResult.mayHaveMoreCellsInRow() && !CellUtil.matchingRow((Cell)((Cell)values.get(0)), (byte[])lastResult.getRow())) {
                                    this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                                }
                            }
                            if (builder.hasMoreResults() && !builder.getMoreResults()) break;
                        }
                        boolean mayHaveMoreCellsInRow = scannerContext.mayHaveMoreCellsInRow();
                        Result r = Result.create(values, null, (boolean)stale, (boolean)mayHaveMoreCellsInRow);
                        lastBlock.setValue(this.addSize(context, r, lastBlock.getValue()));
                        results.add(r);
                        ++numOfResults;
                        if (!mayHaveMoreCellsInRow && limitOfRows > 0) {
                            this.checkLimitOfRows(++numOfCompleteRows, limitOfRows, moreRows, scannerContext, builder);
                            if (builder.hasMoreResults() && !builder.getMoreResults()) break;
                        }
                    }
                    boolean sizeLimitReached = scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean timeLimitReached = scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                    boolean resultsLimitReached = numOfResults >= maxResults;
                    boolean bl = limitReached = sizeLimitReached || timeLimitReached || resultsLimitReached;
                    if (limitReached || !moreRows) {
                        Cell cursorCell;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Done scanning. limitReached: " + limitReached + " moreRows: " + moreRows + " scannerContext: " + scannerContext));
                        }
                        if (!moreRows) break;
                        builder.setHeartbeatMessage(timeLimitReached);
                        if (!timeLimitReached || !rsh.needCursor || (cursorCell = scannerContext.getLastPeekedCell()) == null) break;
                        builder.setCursor(ProtobufUtil.toCursor((Cell)cursorCell));
                        break;
                    }
                    values.clear();
                }
                builder.setMoreResultsInRegion(moreRows);
                if (trackMetrics) {
                    Map metrics = scannerContext.getMetrics().getMetricsMap();
                    MapReduceProtos.ScanMetrics.Builder metricBuilder = MapReduceProtos.ScanMetrics.newBuilder();
                    HBaseProtos.NameInt64Pair.Builder pairBuilder = HBaseProtos.NameInt64Pair.newBuilder();
                    for (Map.Entry entry : metrics.entrySet()) {
                        pairBuilder.setName((String)entry.getKey());
                        pairBuilder.setValue(((Long)entry.getValue()).longValue());
                        metricBuilder.addMetrics(pairBuilder.build());
                    }
                    builder.setScanMetrics(metricBuilder.build());
                }
            }
            long end = EnvironmentEdgeManager.currentTime();
            long responseCellSize = context != null ? context.getResponseCellSize() : 0L;
            region.getMetrics().updateScanTime(end - before);
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateScanSize(region.getTableDesc().getTableName(), responseCellSize);
                this.regionServer.metricsRegionServer.updateScanTime(region.getTableDesc().getTableName(), end - before);
            }
        }
        finally {
            region.closeRegionOperation();
        }
        if (region.getCoprocessorHost() != null) {
            region.getCoprocessorHost().postScannerNext(scanner, results, maxResults, true);
        }
    }

    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        boolean closeScanner;
        OperationQuota quota;
        Leases.Lease lease;
        RegionScannerHolder rsh;
        if (controller != null && !(controller instanceof HBaseRpcController)) {
            throw new UnsupportedOperationException("We only do HBaseRpcController! FIX IF A PROBLEM: " + controller);
        }
        if (!request.hasScannerId() && !request.hasScan()) {
            throw new ServiceException((Throwable)new DoNotRetryIOException("Missing required input: scannerId or scan"));
        }
        try {
            this.checkOpen();
        }
        catch (IOException e) {
            block49: {
                if (request.hasScannerId()) {
                    String scannerName = Long.toString(request.getScannerId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
                    }
                    if (this.regionServer.leases != null) {
                        try {
                            this.regionServer.leases.cancelLease(scannerName);
                        }
                        catch (LeaseException le) {
                            if (!LOG.isTraceEnabled()) break block49;
                            LOG.trace((Object)"Un-able to cancel lease of scanner. It could already be closed.");
                        }
                    }
                }
            }
            throw new ServiceException((Throwable)e);
        }
        this.requestCount.increment();
        this.rpcScanRequestCount.increment();
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScannerId()) {
                builder.setScannerId(request.getScannerId());
                rsh = this.getRegionScanner(request);
            } else {
                rsh = this.newRegionScanner(request, builder);
            }
        }
        catch (IOException e) {
            if (e == SCANNER_ALREADY_CLOSED) {
                return builder.build();
            }
            throw new ServiceException((Throwable)e);
        }
        Region region = rsh.r;
        String scannerName = rsh.scannerName;
        try {
            lease = this.regionServer.leases.removeLease(scannerName);
        }
        catch (LeaseException e) {
            throw new ServiceException((Throwable)e);
        }
        if (request.hasRenew() && request.getRenew()) {
            this.addScannerLeaseBack(lease);
            try {
                this.checkScanNextCallSeq(request, rsh);
            }
            catch (OutOfOrderScannerNextException e) {
                throw new ServiceException((Throwable)e);
            }
            return builder.build();
        }
        try {
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.SCAN);
        }
        catch (IOException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException((Throwable)e);
        }
        try {
            this.checkScanNextCallSeq(request, rsh);
        }
        catch (OutOfOrderScannerNextException e) {
            this.addScannerLeaseBack(lease);
            throw new ServiceException((Throwable)e);
        }
        boolean bl = closeScanner = request.hasCloseScanner() ? request.getCloseScanner() : false;
        int rows = request.hasNumberOfRows() ? request.getNumberOfRows() : (closeScanner ? 0 : 1);
        RpcCallContext context = RpcServer.getCurrentCall();
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        RegionScanner scanner = rsh.s;
        int limitOfRows = request.hasLimitOfRows() ? request.getLimitOfRows() : -1;
        MutableObject lastBlock = new MutableObject();
        boolean scannerClosed = false;
        try {
            ArrayList<Result> results = new ArrayList<Result>();
            if (rows > 0) {
                boolean done = false;
                if (region.getCoprocessorHost() != null) {
                    Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                    if (!results.isEmpty()) {
                        for (Result r : results) {
                            lastBlock.setValue(this.addSize(context, r, lastBlock.getValue()));
                        }
                    }
                    if (bypass != null && bypass.booleanValue()) {
                        done = true;
                    }
                }
                if (!done) {
                    this.scan((HBaseRpcController)controller, request, rsh, maxQuotaResultSize, rows, limitOfRows, results, builder, lastBlock, context);
                } else {
                    builder.setMoreResultsInRegion(!results.isEmpty());
                }
            } else {
                builder.setMoreResultsInRegion(true);
            }
            quota.addScanResult(results);
            this.addResults(builder, results, (HBaseRpcController)controller, RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()));
            if (scanner.isFilterDone() && results.isEmpty()) {
                builder.setMoreResults(false);
            }
            assert (builder.hasMoreResultsInRegion());
            if (!builder.hasMoreResults()) {
                builder.setMoreResults(true);
            }
            if (builder.getMoreResults() && builder.getMoreResultsInRegion() && !results.isEmpty()) {
                Result lastResult = (Result)results.get(results.size() - 1);
                if (lastResult.mayHaveMoreCellsInRow()) {
                    RegionScannerHolder.access$402(rsh, lastResult.getRow());
                } else {
                    RegionScannerHolder.access$402(rsh, null);
                }
            }
            if (!builder.getMoreResults() || !builder.getMoreResultsInRegion() || closeScanner) {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
            }
            ClientProtos.ScanResponse lastResult = builder.build();
            return lastResult;
        }
        catch (IOException e) {
            try {
                scannerClosed = true;
                this.closeScanner(region, scanner, scannerName, context);
                if (e instanceof DoNotRetryIOException) {
                    throw e;
                }
                if (e instanceof FileNotFoundException) {
                    throw new DoNotRetryIOException((Throwable)e);
                }
                if (VersionInfoUtil.hasMinimumVersion(context.getClientVersionInfo(), 1, 4)) {
                    throw new ScannerResetException("Scanner is closed on the server-side", (Exception)e);
                }
                throw new UnknownScannerException("Throwing UnknownScannerException to reset the client scanner state for clients older than 1.3.", (Exception)e);
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }
        finally {
            if (!scannerClosed) {
                this.addScannerLeaseBack(lease);
            }
            quota.close();
        }
    }

    private void closeScanner(Region region, RegionScanner scanner, String scannerName, RpcCallContext context) throws IOException {
        if (region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
            return;
        }
        RegionScannerHolder rsh = (RegionScannerHolder)this.scanners.remove(scannerName);
        if (rsh != null) {
            rsh.s.close();
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postScannerClose(scanner);
            }
            this.closedScanners.put((Object)scannerName, (Object)scannerName);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return this.regionServer.execRegionServerService(controller, request);
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.regionServer.updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    static interface LogDelegate {
        public void logBatchWarning(String var1, int var2, int var3);
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void leaseExpired() {
            RegionScannerHolder rsh = (RegionScannerHolder)RSRpcServices.this.scanners.remove(this.scannerName);
            if (rsh != null) {
                RegionScanner s = rsh.s;
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString()));
                Region region = null;
                try {
                    region = RSRpcServices.this.regionServer.getRegion(s.getRegionInfo().getRegionName());
                    if (region == null || region.getCoprocessorHost() == null) return;
                    region.getCoprocessorHost().preScannerClose(s);
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                    return;
                }
                finally {
                    try {
                        s.close();
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerClose(s);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                    }
                }
            }
            LOG.warn((Object)("Scanner " + this.scannerName + " lease expired, but no related" + " scanner found, hence no chance to close that related scanner!"));
        }
    }

    private static final class RegionScannerHolder {
        private final AtomicLong nextCallSeq = new AtomicLong(0L);
        private final String scannerName;
        private final RegionScanner s;
        private final Region r;
        private byte[] rowOfLastPartialResult;
        private boolean needCursor;

        public RegionScannerHolder(String scannerName, RegionScanner s, Region r, boolean needCursor) {
            this.scannerName = scannerName;
            this.s = s;
            this.r = r;
            this.needCursor = needCursor;
        }

        public long getNextCallSeq() {
            return this.nextCallSeq.get();
        }

        public boolean incNextCallSeq(long currentSeq) {
            return this.nextCallSeq.compareAndSet(currentSeq, currentSeq + 1L);
        }

        static /* synthetic */ byte[] access$402(RegionScannerHolder x0, byte[] x1) {
            x0.rowOfLastPartialResult = x1;
            return x1;
        }
    }
}

