/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class CallRunner {
    private static final Log LOG = LogFactory.getLog(CallRunner.class);
    private RpcServer.Call call;
    private RpcServerInterface rpcServer;
    private MonitoredRPCHandler status;
    private volatile boolean sucessful;

    CallRunner(RpcServerInterface rpcServer, RpcServer.Call call) {
        this.call = call;
        this.rpcServer = rpcServer;
        this.rpcServer.addCallSize(call.getSize());
    }

    public RpcServer.Call getCall() {
        return this.call;
    }

    public void setStatus(MonitoredRPCHandler status) {
        this.status = status;
    }

    private void cleanup() {
        this.call = null;
        this.rpcServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block28: {
            try {
                if (!this.call.connection.channel.isOpen()) {
                    if (RpcServer.LOG.isDebugEnabled()) {
                        RpcServer.LOG.debug((Object)(Thread.currentThread().getName() + ": skipped " + this.call));
                    }
                    return;
                }
                this.status.setStatus("Setting up call");
                this.status.setConnection(this.call.connection.getHostAddress(), this.call.connection.getRemotePort());
                if (RpcServer.LOG.isTraceEnabled()) {
                    UserGroupInformation remoteUser = this.call.connection.ugi;
                    RpcServer.LOG.trace((Object)(this.call.toShortString() + " executing as " + (remoteUser == null ? "NULL principal" : remoteUser.getUserName())));
                }
                Throwable errorThrowable = null;
                String error = null;
                Pair<Message, CellScanner> resultPair = null;
                RpcServer.CurCall.set(this.call);
                TraceScope traceScope = null;
                try {
                    if (!this.rpcServer.isStarted()) {
                        InetSocketAddress address = this.rpcServer.getListenerAddress();
                        throw new ServerNotRunningYetException("Server " + (address != null ? address : "(channel closed)") + " is not running yet");
                    }
                    if (this.call.tinfo != null) {
                        traceScope = Trace.startSpan((String)this.call.toTraceString(), (TraceInfo)this.call.tinfo);
                    }
                    resultPair = this.rpcServer.call(this.call.service, this.call.md, this.call.param, this.call.cellScanner, this.call.timestamp, this.status);
                }
                catch (Throwable e) {
                    RpcServer.LOG.debug((Object)(Thread.currentThread().getName() + ": " + this.call.toShortString()), e);
                    errorThrowable = e;
                    error = StringUtils.stringifyException((Throwable)e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
                finally {
                    if (traceScope != null) {
                        traceScope.close();
                    }
                    RpcServer.CurCall.set(null);
                    if (resultPair != null) {
                        this.rpcServer.addCallSize(this.call.getSize() * -1L);
                        this.sucessful = true;
                    }
                }
                Message param = resultPair != null ? (Message)resultPair.getFirst() : null;
                CellScanner cells = resultPair != null ? (CellScanner)resultPair.getSecond() : null;
                this.call.setResponse(param, cells, errorThrowable, error);
                this.call.sendResponseIfReady();
                this.status.markComplete("Sent response");
                this.status.pause("Waiting for a call");
            }
            catch (OutOfMemoryError e) {
                if (this.rpcServer.getErrorHandler() != null) {
                    if (this.rpcServer.getErrorHandler().checkOOME(e)) {
                        RpcServer.LOG.info((Object)(Thread.currentThread().getName() + ": exiting on OutOfMemoryError"));
                        return;
                    }
                    break block28;
                }
                throw e;
            }
            catch (ClosedChannelException cce) {
                InetSocketAddress address = this.rpcServer.getListenerAddress();
                RpcServer.LOG.warn((Object)(Thread.currentThread().getName() + ": caught a ClosedChannelException, " + "this means that the server " + (address != null ? address : "(channel closed)") + " was processing a request but the client went away. The error message was: " + cce.getMessage()));
            }
            catch (Exception e) {
                RpcServer.LOG.warn((Object)(Thread.currentThread().getName() + ": caught: " + StringUtils.stringifyException((Throwable)e)));
            }
            finally {
                if (!this.sucessful) {
                    this.rpcServer.addCallSize(this.call.getSize() * -1L);
                }
                this.cleanup();
            }
        }
    }
}

