/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        table_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html;charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            HMaster master = (HMaster)this.getServletContext().getAttribute("master");
            Configuration conf = master.getConfiguration();
            MetaTableLocator metaTableLocator = new MetaTableLocator();
            String fqtn = request.getParameter("name");
            HTable table = null;
            boolean withReplica = false;
            ServerName rl = metaTableLocator.getMetaRegionLocation(master.getZooKeeper());
            boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
            boolean readOnly = conf.getBoolean("hbase.master.ui.readonly", false);
            int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
            Map<String, Integer> frags = null;
            if (showFragmentation) {
                frags = FSUtils.getTableFragmentation(master);
            }
            String action = request.getParameter("action");
            String key = request.getParameter("key");
            out.write("\n<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta charset=\"utf-8\">\n    ");
            if (!readOnly && action != null) {
                out.write("\n        <title>HBase Master: ");
                out.print((Object)master.getServerName());
                out.write("</title>\n    ");
            } else {
                out.write("\n        <title>Table: ");
                out.print(fqtn);
                out.write("</title>\n    ");
            }
            out.write("\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n\n\n      <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n      ");
            if (!readOnly && action != null || fqtn == null) {
                out.write("\n\t  <script type=\"text/javascript\">\n      <!--\n\t\t  setTimeout(\"history.back()\",5000);\n\t  -->\n\t  </script>\n      ");
            } else {
                out.write("\n      <!--[if lt IE 9]>\n          <script src=\"/static/js/html5shiv.js\"></script>\n      <![endif]-->\n      ");
            }
            out.write("\n</head>\n<body>\n<div class=\"navbar  navbar-fixed-top navbar-default\">\n    <div class=\"container-fluid\">\n        <div class=\"navbar-header\">\n            <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n            </button>\n            <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n        </div>\n        <div class=\"collapse navbar-collapse\">\n            <ul class=\"nav navbar-nav\">\n                <li><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/procedures.jsp\">Procedures</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n");
            out.write("                ");
            if (HBaseConfiguration.isShowConfInServlet()) {
                out.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
            }
            out.write("\n            </ul>\n        </div><!--/.nav-collapse -->\n    </div>\n</div>\n");
            if (fqtn != null) {
                String tableHeader;
                table = new HTable(conf, fqtn);
                if (table.getTableDescriptor().getRegionReplication() > 1) {
                    tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th style=\"width:22%\">Name</th><th>Region Server</th><th style=\"width:22%\">Start Key</th><th style=\"width:22%\">End Key</th><th>Locality</th><th>Requests</th><th>ReplicaID</th></tr>";
                    withReplica = true;
                } else {
                    tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th style=\"width:22%\">Name</th><th>Region Server</th><th style=\"width:22%\">Start Key</th><th style=\"width:22%\">End Key</th><th>Locality</th><th>Requests</th></tr>";
                }
                if (!readOnly && action != null) {
                    out.write("\n<div class=\"container-fluid content\">\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Table action request accepted</h1>\n            </div>\n        </div>\n<p><hr><p>\n");
                    try (Admin admin = master.getConnection().getAdmin();){
                        if (action.equals("split")) {
                            if (key != null && key.length() > 0) {
                                admin.splitRegion(Bytes.toBytes((String)key));
                            } else {
                                admin.split(TableName.valueOf((String)fqtn));
                            }
                            out.write(" Split request accepted. ");
                        } else if (action.equals("compact")) {
                            if (key != null && key.length() > 0) {
                                admin.compactRegion(Bytes.toBytes((String)key));
                            } else {
                                admin.compact(TableName.valueOf((String)fqtn));
                            }
                            out.write(" Compact request accepted. ");
                        }
                    }
                    out.write("\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
                } else {
                    out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table <small>");
                    out.print(fqtn);
                    out.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n");
                    if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                        out.write(10);
                        out.print(tableHeader);
                        out.write(10);
                        for (int j = 0; j < numMetaReplicas; ++j) {
                            HRegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)j);
                            ServerName metaLocation = metaTableLocator.waitMetaRegionLocation(master.getZooKeeper(), j, 1L);
                            for (int i = 0; i < 1; ++i) {
                                String url = "//" + metaLocation.getHostname() + ":" + master.getRegionServerInfoPort(metaLocation) + "/";
                                out.write("\n<tr>\n  <td>");
                                out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                out.write("</td>\n    <td><a href=\"");
                                out.print(url);
                                out.write(34);
                                out.write(62);
                                out.print(metaLocation.getHostname().toString() + ":" + master.getRegionServerInfoPort(metaLocation));
                                out.write("</a></td>\n    <td>");
                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getStartKey())));
                                out.write("</td>\n    <td>");
                                out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getEndKey())));
                                out.write("</td>\n    <td>-</td>\n    <td>-</td>\n</tr>\n");
                            }
                            out.write(10);
                        }
                        out.write("\n</table>\n");
                    } else {
                        try (Admin admin = master.getConnection().getAdmin();){
                            out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
                            out.print(admin.isTableEnabled(table.getName()));
                            out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");
                            try {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = admin.getCompactionState(table.getName());
                                out.write(10);
                                out.print((Object)compactionState);
                                out.write(10);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                out.write(" Unknown ");
                            }
                            out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
                            if (showFragmentation) {
                                out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
                                out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                                out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
                            }
                            out.write("\n</table>\n");
                            TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                            NavigableMap regions = table.getRegionLocations();
                            if (regions != null && regions.size() > 0) {
                                out.write(10);
                                out.print(tableHeader);
                                out.write(10);
                                for (Map.Entry hriEntry : regions.entrySet()) {
                                    ServerLoad sl;
                                    HRegionInfo regionInfo = (HRegionInfo)hriEntry.getKey();
                                    ServerName addr = (ServerName)hriEntry.getValue();
                                    long req = 0L;
                                    float locality = 0.0f;
                                    Object urlRegionServer = null;
                                    if (addr != null && (sl = master.getServerManager().getLoad(addr)) != null) {
                                        Integer i;
                                        Map map = sl.getRegionsLoad();
                                        if (map.containsKey(regionInfo.getRegionName())) {
                                            req = ((RegionLoad)map.get(regionInfo.getRegionName())).getRequestsCount();
                                            locality = ((RegionLoad)map.get(regionInfo.getRegionName())).getDataLocality();
                                        }
                                        if (null == (i = (Integer)regDistribution.get(addr))) {
                                            i = 0;
                                        }
                                        regDistribution.put(addr, i + 1);
                                    }
                                    out.write("\n<tr>\n  <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getRegionName())));
                                    out.write("</td>\n  ");
                                    if (addr != null) {
                                        String url = "//" + addr.getHostname() + ":" + master.getRegionServerInfoPort(addr) + "/rs-status";
                                        out.write("\n  <td>\n     <a href=\"");
                                        out.print(url);
                                        out.write(34);
                                        out.write(62);
                                        out.print(addr.getHostname().toString() + ":" + addr.getPort());
                                        out.write("</a>\n  </td>\n  ");
                                    } else {
                                        out.write("\n  <td class=\"undeployed-region\">not deployed</td>\n  ");
                                    }
                                    out.write("\n  <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getStartKey())));
                                    out.write("</td>\n  <td>");
                                    out.print(StringEscapeUtils.escapeXml((String)Bytes.toStringBinary((byte[])regionInfo.getEndKey())));
                                    out.write("</td>\n  <td>");
                                    out.print(locality);
                                    out.write("</td>\n  <td>");
                                    out.print(req);
                                    out.write("</td>\n  ");
                                    if (withReplica) {
                                        out.write("\n  <td>");
                                        out.print(regionInfo.getReplicaId());
                                        out.write("</td>\n  ");
                                    }
                                    out.write("\n</tr>\n");
                                }
                                out.write("\n</table>\n<h2>Regions by Region Server</h2>\n<table class=\"table table-striped\"><tr><th>Region Server</th><th>Region Count</th></tr>\n");
                                for (Map.Entry rdEntry : regDistribution.entrySet()) {
                                    ServerName addr = (ServerName)rdEntry.getKey();
                                    String url = "//" + addr.getHostname() + ":" + master.getRegionServerInfoPort(addr) + "/rs-status";
                                    out.write("\n<tr>\n  <td><a href=\"");
                                    out.print(url);
                                    out.write(34);
                                    out.write(62);
                                    out.print(addr.getHostname().toString() + ":" + addr.getPort());
                                    out.write("</a></td>\n  <td>");
                                    out.print(rdEntry.getValue());
                                    out.write("</td>\n</tr>\n");
                                }
                                out.write("\n</table>\n");
                            }
                        }
                    }
                    out.write("\n\n\n");
                    if (!readOnly) {
                        out.write("\n<p><hr/></p>\nActions:\n<p>\n<center>\n<table class=\"table\" width=\"95%\" >\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"compact\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a compaction of all\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key.</td>\n  </form>\n</tr>\n<tr><td style=\"border-style: none\" colspan=\"4\">&nbsp;</td></tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"split\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a split of all eligible\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key. An eligible region is one that does not contain any references to\n  other regions. Split requests for noneligible regions will be ignored.</td>\n  </form>\n</tr>\n</table>\n</center>\n</p>\n");
                    }
                    out.write("\n</div>\n</div>\n");
                }
            } else {
                out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table not ready</h1>\n        </div>\n    </div>\n<p><hr><p>\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
            }
            out.write("\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n\n</body>\n</html>\n");
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

