/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.CellSkipListSet;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.UnexpectedStateException;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public class DefaultMemStore
implements MemStore {
    private static final Log LOG = LogFactory.getLog(DefaultMemStore.class);
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    private static final boolean USEMSLAB_DEFAULT = true;
    static final String MSLAB_CLASS_NAME = "hbase.regionserver.mslab.class";
    private Configuration conf;
    volatile CellSkipListSet cellSet;
    volatile CellSkipListSet snapshot;
    final KeyValue.KVComparator comparator;
    final AtomicLong size;
    private volatile long snapshotSize;
    volatile long timeOfOldestEdit = Long.MAX_VALUE;
    TimeRangeTracker timeRangeTracker;
    TimeRangeTracker snapshotTimeRangeTracker;
    volatile MemStoreLAB allocator;
    volatile MemStoreLAB snapshotAllocator;
    volatile long snapshotId;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 9 * ClassSize.REFERENCE + 24));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.ATOMIC_LONG + (long)(2 * ClassSize.TIMERANGE_TRACKER) + (long)(2 * ClassSize.CELL_SKIPLIST_SET) + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP)));

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), KeyValue.COMPARATOR);
    }

    public DefaultMemStore(Configuration conf, KeyValue.KVComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.cellSet = new CellSkipListSet(c);
        this.snapshot = new CellSkipListSet(c);
        this.timeRangeTracker = new TimeRangeTracker();
        this.snapshotTimeRangeTracker = new TimeRangeTracker();
        this.size = new AtomicLong(DEEP_OVERHEAD);
        this.snapshotSize = 0L;
        if (conf.getBoolean(USEMSLAB_KEY, true)) {
            String className = conf.get(MSLAB_CLASS_NAME, HeapMemStoreLAB.class.getName());
            this.allocator = (MemStoreLAB)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
        } else {
            this.allocator = null;
        }
    }

    void dump() {
        for (Cell cell : this.cellSet) {
            LOG.info((Object)cell);
        }
        for (Cell cell : this.snapshot) {
            LOG.info((Object)cell);
        }
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            this.snapshotSize = this.keySize();
            if (!this.cellSet.isEmpty()) {
                this.snapshot = this.cellSet;
                this.cellSet = new CellSkipListSet(this.comparator);
                this.snapshotTimeRangeTracker = this.timeRangeTracker;
                this.timeRangeTracker = new TimeRangeTracker();
                this.size.set(DEEP_OVERHEAD);
                this.snapshotAllocator = this.allocator;
                if (this.allocator != null) {
                    String className = this.conf.get(MSLAB_CLASS_NAME, HeapMemStoreLAB.class.getName());
                    this.allocator = (MemStoreLAB)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{this.conf});
                }
                this.timeOfOldestEdit = Long.MAX_VALUE;
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot.size(), this.snapshotSize, this.snapshotTimeRangeTracker, new CollectionBackedScanner(this.snapshot, this.comparator));
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedStateException {
        MemStoreLAB tmpAllocator = null;
        if (this.snapshotId != id) {
            throw new UnexpectedStateException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        if (!this.snapshot.isEmpty()) {
            this.snapshot = new CellSkipListSet(this.comparator);
            this.snapshotTimeRangeTracker = new TimeRangeTracker();
        }
        this.snapshotSize = 0L;
        this.snapshotId = -1L;
        if (this.snapshotAllocator != null) {
            tmpAllocator = this.snapshotAllocator;
            this.snapshotAllocator = null;
        }
        if (tmpAllocator != null) {
            tmpAllocator.close();
        }
    }

    @Override
    public long getFlushableSize() {
        return this.snapshotSize > 0L ? this.snapshotSize : this.keySize();
    }

    @Override
    public Pair<Long, Cell> add(Cell cell) {
        Cell toAdd = this.maybeCloneWithAllocator(cell);
        return new Pair((Object)this.internalAdd(toAdd), (Object)toAdd);
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    private boolean addToCellSet(Cell e) {
        boolean b = this.cellSet.add(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    private boolean removeFromCellSet(Cell e) {
        boolean b = this.cellSet.remove(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTime();
        }
    }

    private long internalAdd(Cell toAdd) {
        long s = DefaultMemStore.heapSizeChange(toAdd, this.addToCellSet(toAdd));
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s);
        return s;
    }

    private Cell maybeCloneWithAllocator(Cell cell) {
        if (this.allocator == null) {
            return cell;
        }
        int len = KeyValueUtil.length((Cell)cell);
        ByteRange alloc = this.allocator.allocateBytes(len);
        if (alloc == null) {
            return cell;
        }
        assert (alloc.getBytes() != null);
        KeyValueUtil.appendToByteArray((Cell)cell, (byte[])alloc.getBytes(), (int)alloc.getOffset());
        KeyValue newKv = new KeyValue(alloc.getBytes(), alloc.getOffset(), len);
        newKv.setSequenceId(cell.getSequenceId());
        return newKv;
    }

    @Override
    public void rollback(Cell cell) {
        Cell found = this.snapshot.get(cell);
        if (found != null && found.getSequenceId() == cell.getSequenceId()) {
            this.snapshot.remove(cell);
            long sz = DefaultMemStore.heapSizeChange(cell, true);
            this.snapshotSize -= sz;
        }
        if ((found = this.cellSet.get(cell)) != null && found.getSequenceId() == cell.getSequenceId()) {
            this.removeFromCellSet(cell);
            long s = DefaultMemStore.heapSizeChange(cell, true);
            this.size.addAndGet(-s);
        }
    }

    @Override
    public long delete(Cell deleteCell) {
        long s = 0L;
        Cell toAdd = this.maybeCloneWithAllocator(deleteCell);
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s += DefaultMemStore.heapSizeChange(toAdd, this.addToCellSet(toAdd)));
        return s;
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.cellSet), this.getNextRow(cell, this.snapshot));
    }

    private Cell getLowest(Cell a, Cell b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private Cell getNextRow(Cell key, NavigableSet<Cell> set) {
        Cell result = null;
        NavigableSet<Cell> tail = key == null ? set : set.tailSet(key);
        for (Cell cell : tail) {
            if (this.comparator.compareRows(cell, key) <= 0) continue;
            result = cell;
            break;
        }
        return result;
    }

    @Override
    public void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.getRowKeyAtOrBefore(this.cellSet, state);
        this.getRowKeyAtOrBefore(this.snapshot, state);
    }

    private void getRowKeyAtOrBefore(NavigableSet<Cell> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, (Cell)state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<Cell> set, Cell firstOnRow, GetClosestRowBeforeTracker state) {
        Cell kv;
        boolean foundCandidate = false;
        SortedSet<Cell> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (Cell)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<Cell> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, (Cell)firstOnRow);
        while (p != null && state.isTargetTable(p.cell) && state.isBetterCandidate(p.cell) && !this.walkForwardInSingleRow(p.set, (Cell)(firstOnRow = new KeyValue(p.cell.getRowArray(), p.cell.getRowOffset(), (int)p.cell.getRowLength(), Long.MAX_VALUE)), state)) {
            p = this.memberOfPreviousRow(p.set, state, (Cell)firstOnRow);
        }
    }

    @Override
    public long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        Cell cell;
        Cell snc;
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])family, (byte[])qualifier);
        SortedSet<Cell> snSs = this.snapshot.tailSet((Cell)firstCell);
        if (!snSs.isEmpty() && CellUtil.matchingRow((Cell)(snc = snSs.first()), (Cell)firstCell) && CellUtil.matchingQualifier((Cell)snc, (Cell)firstCell) && snc.getTimestamp() == now) {
            ++now;
        }
        SortedSet<Cell> ss = this.cellSet.tailSet((Cell)firstCell);
        Iterator i$ = ss.iterator();
        while (i$.hasNext() && CellUtil.matchingColumn((Cell)(cell = (Cell)i$.next()), (byte[])family, (byte[])qualifier) && CellUtil.matchingRow((Cell)cell, (Cell)firstCell)) {
            if (cell.getTypeByte() != KeyValue.Type.Put.getCode() || cell.getTimestamp() <= now || !CellUtil.matchingQualifier((Cell)firstCell, (Cell)cell)) continue;
            now = cell.getTimestamp();
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        cells.add((Cell)new KeyValue(row, family, qualifier, now, Bytes.toBytes((long)newValue)));
        return this.upsert(cells, 1L);
    }

    @Override
    public long upsert(Iterable<Cell> cells, long readpoint) {
        long size = 0L;
        for (Cell cell : cells) {
            size += this.upsert(cell, readpoint);
        }
        return size;
    }

    private long upsert(Cell cell, long readpoint) {
        long addedSize = this.internalAdd(cell);
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        SortedSet<Cell> ss = this.cellSet.tailSet((Cell)firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRow((Cell)cell, (Cell)cur) || !CellUtil.matchingQualifier((Cell)cell, (Cell)cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible > 1) {
                long delta = DefaultMemStore.heapSizeChange(cur, true);
                addedSize -= delta;
                this.size.addAndGet(-delta);
                it.remove();
                this.setOldestEditTimeToNow();
                continue;
            }
            ++versionsVisible;
        }
        return addedSize;
    }

    private Member memberOfPreviousRow(NavigableSet<Cell> set, GetClosestRowBeforeTracker state, Cell firstOnRow) {
        NavigableSet<Cell> head = set.headSet(firstOnRow, false);
        if (head.isEmpty()) {
            return null;
        }
        Iterator<Cell> i = head.descendingIterator();
        while (i.hasNext()) {
            Cell found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head, found);
        }
        return null;
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) {
        return Collections.singletonList(new MemStoreScanner(readPt));
    }

    public boolean shouldSeek(Scan scan, long oldestUnexpiredTS) {
        return (this.timeRangeTracker.includesTimeRange(scan.getTimeRange()) || this.snapshotTimeRangeTracker.includesTimeRange(scan.getTimeRange())) && Math.max(this.timeRangeTracker.getMaximumTimestamp(), this.snapshotTimeRangeTracker.getMaximumTimestamp()) >= oldestUnexpiredTS;
    }

    static long heapSizeChange(Cell cell, boolean notpresent) {
        return notpresent ? ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + CellUtil.estimatedHeapSizeOf((Cell)cell))) : 0L;
    }

    private long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public long heapSize() {
        return this.size.get();
    }

    @Override
    public long size() {
        return this.heapSize();
    }

    public static void main(String[] args) {
        Pair<Long, Cell> ret;
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        DefaultMemStore memstore1 = new DefaultMemStore();
        long size = 0L;
        int count = 10000;
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            ret = memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
            size += ((Long)ret.getFirst()).longValue();
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            ret = memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
            size += ((Long)ret.getFirst()).longValue();
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        DefaultMemStore memstore2 = new DefaultMemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            Pair<Long, Cell> ret2 = memstore2.add((Cell)new KeyValue(Bytes.toBytes((int)i2), fam, qf, (long)i2, new byte[i2]));
            size += ((Long)ret2.getFirst()).longValue();
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info((Object)"Exiting.");
    }

    protected class MemStoreScanner
    extends NonLazyKeyValueScanner {
        private Cell cellSetNextRow = null;
        private Cell snapshotNextRow = null;
        private Cell cellSetItRow = null;
        private Cell snapshotItRow = null;
        private Iterator<Cell> cellSetIt;
        private Iterator<Cell> snapshotIt;
        private CellSkipListSet cellSetAtCreation;
        private CellSkipListSet snapshotAtCreation;
        private Cell theNext;
        volatile MemStoreLAB allocatorAtCreation;
        volatile MemStoreLAB snapshotAllocatorAtCreation;
        private boolean stopSkippingCellsIfNextRow = false;
        private long readPoint;

        MemStoreScanner(long readPoint) {
            this.readPoint = readPoint;
            this.cellSetAtCreation = DefaultMemStore.this.cellSet;
            this.snapshotAtCreation = DefaultMemStore.this.snapshot;
            if (DefaultMemStore.this.allocator != null) {
                this.allocatorAtCreation = DefaultMemStore.this.allocator;
                this.allocatorAtCreation.incScannerCount();
            }
            if (DefaultMemStore.this.snapshotAllocator != null) {
                this.snapshotAllocatorAtCreation = DefaultMemStore.this.snapshotAllocator;
                this.snapshotAllocatorAtCreation.incScannerCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cell getNext(Iterator<Cell> it) {
            Cell startCell = this.theNext;
            Cell v = null;
            try {
                while (it.hasNext()) {
                    v = it.next();
                    if (v.getSequenceId() <= this.readPoint) {
                        Cell cell = v;
                        return cell;
                    }
                    if (!this.stopSkippingCellsIfNextRow || startCell == null || DefaultMemStore.this.comparator.compareRows(v, startCell) <= 0) continue;
                    Cell cell = null;
                    return cell;
                }
                Cell cell = null;
                return cell;
            }
            finally {
                if (v != null) {
                    if (it == this.snapshotIt) {
                        this.snapshotItRow = v;
                    } else {
                        this.cellSetItRow = v;
                    }
                }
            }
        }

        @Override
        public synchronized boolean seek(Cell key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.cellSetIt = this.cellSetAtCreation.tailSet(key).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(key).iterator();
            this.cellSetItRow = null;
            this.snapshotItRow = null;
            return this.seekInSubLists(key);
        }

        private synchronized boolean seekInSubLists(Cell key) {
            this.cellSetNextRow = this.getNext(this.cellSetIt);
            this.snapshotNextRow = this.getNext(this.snapshotIt);
            this.theNext = this.getLowest(this.cellSetNextRow, this.snapshotNextRow);
            return this.theNext != null;
        }

        @Override
        public synchronized boolean reseek(Cell key) {
            this.cellSetIt = this.cellSetAtCreation.tailSet(this.getHighest(key, this.cellSetItRow)).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(this.getHighest(key, this.snapshotItRow)).iterator();
            return this.seekInSubLists(key);
        }

        @Override
        public synchronized Cell peek() {
            return this.theNext;
        }

        @Override
        public synchronized Cell next() {
            if (this.theNext == null) {
                return null;
            }
            Cell ret = this.theNext;
            if (this.theNext == this.cellSetNextRow) {
                this.cellSetNextRow = this.getNext(this.cellSetIt);
            } else {
                this.snapshotNextRow = this.getNext(this.snapshotIt);
            }
            this.theNext = this.getLowest(this.cellSetNextRow, this.snapshotNextRow);
            return ret;
        }

        private Cell getLowest(Cell first, Cell second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = DefaultMemStore.this.comparator.compare(first, second);
                return compare <= 0 ? first : second;
            }
            return first != null ? first : second;
        }

        private Cell getHighest(Cell first, Cell second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = DefaultMemStore.this.comparator.compare(first, second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized void close() {
            this.cellSetNextRow = null;
            this.snapshotNextRow = null;
            this.cellSetIt = null;
            this.snapshotIt = null;
            if (this.allocatorAtCreation != null) {
                this.allocatorAtCreation.decScannerCount();
                this.allocatorAtCreation = null;
            }
            if (this.snapshotAllocatorAtCreation != null) {
                this.snapshotAllocatorAtCreation.decScannerCount();
                this.snapshotAllocatorAtCreation = null;
            }
            this.cellSetItRow = null;
            this.snapshotItRow = null;
        }

        @Override
        public long getSequenceID() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean shouldUseScanner(Scan scan, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
            return DefaultMemStore.this.shouldSeek(scan, oldestUnexpiredTS);
        }

        @Override
        public synchronized boolean backwardSeek(Cell key) {
            this.seek(key);
            if (this.peek() == null || DefaultMemStore.this.comparator.compareRows(this.peek(), key) > 0) {
                return this.seekToPreviousRow(key);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToPreviousRow(Cell key) {
            SortedSet<Cell> snapshotHead;
            Cell snapshotBeforeRow;
            KeyValue firstKeyOnRow = KeyValueUtil.createFirstOnRow((byte[])key.getRowArray(), (int)key.getRowOffset(), (short)key.getRowLength());
            SortedSet<Cell> cellHead = this.cellSetAtCreation.headSet((Cell)firstKeyOnRow);
            Cell cellSetBeforeRow = cellHead.isEmpty() ? null : cellHead.last();
            Cell lastCellBeforeRow = this.getHighest(cellSetBeforeRow, snapshotBeforeRow = (snapshotHead = this.snapshotAtCreation.headSet((Cell)firstKeyOnRow)).isEmpty() ? null : snapshotHead.last());
            if (lastCellBeforeRow == null) {
                this.theNext = null;
                return false;
            }
            KeyValue firstKeyOnPreviousRow = KeyValueUtil.createFirstOnRow((byte[])lastCellBeforeRow.getRowArray(), (int)lastCellBeforeRow.getRowOffset(), (short)lastCellBeforeRow.getRowLength());
            this.stopSkippingCellsIfNextRow = true;
            this.seek((Cell)firstKeyOnPreviousRow);
            this.stopSkippingCellsIfNextRow = false;
            if (this.peek() == null || DefaultMemStore.this.comparator.compareRows(this.peek(), (Cell)firstKeyOnPreviousRow) > 0) {
                return this.seekToPreviousRow(lastCellBeforeRow);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToLastRow() {
            Cell second;
            Cell first = this.cellSetAtCreation.isEmpty() ? null : this.cellSetAtCreation.last();
            Cell higherCell = this.getHighest(first, second = this.snapshotAtCreation.isEmpty() ? null : this.snapshotAtCreation.last());
            if (higherCell == null) {
                return false;
            }
            KeyValue firstCellOnLastRow = KeyValueUtil.createFirstOnRow((byte[])higherCell.getRowArray(), (int)higherCell.getRowOffset(), (short)higherCell.getRowLength());
            if (this.seek((Cell)firstCellOnLastRow)) {
                return true;
            }
            return this.seekToPreviousRow(higherCell);
        }
    }

    private static class Member {
        final Cell cell;
        final NavigableSet<Cell> set;

        Member(NavigableSet<Cell> s, Cell kv) {
            this.cell = kv;
            this.set = s;
        }
    }
}

