/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.ConsoleReporter;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class HFilePrettyPrinter
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(HFilePrettyPrinter.class);
    private Options options = new Options();
    private boolean verbose;
    private boolean printValue;
    private boolean printKey;
    private boolean shouldPrintMeta;
    private boolean printBlockIndex;
    private boolean printBlockHeaders;
    private boolean printStats;
    private boolean checkRow;
    private boolean checkFamily;
    private boolean isSeekToRow = false;
    private byte[] row = null;
    private List<Path> files = new ArrayList<Path>();
    private int count;
    private static final String FOUR_SPACES = "    ";

    public HFilePrettyPrinter() {
        this.init();
    }

    public HFilePrettyPrinter(Configuration conf) {
        super(conf);
        this.init();
    }

    private void init() {
        this.options.addOption("v", "verbose", false, "Verbose output; emits file and meta data delimiters");
        this.options.addOption("p", "printkv", false, "Print key/value pairs");
        this.options.addOption("e", "printkey", false, "Print keys");
        this.options.addOption("m", "printmeta", false, "Print meta data of file");
        this.options.addOption("b", "printblocks", false, "Print block index meta data");
        this.options.addOption("h", "printblockheaders", false, "Print block headers for each block.");
        this.options.addOption("k", "checkrow", false, "Enable row order check; looks for out-of-order keys");
        this.options.addOption("a", "checkfamily", false, "Enable family check");
        this.options.addOption("w", "seekToRow", true, "Seek to this row and print all the kvs for this row only");
        this.options.addOption("s", "stats", false, "Print statistics");
        OptionGroup files = new OptionGroup();
        files.addOption(new Option("f", "file", true, "File to scan. Pass full-path; e.g. hdfs://a:9000/hbase/hbase:meta/12/34"));
        files.addOption(new Option("r", "region", true, "Region to scan. Pass region name; e.g. 'hbase:meta,,1'"));
        this.options.addOptionGroup(files);
    }

    public boolean parseOptions(String[] args) throws ParseException, IOException {
        if (args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("HFile", this.options, true);
            return false;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args);
        this.verbose = cmd.hasOption("v");
        this.printValue = cmd.hasOption("p");
        this.printKey = cmd.hasOption("e") || this.printValue;
        this.shouldPrintMeta = cmd.hasOption("m");
        this.printBlockIndex = cmd.hasOption("b");
        this.printBlockHeaders = cmd.hasOption("h");
        this.printStats = cmd.hasOption("s");
        this.checkRow = cmd.hasOption("k");
        this.checkFamily = cmd.hasOption("a");
        if (cmd.hasOption("f")) {
            this.files.add(new Path(cmd.getOptionValue("f")));
        }
        if (cmd.hasOption("w")) {
            String key = cmd.getOptionValue("w");
            if (key != null && key.length() != 0) {
                this.row = key.getBytes();
                this.isSeekToRow = true;
            } else {
                System.err.println("Invalid row is specified.");
                System.exit(-1);
            }
        }
        if (cmd.hasOption("r")) {
            String regionName = cmd.getOptionValue("r");
            byte[] rn = Bytes.toBytes((String)regionName);
            byte[][] hri = HRegionInfo.parseRegionName((byte[])rn);
            Path rootDir = FSUtils.getRootDir(this.getConf());
            Path tableDir = FSUtils.getTableDir(rootDir, TableName.valueOf((byte[])hri[0]));
            String enc = HRegionInfo.encodeRegionName((byte[])rn);
            Path regionDir = new Path(tableDir, enc);
            if (this.verbose) {
                System.out.println("region dir -> " + regionDir);
            }
            List<Path> regionFiles = HFile.getStoreFiles(FileSystem.get((Configuration)this.getConf()), regionDir);
            if (this.verbose) {
                System.out.println("Number of region files found -> " + regionFiles.size());
            }
            if (this.verbose) {
                int i = 1;
                for (Path p : regionFiles) {
                    if (!this.verbose) continue;
                    System.out.println("Found file[" + i++ + "] -> " + p);
                }
            }
            this.files.addAll(regionFiles);
        }
        return true;
    }

    public int run(String[] args) {
        if (this.getConf() == null) {
            throw new RuntimeException("A Configuration instance must be provided.");
        }
        try {
            FSUtils.setFsDefault(this.getConf(), FSUtils.getRootDir(this.getConf()));
            if (!this.parseOptions(args)) {
                return 1;
            }
        }
        catch (IOException ex) {
            LOG.error((Object)"Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        catch (ParseException ex) {
            LOG.error((Object)"Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        for (Path fileName : this.files) {
            try {
                this.processFile(fileName);
            }
            catch (IOException ex) {
                LOG.error((Object)("Error reading " + fileName), (Throwable)ex);
                System.exit(-2);
            }
        }
        if (this.verbose || this.printKey) {
            System.out.println("Scanned kv count -> " + this.count);
        }
        return 0;
    }

    private void processFile(Path file) throws IOException {
        FileSystem fs;
        if (this.verbose) {
            System.out.println("Scanning -> " + file);
        }
        if (!(fs = file.getFileSystem(this.getConf())).exists(file)) {
            System.err.println("ERROR, file doesnt exist: " + file);
            System.exit(-2);
        }
        HFile.Reader reader = HFile.createReader(fs, file, new CacheConfig(this.getConf()), this.getConf());
        Map<byte[], byte[]> fileInfo = reader.loadFileInfo();
        KeyValueStatsCollector fileStats = null;
        if (this.verbose || this.printKey || this.checkRow || this.checkFamily || this.printStats) {
            HFileScanner scanner = reader.getScanner(false, false, false);
            fileStats = new KeyValueStatsCollector();
            boolean shouldScanKeysValues = false;
            shouldScanKeysValues = this.isSeekToRow ? scanner.seekTo(KeyValueUtil.createFirstOnRow((byte[])this.row).getKey()) != -1 : scanner.seekTo();
            if (shouldScanKeysValues) {
                this.scanKeysValues(file, fileStats, scanner, this.row);
            }
        }
        if (this.shouldPrintMeta) {
            this.printMeta(reader, fileInfo);
        }
        if (this.printBlockIndex) {
            System.out.println("Block Index:");
            System.out.println(reader.getDataBlockIndexReader());
        }
        if (this.printBlockHeaders) {
            HFileBlock block;
            System.out.println("Block Headers:");
            FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, file);
            long fileSize = fs.getFileStatus(file).getLen();
            FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis.getStream(false), fileSize);
            long max = trailer.getLastDataBlockOffset();
            for (long offset = trailer.getFirstDataBlockOffset(); offset <= max; offset += (long)block.getOnDiskSizeWithHeader()) {
                block = reader.readBlock(offset, -1L, false, false, false, false, null, null);
                System.out.println(block);
            }
        }
        if (this.printStats) {
            fileStats.finish();
            System.out.println("Stats:\n" + fileStats);
        }
        reader.close();
    }

    private void scanKeysValues(Path file, KeyValueStatsCollector fileStats, HFileScanner scanner, byte[] row) throws IOException {
        Cell pCell = null;
        do {
            Cell cell = scanner.getKeyValue();
            if (row != null && row.length != 0) {
                int result = CellComparator.compareRows((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])row, (int)0, (int)row.length);
                if (result > 0) break;
                if (result < 0) continue;
            }
            if (this.printStats) {
                fileStats.collect(cell);
            }
            if (this.printKey) {
                System.out.print("K: " + cell);
                if (this.printValue) {
                    System.out.print(" V: " + Bytes.toStringBinary((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                    int i = 0;
                    List tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
                    for (Tag tag : tags) {
                        System.out.print(String.format(" T[%d]: %s", i++, Bytes.toStringBinary((byte[])tag.getBuffer(), (int)tag.getTagOffset(), (int)tag.getTagLength())));
                    }
                }
                System.out.println();
            }
            if (this.checkRow && pCell != null && CellComparator.compareRows(pCell, (Cell)cell) > 0) {
                System.err.println("WARNING, previous row is greater then current row\n\tfilename -> " + file + "\n\tprevious -> " + CellUtil.getCellKeyAsString((Cell)pCell) + "\n\tcurrent  -> " + CellUtil.getCellKeyAsString((Cell)cell));
            }
            if (this.checkFamily) {
                String fam = Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength());
                if (!file.toString().contains(fam)) {
                    System.err.println("WARNING, filename does not match kv family,\n\tfilename -> " + file + "\n\tkeyvalue -> " + CellUtil.getCellKeyAsString((Cell)cell));
                }
                if (pCell != null && CellComparator.compareFamilies((Cell)pCell, (Cell)cell) != 0) {
                    System.err.println("WARNING, previous kv has different family compared to current key\n\tfilename -> " + file + "\n\tprevious -> " + CellUtil.getCellKeyAsString((Cell)pCell) + "\n\tcurrent  -> " + CellUtil.getCellKeyAsString((Cell)cell));
                }
            }
            pCell = cell;
            ++this.count;
        } while (scanner.next());
    }

    private static String asSeparateLines(String keyValueStr) {
        return keyValueStr.replaceAll(", ([a-zA-Z]+=)", ",\n    $1");
    }

    private void printMeta(HFile.Reader reader, Map<byte[], byte[]> fileInfo) throws IOException {
        System.out.println("Block index size as per heapsize: " + reader.indexSize());
        System.out.println(HFilePrettyPrinter.asSeparateLines(reader.toString()));
        System.out.println("Trailer:\n    " + HFilePrettyPrinter.asSeparateLines(reader.getTrailer().toString()));
        System.out.println("Fileinfo:");
        for (Map.Entry<byte[], byte[]> e : fileInfo.entrySet()) {
            System.out.print(FOUR_SPACES + Bytes.toString((byte[])e.getKey()) + " = ");
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])Bytes.toBytes((String)"MAX_SEQ_ID_KEY")) == 0) {
                long seqid = Bytes.toLong((byte[])e.getValue());
                System.out.println(seqid);
                continue;
            }
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])Bytes.toBytes((String)"TIMERANGE")) == 0) {
                TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])e.getValue(), (Writable)timeRangeTracker);
                System.out.println(timeRangeTracker.getMinimumTimestamp() + "...." + timeRangeTracker.getMaximumTimestamp());
                continue;
            }
            if (Bytes.compareTo((byte[])e.getKey(), (byte[])HFile.FileInfo.AVG_KEY_LEN) == 0 || Bytes.compareTo((byte[])e.getKey(), (byte[])HFile.FileInfo.AVG_VALUE_LEN) == 0) {
                System.out.println(Bytes.toInt((byte[])e.getValue()));
                continue;
            }
            System.out.println(Bytes.toStringBinary((byte[])e.getValue()));
        }
        try {
            System.out.println("Mid-key: " + Bytes.toStringBinary((byte[])reader.midkey()));
        }
        catch (Exception e) {
            System.out.println("Unable to retrieve the midkey");
        }
        DataInput bloomMeta = reader.getGeneralBloomFilterMetadata();
        BloomFilter bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        System.out.println("Bloom filter:");
        if (bloomFilter != null) {
            System.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            System.out.println("    Not present");
        }
        bloomMeta = reader.getDeleteBloomFilterMetadata();
        bloomFilter = null;
        if (bloomMeta != null) {
            bloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, reader);
        }
        System.out.println("Delete Family Bloom filter:");
        if (bloomFilter != null) {
            System.out.println(FOUR_SPACES + bloomFilter.toString().replaceAll("; ", "\n    "));
        } else {
            System.out.println("    Not present");
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new HFilePrettyPrinter(), (String[])args);
        System.exit(ret);
    }

    private static class SimpleReporter
    extends ConsoleReporter {
        private final PrintStream out;

        public SimpleReporter(MetricsRegistry metricsRegistry, PrintStream out) {
            super(metricsRegistry, out, MetricPredicate.ALL);
            this.out = out;
        }

        public void run() {
            for (Map.Entry entry : this.getMetricsRegistry().groupedMetrics(MetricPredicate.ALL).entrySet()) {
                try {
                    for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                        this.out.print("   " + ((MetricName)subEntry.getKey()).getName());
                        this.out.println(':');
                        ((Metric)subEntry.getValue()).processWith((MetricProcessor)this, (MetricName)subEntry.getKey(), (Object)this.out);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(this.out);
                }
            }
        }

        public void processHistogram(MetricName name, Histogram histogram, PrintStream stream) {
            super.processHistogram(name, histogram, stream);
            stream.printf(Locale.getDefault(), "             count = %d%n", histogram.count());
        }
    }

    private static class KeyValueStatsCollector {
        private final MetricsRegistry metricsRegistry = new MetricsRegistry();
        private final ByteArrayOutputStream metricsOutput = new ByteArrayOutputStream();
        private final SimpleReporter simpleReporter = new SimpleReporter(this.metricsRegistry, new PrintStream(this.metricsOutput));
        Histogram keyLen = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Key length");
        Histogram valLen = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Val length");
        Histogram rowSizeBytes = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Row size (bytes)");
        Histogram rowSizeCols = this.metricsRegistry.newHistogram(HFilePrettyPrinter.class, "Row size (columns)");
        long curRowBytes = 0L;
        long curRowCols = 0L;
        byte[] biggestRow = null;
        private Cell prevCell = null;
        private long maxRowBytes = 0L;
        private long curRowKeyLength;

        private KeyValueStatsCollector() {
        }

        public void collect(Cell cell) {
            this.valLen.update(cell.getValueLength());
            if (this.prevCell != null && KeyValue.COMPARATOR.compareRows(this.prevCell, cell) != 0) {
                this.collectRow();
            }
            this.curRowBytes += (long)KeyValueUtil.length((Cell)cell);
            this.curRowKeyLength = KeyValueUtil.keyLength((Cell)cell);
            ++this.curRowCols;
            this.prevCell = cell;
        }

        private void collectRow() {
            this.rowSizeBytes.update(this.curRowBytes);
            this.rowSizeCols.update(this.curRowCols);
            this.keyLen.update(this.curRowKeyLength);
            if (this.curRowBytes > this.maxRowBytes && this.prevCell != null) {
                this.biggestRow = this.prevCell.getRow();
                this.maxRowBytes = this.curRowBytes;
            }
            this.curRowBytes = 0L;
            this.curRowCols = 0L;
        }

        public void finish() {
            if (this.curRowCols > 0L) {
                this.collectRow();
            }
        }

        public String toString() {
            if (this.prevCell == null) {
                return "no data available for statistics";
            }
            this.simpleReporter.shutdown();
            this.simpleReporter.run();
            this.metricsRegistry.shutdown();
            return this.metricsOutput.toString() + "Key of biggest row: " + Bytes.toStringBinary((byte[])this.biggestRow);
        }
    }
}

