/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;

@InterfaceAudience.Private
public class ExistsResource
extends ResourceBase {
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public ExistsResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf", "application/octet-stream"})
    public Response get(@Context UriInfo uriInfo) {
        try {
            if (!this.tableResource.exists()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
        Response.ResponseBuilder response = Response.ok();
        response.cacheControl(cacheControl);
        return response.build();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

