/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.resource.JerseyResource;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.SimpleKdcServerUtil;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.JaasKrbUtil;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestProxyUserSpnegoHttpServer
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProxyUserSpnegoHttpServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProxyUserSpnegoHttpServer.class);
    private static final String KDC_SERVER_HOST = "localhost";
    private static final String WHEEL_PRINCIPAL = "wheel";
    private static final String UNPRIVILEGED_PRINCIPAL = "unprivileged";
    private static final String PRIVILEGED_PRINCIPAL = "privileged";
    private static final String PRIVILEGED2_PRINCIPAL = "privileged2";
    private static HttpServer server;
    private static URL baseUrl;
    private static SimpleKdcServer kdc;
    private static File infoServerKeytab;
    private static File wheelKeytab;
    private static File unprivilegedKeytab;
    private static File privilegedKeytab;
    private static File privileged2Keytab;

    @BeforeClass
    public static void setupServer() throws Exception {
        Configuration conf = new Configuration();
        HBaseCommonTestingUtility htu = new HBaseCommonTestingUtility(conf);
        String serverPrincipal = "HTTP/localhost";
        kdc = SimpleKdcServerUtil.getRunningSimpleKdcServer((File)new File(htu.getDataTestDir().toString()), HBaseCommonTestingUtility::randomFreePort);
        File keytabDir = new File(htu.getDataTestDir("keytabs").toString());
        if (keytabDir.exists()) {
            TestProxyUserSpnegoHttpServer.deleteRecursively(keytabDir);
        }
        keytabDir.mkdirs();
        infoServerKeytab = new File(keytabDir, "HTTP/localhost".replace('/', '_') + ".keytab");
        wheelKeytab = new File(keytabDir, "wheel.keytab");
        unprivilegedKeytab = new File(keytabDir, "unprivileged.keytab");
        privilegedKeytab = new File(keytabDir, "privileged.keytab");
        privileged2Keytab = new File(keytabDir, "privileged2.keytab");
        TestProxyUserSpnegoHttpServer.setupUser(kdc, wheelKeytab, WHEEL_PRINCIPAL);
        TestProxyUserSpnegoHttpServer.setupUser(kdc, unprivilegedKeytab, UNPRIVILEGED_PRINCIPAL);
        TestProxyUserSpnegoHttpServer.setupUser(kdc, privilegedKeytab, PRIVILEGED_PRINCIPAL);
        TestProxyUserSpnegoHttpServer.setupUser(kdc, privileged2Keytab, PRIVILEGED2_PRINCIPAL);
        TestProxyUserSpnegoHttpServer.setupUser(kdc, infoServerKeytab, "HTTP/localhost");
        TestProxyUserSpnegoHttpServer.buildSpnegoConfiguration(conf, "HTTP/localhost", infoServerKeytab);
        AccessControlList acl = TestProxyUserSpnegoHttpServer.buildAdminAcl(conf);
        server = TestProxyUserSpnegoHttpServer.createTestServerWithSecurityAndAcl(conf, acl);
        server.addPrivilegedServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestProxyUserSpnegoHttpServer.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        try {
            if (null != server) {
                server.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop info server", (Throwable)e);
        }
        try {
            if (null != kdc) {
                kdc.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop mini KDC", (Throwable)e);
        }
    }

    private static void setupUser(SimpleKdcServer kdc, File keytab, String principal) throws KrbException {
        kdc.createPrincipal(principal);
        kdc.exportPrincipal(principal, keytab);
    }

    protected static Configuration buildSpnegoConfiguration(Configuration conf, String serverPrincipal, File serverKeytab) {
        KerberosName.setRules((String)"DEFAULT");
        conf.setInt("hbase.http.max.threads", 16);
        conf.set("hbase.security.authentication", "kerberos");
        conf.set("hbase.security.authentication.ui", "kerberos");
        conf.set("hbase.security.authentication.spnego.kerberos.principal", serverPrincipal);
        conf.set("hbase.security.authentication.spnego.kerberos.keytab", serverKeytab.getAbsolutePath());
        conf.set("hbase.security.authentication.spnego.admin.users", PRIVILEGED_PRINCIPAL);
        conf.set("hbase.security.authentication.spnego.kerberos.proxyuser.enable", "true");
        conf.set("hadoop.security.authorization", "true");
        conf.set("hadoop.proxyuser.wheel.hosts", "*");
        conf.set("hadoop.proxyuser.wheel.users", "privileged,unprivileged");
        return conf;
    }

    public static AccessControlList buildAdminAcl(Configuration conf) {
        String userGroups = conf.get("hbase.security.authentication.spnego.admin.users", null);
        String adminGroups = conf.get("hbase.security.authentication.spnego.admin.groups", null);
        if (userGroups == null && adminGroups == null) {
            return new AccessControlList("*", null);
        }
        return new AccessControlList(userGroups, adminGroups);
    }

    @Test
    public void testProxyAllowed() throws Exception {
        this.testProxy(WHEEL_PRINCIPAL, PRIVILEGED_PRINCIPAL, 200, null);
    }

    @Test
    public void testProxyDisallowedForUnprivileged() throws Exception {
        this.testProxy(WHEEL_PRINCIPAL, UNPRIVILEGED_PRINCIPAL, 403, "403 User unprivileged is unauthorized to access this page.");
    }

    @Test
    public void testProxyDisallowedForNotSudoAble() throws Exception {
        this.testProxy(WHEEL_PRINCIPAL, PRIVILEGED2_PRINCIPAL, 403, "403 Forbidden");
    }

    public void testProxy(String clientPrincipal, final String doAs, int responseCode, String statusLine) throws Exception {
        Subject clientSubject = JaasKrbUtil.loginUsingKeytab((String)WHEEL_PRINCIPAL, (File)wheelKeytab);
        Set<Principal> clientPrincipals = clientSubject.getPrincipals();
        Assert.assertFalse((boolean)clientPrincipals.isEmpty());
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        Assert.assertFalse((boolean)privateCredentials.isEmpty());
        KerberosTicket tgt = privateCredentials.iterator().next();
        Assert.assertNotNull((Object)tgt);
        final String principalName = clientPrincipals.iterator().next().getName();
        HttpResponse resp = Subject.doAs(clientSubject, new PrivilegedExceptionAction<HttpResponse>(){

            @Override
            public HttpResponse run() throws Exception {
                GSSManager gssManager = GSSManager.getInstance();
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSName gssClient = gssManager.createName(principalName, GSSName.NT_USER_NAME);
                GSSCredential credential = gssManager.createCredential(gssClient, 0, oid, 1);
                HttpClientContext context = HttpClientContext.create();
                Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
                CloseableHttpClient client = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).build();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
                URL url = new URL(HttpServerFunctionalTest.getServerURL(server), "/echo?doAs=" + doAs + "&a=b");
                context.setTargetHost(new HttpHost(url.getHost(), url.getPort()));
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                context.setAuthSchemeRegistry((Lookup)authRegistry);
                HttpGet get = new HttpGet(url.toURI());
                return client.execute((HttpUriRequest)get, (HttpContext)context);
            }
        });
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((long)responseCode, (long)resp.getStatusLine().getStatusCode());
        if (responseCode == 200) {
            Assert.assertTrue((boolean)EntityUtils.toString((HttpEntity)resp.getEntity()).trim().contains("a:b"));
        } else {
            Assert.assertTrue((resp.getStatusLine().toString().contains(statusLine) || EntityUtils.toString((HttpEntity)resp.getEntity()).contains(statusLine) ? 1 : 0) != 0);
        }
    }
}

