/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={HttpServerFunctionalTest.class, MediumTests.class})
public class TestSecurityHeadersFilter {
    private static URL baseUrl;
    private HttpServer http;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE;

    @After
    public void tearDown() throws Exception {
        this.http.stop();
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.http = HttpServerFunctionalTest.createTestServer();
        this.http.start();
        baseUrl = HttpServerFunctionalTest.getServerURL(this.http);
        URL url = new URL(baseUrl, "/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        MatcherAssert.assertThat((Object)conn.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((String)"Header 'X-Content-Type-Options' is missing", (Object)conn.getHeaderField("X-Content-Type-Options"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)null)));
        MatcherAssert.assertThat((Object)conn.getHeaderField("X-Content-Type-Options"), (Matcher)CoreMatchers.equalTo((Object)"nosniff"));
        MatcherAssert.assertThat((String)"Header 'X-XSS-Protection' is missing", (Object)conn.getHeaderField("X-XSS-Protection"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)null)));
        MatcherAssert.assertThat((String)"Header 'X-XSS-Protection' has invalid value", (Object)conn.getHeaderField("X-XSS-Protection"), (Matcher)CoreMatchers.equalTo((Object)"1; mode=block"));
        MatcherAssert.assertThat((String)"Header 'Strict-Transport-Security' should be missing from response,but it's present", (Object)conn.getHeaderField("Strict-Transport-Security"), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((String)"Header 'Content-Security-Policy' should be missing from response,but it's present", (Object)conn.getHeaderField("Content-Security-Policy"), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testHstsAndCspSettings() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbase.http.filter.hsts.value", "max-age=63072000;includeSubDomains;preload");
        conf.set("hbase.http.filter.csp.value", "default-src https: data: 'unsafe-inline' 'unsafe-eval'");
        this.http = HttpServerFunctionalTest.createTestServer(conf);
        this.http.start();
        baseUrl = HttpServerFunctionalTest.getServerURL(this.http);
        URL url = new URL(baseUrl, "/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        MatcherAssert.assertThat((Object)conn.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((String)"Header 'Strict-Transport-Security' is missing from Rest response", (Object)conn.getHeaderField("Strict-Transport-Security"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        MatcherAssert.assertThat((String)"Header 'Strict-Transport-Security' has invalid value", (Object)conn.getHeaderField("Strict-Transport-Security"), (Matcher)IsEqual.equalTo((Object)"max-age=63072000;includeSubDomains;preload"));
        MatcherAssert.assertThat((String)"Header 'Content-Security-Policy' is missing from Rest response", (Object)conn.getHeaderField("Content-Security-Policy"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        MatcherAssert.assertThat((String)"Header 'Content-Security-Policy' has invalid value", (Object)conn.getHeaderField("Content-Security-Policy"), (Matcher)IsEqual.equalTo((Object)"default-src https: data: 'unsafe-inline' 'unsafe-eval'"));
    }

    static {
        CLASS_RULE = HBaseClassTestRule.forClass(TestSecurityHeadersFilter.class);
    }
}

