/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsTableSourceImpl
implements MetricsTableSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsTableSourceImpl.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private MetricsTableWrapperAggregate tableWrapperAgg;
    private final MetricsTableAggregateSourceImpl agg;
    private final DynamicMetricsRegistry registry;
    private final String tableNamePrefix;
    private final TableName tableName;
    private final int hashCode;

    public MetricsTableSourceImpl(String tblName, MetricsTableAggregateSourceImpl aggregate, MetricsTableWrapperAggregate tblWrapperAgg) {
        LOG.debug("Creating new MetricsTableSourceImpl for table ");
        this.tableName = TableName.valueOf((String)tblName);
        this.agg = aggregate;
        this.agg.register(tblName, this);
        this.tableWrapperAgg = tblWrapperAgg;
        this.registry = this.agg.getMetricsRegistry();
        this.tableNamePrefix = "Namespace_" + this.tableName.getNamespaceAsString() + "_table_" + this.tableName.getQualifierAsString() + "_metric_";
        this.hashCode = this.tableName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        this.agg.deregister(this.tableName.getNameAsString());
        MetricsTableSourceImpl metricsTableSourceImpl = this;
        synchronized (metricsTableSourceImpl) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removing table Metrics for table ");
            }
            this.tableWrapperAgg = null;
        }
    }

    public MetricsTableAggregateSource getAggregateSource() {
        return this.agg;
    }

    public int compareTo(MetricsTableSource source) {
        if (!(source instanceof MetricsTableSourceImpl)) {
            return -1;
        }
        MetricsTableSourceImpl impl = (MetricsTableSourceImpl)source;
        if (impl == null) {
            return -1;
        }
        return Long.compare(this.hashCode, impl.hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsTableSourceImpl metricsTableSourceImpl = this;
        synchronized (metricsTableSourceImpl) {
            if (this.closed.get()) {
                return;
            }
            if (this.tableWrapperAgg != null) {
                mrb.addCounter(Interns.info(this.tableNamePrefix + "readRequestCount", "Number of read requests"), this.tableWrapperAgg.getReadRequestsCount(this.tableName.getNameAsString()));
                mrb.addCounter(Interns.info(this.tableNamePrefix + "writeRequestCount", "Number of write requests"), this.tableWrapperAgg.getWriteRequestsCount(this.tableName.getNameAsString()));
                mrb.addCounter(Interns.info(this.tableNamePrefix + "totalRequestCount", "Number of total requests"), this.tableWrapperAgg.getTotalRequestsCount(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "memstoreSize", "The size of memory stores"), this.tableWrapperAgg.getMemStoresSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "storeFileSize", "The size of store files size"), this.tableWrapperAgg.getStoreFilesSize(this.tableName.getNameAsString()));
                mrb.addGauge(Interns.info(this.tableNamePrefix + "tableSize", "Total size of the table in the region server"), this.tableWrapperAgg.getTableSize(this.tableName.getNameAsString()));
            }
        }
    }

    public String getTableName() {
        return this.tableName.getNameAsString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((MetricsTableSourceImpl)o) == 0;
    }

    public MetricsTableWrapperAggregate getTableWrapper() {
        return this.tableWrapperAgg;
    }

    public String getTableNamePrefix() {
        return this.tableNamePrefix;
    }
}

