/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class JmxCacheBuster {
    private static final Log LOG = LogFactory.getLog(JmxCacheBuster.class);
    private static AtomicReference<ScheduledFuture> fut = new AtomicReference<Object>(null);
    private static MetricsExecutor executor = new MetricsExecutorImpl();
    private static AtomicBoolean stopped = new AtomicBoolean(false);

    private JmxCacheBuster() {
    }

    public static void clearJmxCache() {
        ScheduledFuture<?> future;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("clearing JMX Cache" + StringUtils.stringifyException((Throwable)new Exception())));
        }
        if ((future = fut.get()) != null && !future.isDone() && future.getDelay(TimeUnit.MILLISECONDS) > 100L) {
            return;
        }
        if (stopped.get()) {
            return;
        }
        future = executor.getExecutor().schedule(new JmxCacheBusterRunnable(), 5L, TimeUnit.SECONDS);
        fut.set(future);
    }

    @VisibleForTesting
    public static void stop() {
        stopped.set(true);
        ScheduledFuture future = fut.get();
        future.cancel(false);
    }

    @VisibleForTesting
    public static void restart() {
        stopped.set(false);
    }

    static final class JmxCacheBusterRunnable
    implements Runnable {
        JmxCacheBusterRunnable() {
        }

        @Override
        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Clearing JMX mbean cache.");
            }
            try {
                if (DefaultMetricsSystem.instance() != null) {
                    DefaultMetricsSystem.instance().stop();
                    Thread.sleep(500L);
                    DefaultMetricsSystem.instance().start();
                }
            }
            catch (Exception exception) {
                LOG.debug((Object)"error clearing the jmx it appears the metrics system hasn't been started", (Throwable)exception);
            }
        }
    }
}

