/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationTableSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

public class MetricsReplicationTableSourceImpl
implements MetricsReplicationTableSource {
    private final MetricsReplicationSourceImpl rms;
    private final String tableName;
    private final String ageOfLastShippedOpKey;
    private String keyPrefix;
    private final String shippedBytesKey;
    private final MutableHistogram ageOfLastShippedOpHist;
    private final MutableFastCounter shippedBytesCounter;

    public MetricsReplicationTableSourceImpl(MetricsReplicationSourceImpl rms, String tableName) {
        this.rms = rms;
        this.tableName = tableName;
        this.keyPrefix = "source." + this.tableName + ".";
        this.ageOfLastShippedOpKey = this.keyPrefix + "ageOfLastShippedOp";
        this.ageOfLastShippedOpHist = rms.getMetricsRegistry().newTimeHistogram(this.ageOfLastShippedOpKey);
        this.shippedBytesKey = this.keyPrefix + "shippedBytes";
        this.shippedBytesCounter = rms.getMetricsRegistry().getCounter(this.shippedBytesKey, 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpHist.add(age);
    }

    public void incrShippedBytes(long size) {
        this.shippedBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.shippedBytesKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpHist.getMax();
    }

    public long getShippedBytes() {
        return this.shippedBytesCounter.value();
    }

    public void init() {
        this.rms.init();
    }

    public void setGauge(String gaugeName, long value) {
        this.rms.setGauge(this.keyPrefix + gaugeName, value);
    }

    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(this.keyPrefix + gaugeName, delta);
    }

    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(this.keyPrefix + gaugeName, delta);
    }

    public void removeMetric(String key) {
        this.rms.removeMetric(this.keyPrefix + key);
    }

    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(this.keyPrefix + counterName, delta);
    }

    public void updateHistogram(String name, long value) {
        this.rms.updateHistogram(this.keyPrefix + name, value);
    }

    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    public String getMetricsName() {
        return this.rms.getMetricsName();
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.rms.getMetricRegistryInfo();
    }
}

