/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private String keyPrefix;
    @Deprecated
    private final String shippedKBsKey;
    private final String shippedBytesKey;
    private final String logReadInBytesKey;
    private final String shippedHFilesKey;
    private final String sizeOfHFileRefsQueueKey;
    private final String oldestWalAgeKey;
    private final String sourceInitializingKey;
    private final MutableHistogram ageOfLastShippedOpHist;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableFastCounter logReadInEditsCounter;
    private final MutableFastCounter logEditsFilteredCounter;
    private final MutableFastCounter shippedBatchesCounter;
    private final MutableFastCounter shippedOpsCounter;
    private final MutableFastCounter shippedKBsCounter;
    private final MutableFastCounter shippedBytesCounter;
    private final MutableFastCounter logReadInBytesCounter;
    private final MutableFastCounter shippedHFilesCounter;
    private final MutableGaugeLong sizeOfHFileRefsQueueGauge;
    private final String unknownFileLengthKey;
    private final String uncleanlyClosedKey;
    private final String uncleanlySkippedBytesKey;
    private final String restartedKey;
    private final String repeatedBytesKey;
    private final String completedLogsKey;
    private final String completedRecoveryKey;
    private final MutableFastCounter unknownFileLengthForClosedWAL;
    private final MutableFastCounter uncleanlyClosedWAL;
    private final MutableFastCounter uncleanlyClosedSkippedBytes;
    private final MutableFastCounter restartWALReading;
    private final MutableFastCounter repeatedFileBytes;
    private final MutableFastCounter completedWAL;
    private final MutableFastCounter completedRecoveryQueue;
    private final MutableGaugeLong oldestWalAge;
    private final MutableGaugeInt sourceInitializing;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.keyPrefix = "source." + this.id + ".";
        this.ageOfLastShippedOpKey = this.keyPrefix + "ageOfLastShippedOp";
        this.ageOfLastShippedOpHist = rms.getMetricsRegistry().newTimeHistogram(this.ageOfLastShippedOpKey);
        this.sizeOfLogQueueKey = this.keyPrefix + "sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = this.keyPrefix + "shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = this.keyPrefix + "shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = this.keyPrefix + "shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getCounter(this.shippedKBsKey, 0L);
        this.shippedBytesKey = this.keyPrefix + "shippedBytes";
        this.shippedBytesCounter = rms.getMetricsRegistry().getCounter(this.shippedBytesKey, 0L);
        this.logReadInBytesKey = this.keyPrefix + "logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = this.keyPrefix + "logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = this.keyPrefix + "logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getCounter(this.logEditsFilteredKey, 0L);
        this.shippedHFilesKey = this.keyPrefix + "shippedHFiles";
        this.shippedHFilesCounter = rms.getMetricsRegistry().getCounter(this.shippedHFilesKey, 0L);
        this.sizeOfHFileRefsQueueKey = this.keyPrefix + "sizeOfHFileRefsQueue";
        this.sizeOfHFileRefsQueueGauge = rms.getMetricsRegistry().getGauge(this.sizeOfHFileRefsQueueKey, 0L);
        this.unknownFileLengthKey = this.keyPrefix + "closedLogsWithUnknownFileLength";
        this.unknownFileLengthForClosedWAL = rms.getMetricsRegistry().getCounter(this.unknownFileLengthKey, 0L);
        this.uncleanlyClosedKey = this.keyPrefix + "uncleanlyClosedLogs";
        this.uncleanlyClosedWAL = rms.getMetricsRegistry().getCounter(this.uncleanlyClosedKey, 0L);
        this.uncleanlySkippedBytesKey = this.keyPrefix + "ignoredUncleanlyClosedLogContentsInBytes";
        this.uncleanlyClosedSkippedBytes = rms.getMetricsRegistry().getCounter(this.uncleanlySkippedBytesKey, 0L);
        this.restartedKey = this.keyPrefix + "restartedLogReading";
        this.restartWALReading = rms.getMetricsRegistry().getCounter(this.restartedKey, 0L);
        this.repeatedBytesKey = this.keyPrefix + "repeatedLogFileBytes";
        this.repeatedFileBytes = rms.getMetricsRegistry().getCounter(this.repeatedBytesKey, 0L);
        this.completedLogsKey = this.keyPrefix + "completedLogs";
        this.completedWAL = rms.getMetricsRegistry().getCounter(this.completedLogsKey, 0L);
        this.completedRecoveryKey = this.keyPrefix + "completedRecoverQueues";
        this.completedRecoveryQueue = rms.getMetricsRegistry().getCounter(this.completedRecoveryKey, 0L);
        this.oldestWalAgeKey = this.keyPrefix + "oldestWalAge";
        this.oldestWalAge = rms.getMetricsRegistry().getGauge(this.oldestWalAgeKey, 0L);
        this.sourceInitializingKey = this.keyPrefix + "isInitializing";
        this.sourceInitializing = rms.getMetricsRegistry().getGaugeInt(this.sourceInitializingKey, 0);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpHist.add(age);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedBytes(long size) {
        this.shippedBytesCounter.incr(size);
        MetricsReplicationGlobalSourceSource.incrementKBsCounter(this.shippedBytesCounter, this.shippedKBsCounter);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.shippedBytesKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
        this.rms.removeMetric(this.shippedHFilesKey);
        this.rms.removeMetric(this.sizeOfHFileRefsQueueKey);
        this.rms.removeMetric(this.unknownFileLengthKey);
        this.rms.removeMetric(this.uncleanlyClosedKey);
        this.rms.removeMetric(this.uncleanlySkippedBytesKey);
        this.rms.removeMetric(this.restartedKey);
        this.rms.removeMetric(this.repeatedBytesKey);
        this.rms.removeMetric(this.completedLogsKey);
        this.rms.removeMetric(this.completedRecoveryKey);
        this.rms.removeMetric(this.oldestWalAgeKey);
        this.rms.removeMetric(this.sourceInitializingKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpHist.getMax();
    }

    public void incrHFilesShipped(long hfiles) {
        this.shippedHFilesCounter.incr(hfiles);
    }

    public void incrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.incr(size);
    }

    public void decrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.decr(size);
    }

    public int getSizeOfLogQueue() {
        return (int)this.sizeOfLogQueueGauge.value();
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.unknownFileLengthForClosedWAL.incr(1L);
    }

    public void incrUncleanlyClosedWALs() {
        this.uncleanlyClosedWAL.incr(1L);
    }

    public long getUncleanlyClosedWALs() {
        return this.uncleanlyClosedWAL.value();
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.uncleanlyClosedSkippedBytes.incr(bytes);
    }

    public void incrRestartedWALReading() {
        this.restartWALReading.incr(1L);
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.repeatedFileBytes.incr(bytes);
    }

    public void incrCompletedWAL() {
        this.completedWAL.incr(1L);
    }

    public void incrCompletedRecoveryQueue() {
        this.completedRecoveryQueue.incr(1L);
    }

    public void incrFailedRecoveryQueue() {
    }

    public void setOldestWalAge(long age) {
        this.oldestWalAge.set(age);
    }

    public long getOldestWalAge() {
        return this.oldestWalAge.value();
    }

    public void incrSourceInitializing() {
        this.sourceInitializing.incr(1);
    }

    public int getSourceInitializing() {
        return this.sourceInitializing.value();
    }

    public void decrSourceInitializing() {
        this.sourceInitializing.decr(1);
    }

    public void init() {
        this.rms.init();
    }

    public void setGauge(String gaugeName, long value) {
        this.rms.setGauge(this.keyPrefix + gaugeName, value);
    }

    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(this.keyPrefix + gaugeName, delta);
    }

    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(this.keyPrefix + gaugeName, delta);
    }

    public void removeMetric(String key) {
        this.rms.removeMetric(this.keyPrefix + key);
    }

    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(this.keyPrefix + counterName, delta);
    }

    public void updateHistogram(String name, long value) {
        this.rms.updateHistogram(this.keyPrefix + name, value);
    }

    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    public String getMetricsName() {
        return this.rms.getMetricsName();
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return new MetricRegistryInfo(this.getMetricsName(), this.getMetricsDescription(), this.getMetricsContext(), this.getMetricsJmxContext(), true);
    }
}

