/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.MetricsTableQueryMeter;

@InterfaceAudience.Private
public class MetricsTableQueryMeterImpl
implements MetricsTableQueryMeter {
    private final Map<TableName, TableMeters> metersByTable = new ConcurrentHashMap<TableName, TableMeters>();
    private final MetricRegistry metricRegistry;
    private static final String TABLE_READ_QUERY_PER_SECOND = "tableReadQueryPerSecond";
    private static final String TABLE_WRITE_QUERY_PER_SECOND = "tableWriteQueryPerSecond";

    public MetricsTableQueryMeterImpl(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private static String qualifyMetricsName(TableName tableName, String metric) {
        StringBuilder sb = new StringBuilder();
        sb.append("Namespace_").append(tableName.getNamespaceAsString());
        sb.append("_table_").append(tableName.getQualifierAsString());
        sb.append("_metric_").append(metric);
        return sb.toString();
    }

    private TableMeters getOrCreateTableMeter(TableName tableName) {
        TableMeters meters = this.metersByTable.get(tableName);
        if (meters == null) {
            meters = new TableMeters(this.metricRegistry, tableName);
            this.metersByTable.put(tableName, meters);
        }
        return meters;
    }

    public void updateTableReadQueryMeter(TableName tableName, long count) {
        this.getOrCreateTableMeter(tableName).updateTableReadQueryMeter(count);
    }

    public void updateTableReadQueryMeter(TableName tableName) {
        this.getOrCreateTableMeter(tableName).updateTableReadQueryMeter();
    }

    public void updateTableWriteQueryMeter(TableName tableName, long count) {
        this.getOrCreateTableMeter(tableName).updateTableWriteQueryMeter(count);
    }

    public void updateTableWriteQueryMeter(TableName tableName) {
        this.getOrCreateTableMeter(tableName).updateTableWriteQueryMeter();
    }

    private static class TableMeters {
        final Meter tableReadQueryMeter;
        final Meter tableWriteQueryMeter;

        TableMeters(MetricRegistry metricRegistry, TableName tableName) {
            this.tableReadQueryMeter = metricRegistry.meter(MetricsTableQueryMeterImpl.qualifyMetricsName(tableName, MetricsTableQueryMeterImpl.TABLE_READ_QUERY_PER_SECOND));
            this.tableWriteQueryMeter = metricRegistry.meter(MetricsTableQueryMeterImpl.qualifyMetricsName(tableName, MetricsTableQueryMeterImpl.TABLE_WRITE_QUERY_PER_SECOND));
        }

        public void updateTableReadQueryMeter(long count) {
            this.tableReadQueryMeter.mark(count);
        }

        public void updateTableReadQueryMeter() {
            this.tableReadQueryMeter.mark();
        }

        public void updateTableWriteQueryMeter(long count) {
            this.tableWriteQueryMeter.mark(count);
        }

        public void updateTableWriteQueryMeter() {
            this.tableWriteQueryMeter.mark();
        }
    }
}

