/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xerial;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.xerial.SnappyCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

@InterfaceAudience.Private
public class SnappyCompressor
implements CanReinit,
Compressor {
    protected static final Logger LOG = LoggerFactory.getLogger(SnappyCompressor.class);
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected boolean finish;
    protected boolean finished;
    protected long bytesRead;
    protected long bytesWritten;

    SnappyCompressor(int bufferSize) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            LOG.trace("compress: {} bytes from outBuf", (Object)n);
            return n;
        }
        if (this.finish) {
            if (this.inBuf.position() > 0) {
                this.inBuf.flip();
                int uncompressed = this.inBuf.remaining();
                int needed = this.maxCompressedLength(uncompressed);
                if (this.outBuf.capacity() < needed) {
                    needed = CompressionUtil.roundInt2((int)needed);
                    LOG.trace("setInput: resize inBuf {}", (Object)needed);
                    this.outBuf = ByteBuffer.allocateDirect(needed);
                } else {
                    this.outBuf.clear();
                }
                int written = Snappy.compress((ByteBuffer)this.inBuf, (ByteBuffer)this.outBuf);
                this.bytesWritten += (long)written;
                this.inBuf.clear();
                LOG.trace("compress: compressed {} -> {}", (Object)uncompressed, (Object)written);
                this.finished = true;
                int n = Math.min(written, len);
                this.outBuf.get(b, off, n);
                LOG.trace("compress: {} bytes", (Object)n);
                return n;
            }
            this.finished = true;
        }
        LOG.trace("No output");
        return 0;
    }

    public void end() {
        LOG.trace("end");
    }

    public void finish() {
        LOG.trace("finish");
        this.finish = true;
    }

    public boolean finished() {
        boolean b = this.finished && !this.outBuf.hasRemaining();
        LOG.trace("finished: {}", (Object)b);
        return b;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean needsInput() {
        boolean b = !this.finished();
        LOG.trace("needsInput: {}", (Object)b);
        return b;
    }

    public void reinit(Configuration conf) {
        int newBufferSize;
        LOG.trace("reinit");
        if (conf != null && this.bufferSize != (newBufferSize = SnappyCodec.getBufferSize(conf))) {
            this.bufferSize = newBufferSize;
            this.inBuf = ByteBuffer.allocateDirect(this.bufferSize);
            this.outBuf = ByteBuffer.allocateDirect(this.bufferSize);
        }
        this.reset();
    }

    public void reset() {
        LOG.trace("reset");
        this.inBuf.clear();
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.finish = false;
        this.finished = false;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        LOG.trace("setInput: off={} len={}", (Object)off, (Object)len);
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            LOG.trace("setInput: resize inBuf {}", (Object)needed);
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.bytesRead += (long)len;
        this.finished = false;
    }

    int maxCompressedLength(int len) {
        return Snappy.maxCompressedLength((int)len);
    }
}

