/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBufferPool;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestByteBufferPool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferPool.class);

    @Test
    public void testOffheapBBPool() throws Exception {
        boolean directByteBuffer = true;
        this.testBBPool(10, 100, directByteBuffer);
    }

    @Test
    public void testOnheapBBPool() throws Exception {
        boolean directByteBuffer = false;
        this.testBBPool(10, 100, directByteBuffer);
    }

    private void testBBPool(int maxPoolSize, int bufferSize, boolean directByteBuffer) {
        ByteBufferPool pool = new ByteBufferPool(bufferSize, maxPoolSize, directByteBuffer);
        for (int i = 0; i < maxPoolSize; ++i) {
            ByteBuffer buffer = pool.getBuffer();
            Assert.assertEquals((long)0L, (long)buffer.position());
            Assert.assertEquals((long)bufferSize, (long)buffer.limit());
            Assert.assertEquals((Object)directByteBuffer, (Object)buffer.isDirect());
        }
        Assert.assertEquals((long)0L, (long)pool.getQueueSize());
        ByteBuffer bb = directByteBuffer ? ByteBuffer.allocate(bufferSize) : ByteBuffer.allocateDirect(bufferSize);
        pool.putbackBuffer(bb);
        Assert.assertEquals((long)0L, (long)pool.getQueueSize());
        bb = directByteBuffer ? ByteBuffer.allocateDirect(bufferSize + 1) : ByteBuffer.allocate(bufferSize + 1);
        pool.putbackBuffer(bb);
        Assert.assertEquals((long)0L, (long)pool.getQueueSize());
    }
}

