/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.hbase.thirdparty.io.netty.util.Timeout;
import org.apache.hbase.thirdparty.io.netty.util.TimerTask;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class RpcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(RpcConnection.class);
    protected final ConnectionId remoteId;
    protected final boolean useSasl;
    protected final Token<? extends TokenIdentifier> token;
    protected final SecurityInfo securityInfo;
    protected final int reloginMaxBackoff;
    protected final Codec codec;
    protected final CompressionCodec compressor;
    protected final MetricsConnection metrics;
    protected final HashedWheelTimer timeoutTimer;
    protected final Configuration conf;
    protected static String CRYPTO_AES_ENABLED_KEY = "hbase.rpc.crypto.encryption.aes.enabled";
    protected static boolean CRYPTO_AES_ENABLED_DEFAULT = false;
    protected long lastTouched;
    protected SaslClientAuthenticationProvider provider;

    protected RpcConnection(Configuration conf, HashedWheelTimer timeoutTimer, ConnectionId remoteId, String clusterId, boolean isSecurityEnabled, Codec codec, CompressionCodec compressor, MetricsConnection metrics) throws IOException {
        Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> pair;
        this.timeoutTimer = timeoutTimer;
        this.codec = codec;
        this.compressor = compressor;
        this.conf = conf;
        this.metrics = metrics;
        User ticket = remoteId.getTicket();
        this.securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
        this.useSasl = isSecurityEnabled;
        SaslClientAuthenticationProviders providers = SaslClientAuthenticationProviders.getInstance(conf);
        if (this.useSasl && this.securityInfo != null) {
            pair = providers.selectProvider(clusterId, ticket);
            if (pair == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found no valid authentication method from providers={} with tokens={}", (Object)providers.toString(), (Object)ticket.getTokens());
                }
                throw new RuntimeException("Found no valid authentication method from options");
            }
        } else if (!this.useSasl) {
            pair = providers.getSimpleProvider();
        } else {
            throw new RuntimeException("Could not compute valid client authentication provider");
        }
        this.provider = (SaslClientAuthenticationProvider)pair.getFirst();
        this.token = (Token)pair.getSecond();
        LOG.debug("Using {} authentication for service={}, sasl={}", new Object[]{this.provider.getSaslAuthMethod().getName(), remoteId.serviceName, this.useSasl});
        this.reloginMaxBackoff = conf.getInt("hbase.security.relogin.maxbackoff", 5000);
        this.remoteId = remoteId;
    }

    protected final void scheduleTimeoutTask(final Call call) {
        if (call.timeout > 0) {
            call.timeoutTask = this.timeoutTimer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    call.setTimeout((IOException)((Object)new CallTimeoutException(call.toShortString() + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + "ms, rpcTimeout=" + call.timeout + "ms")));
                    RpcConnection.this.callTimeout(call);
                }
            }, (long)call.timeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getConnectionHeaderPreamble() {
        int rpcHeaderLen = HConstants.RPC_HEADER.length;
        byte[] preamble = new byte[rpcHeaderLen + 2];
        System.arraycopy(HConstants.RPC_HEADER, 0, preamble, 0, rpcHeaderLen);
        preamble[rpcHeaderLen] = 0;
        RpcConnection rpcConnection = this;
        synchronized (rpcConnection) {
            preamble[rpcHeaderLen + 1] = this.provider.getSaslAuthMethod().getCode();
        }
        return preamble;
    }

    protected final RPCProtos.ConnectionHeader getConnectionHeader() {
        RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
        builder.setServiceName(this.remoteId.getServiceName());
        RPCProtos.UserInformation userInfoPB = this.provider.getUserInfo(this.remoteId.ticket);
        if (userInfoPB != null) {
            builder.setUserInfo(userInfoPB);
        }
        if (this.codec != null) {
            builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
        }
        if (this.compressor != null) {
            builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
        }
        builder.setVersionInfo(ProtobufUtil.getVersionInfo());
        boolean isCryptoAESEnable = this.conf.getBoolean(CRYPTO_AES_ENABLED_KEY, CRYPTO_AES_ENABLED_DEFAULT);
        if (isCryptoAESEnable) {
            builder.setRpcCryptoCipherTransformation(this.conf.get("hbase.rpc.crypto.encryption.aes.cipher.transform", "AES/CTR/NoPadding"));
        }
        return builder.build();
    }

    protected final InetSocketAddress getRemoteInetAddress(MetricsConnection metrics) throws UnknownHostException {
        InetSocketAddress remoteAddr;
        if (metrics != null) {
            metrics.incrNsLookups();
        }
        if ((remoteAddr = Address.toSocketAddress((Address)this.remoteId.getAddress())).isUnresolved()) {
            if (metrics != null) {
                metrics.incrNsLookupsFailed();
            }
            throw new UnknownHostException(this.remoteId.getAddress() + " could not be resolved");
        }
        return remoteAddr;
    }

    protected abstract void callTimeout(Call var1);

    public ConnectionId remoteId() {
        return this.remoteId;
    }

    public long getLastTouched() {
        return this.lastTouched;
    }

    public void setLastTouched(long lastTouched) {
        this.lastTouched = lastTouched;
    }

    public abstract boolean isActive();

    public abstract void shutdown();

    public abstract void sendRequest(Call var1, HBaseRpcController var2) throws IOException;

    public abstract void cleanupConnection();
}

