/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface TableDescriptor {
    @InterfaceAudience.Private
    public static final Comparator<TableDescriptor> COMPARATOR = (lhs, rhs) -> {
        int result = lhs.getTableName().compareTo(rhs.getTableName());
        if (result != 0) {
            return result;
        }
        List<ColumnFamilyDescriptor> lhsFamilies = Arrays.asList(lhs.getColumnFamilies());
        List<ColumnFamilyDescriptor> rhsFamilies = Arrays.asList(rhs.getColumnFamilies());
        result = Integer.compare(lhsFamilies.size(), rhsFamilies.size());
        if (result != 0) {
            return result;
        }
        Iterator it = lhsFamilies.iterator();
        Iterator it2 = rhsFamilies.iterator();
        while (it.hasNext()) {
            result = ColumnFamilyDescriptor.COMPARATOR.compare((ColumnFamilyDescriptor)it.next(), (ColumnFamilyDescriptor)it2.next());
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(lhs.getValues().hashCode(), rhs.getValues().hashCode());
    };

    public int getColumnFamilyCount();

    public Collection<String> getCoprocessors();

    public Durability getDurability();

    public ColumnFamilyDescriptor[] getColumnFamilies();

    public Set<byte[]> getColumnFamilyNames();

    public ColumnFamilyDescriptor getColumnFamily(byte[] var1);

    public String getFlushPolicyClassName();

    public long getMaxFileSize();

    public long getMemStoreFlushSize();

    public int getPriority();

    public int getRegionReplication();

    public String getRegionSplitPolicyClassName();

    public TableName getTableName();

    @Deprecated
    public String getOwnerString();

    public Bytes getValue(Bytes var1);

    public byte[] getValue(byte[] var1);

    public String getValue(String var1);

    public Map<Bytes, Bytes> getValues();

    public boolean hasCoprocessor(String var1);

    public boolean hasColumnFamily(byte[] var1);

    public boolean hasRegionMemStoreReplication();

    public boolean hasSerialReplicationScope();

    public boolean isCompactionEnabled();

    public boolean isMetaRegion();

    public boolean isMetaTable();

    public boolean isNormalizationEnabled();

    public boolean isReadOnly();
}

