/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FuzzyRowFilter
extends FilterBase {
    private static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;
    private int lastFoundIndex = -1;
    private RowTracker tracker;

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        for (int i = 0; i < fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> p = fuzzyKeysData.get(i);
            if (((byte[])p.getFirst()).length != ((byte[])p.getSecond()).length) {
                Pair readable = new Pair((Object)Bytes.toStringBinary((byte[])((byte[])p.getFirst())), (Object)Bytes.toStringBinary((byte[])((byte[])p.getSecond())));
                throw new IllegalArgumentException("Fuzzy pair lengths do not match: " + readable);
            }
            p.setSecond((Object)this.preprocessMask((byte[])p.getSecond()));
            this.preprocessSearchKey(p);
        }
        this.fuzzyKeysData = fuzzyKeysData;
        this.tracker = new RowTracker();
    }

    private void preprocessSearchKey(Pair<byte[], byte[]> p) {
        if (!UNSAFE_UNALIGNED) {
            return;
        }
        byte[] key = (byte[])p.getFirst();
        byte[] mask = (byte[])p.getSecond();
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] != 0) continue;
            key[i] = 0;
        }
    }

    private byte[] preprocessMask(byte[] mask) {
        if (!UNSAFE_UNALIGNED) {
            return mask;
        }
        if (this.isPreprocessedMask(mask)) {
            return mask;
        }
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == 0) {
                mask[i] = -1;
                continue;
            }
            if (mask[i] != 1) continue;
            mask[i] = 0;
        }
        return mask;
    }

    private boolean isPreprocessedMask(byte[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1 || mask[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell c) {
        int startIndex = this.lastFoundIndex >= 0 ? this.lastFoundIndex : 0;
        int size = this.fuzzyKeysData.size();
        for (int i = startIndex; i < size + startIndex; ++i) {
            int index = i % size;
            Pair<byte[], byte[]> fuzzyData = this.fuzzyKeysData.get(index);
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(this.isReversed(), c.getRowArray(), c.getRowOffset(), c.getRowLength(), (byte[])fuzzyData.getFirst(), (byte[])fuzzyData.getSecond());
            if (satisfiesCode != SatisfiesCode.YES) continue;
            this.lastFoundIndex = index;
            return Filter.ReturnCode.INCLUDE;
        }
        this.lastFoundIndex = -1;
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) {
        boolean result = this.tracker.updateTracker(currentCell);
        if (!result) {
            this.done = true;
            return null;
        }
        byte[] nextRowKey = this.tracker.nextRow();
        return KeyValueUtil.createFirstOnRow((byte[])nextRowKey);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FuzzyRowFilter.Builder builder = FilterProtos.FuzzyRowFilter.newBuilder();
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(ByteStringer.wrap((byte[])((byte[])fuzzyData.getFirst())));
            bbpBuilder.setSecond(ByteStringer.wrap((byte[])((byte[])fuzzyData.getSecond())));
            builder.addFuzzyKeysData(bbpBuilder);
        }
        return builder.build().toByteArray();
    }

    public static FuzzyRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FuzzyRowFilter proto;
        try {
            proto = FilterProtos.FuzzyRowFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int count = proto.getFuzzyKeysDataCount();
        ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
            byte[] keyBytes = current.getFirst().toByteArray();
            byte[] keyMeta = current.getSecond().toByteArray();
            fuzzyKeysData.add((Pair<byte[], byte[]>)new Pair((Object)keyBytes, (Object)keyMeta));
        }
        return new FuzzyRowFilter(fuzzyKeysData);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary((byte[])((byte[])fuzzyData.getFirst()))).append(":");
            sb.append(Bytes.toStringBinary((byte[])((byte[])fuzzyData.getSecond()))).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    @VisibleForTesting
    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @VisibleForTesting
    static SatisfiesCode satisfies(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    static SatisfiesCode satisfies(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int fuzzyBytes;
        int rowValue;
        int fuzzyMeta;
        if (!UNSAFE_UNALIGNED) {
            return FuzzyRowFilter.satisfiesNoUnsafe(reverse, row, offset, length, fuzzyKeyBytes, fuzzyKeyMeta);
        }
        if (row == null) {
            return SatisfiesCode.YES;
        }
        length = Math.min(length, fuzzyKeyBytes.length);
        int numWords = length / 8;
        int offsetAdj = offset + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
        int j = numWords << 3;
        for (int i = 0; i < j; i += 8) {
            long fuzzyBytes2 = UnsafeAccess.theUnsafe.getLong(fuzzyKeyBytes, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)i);
            long fuzzyMeta2 = UnsafeAccess.theUnsafe.getLong(fuzzyKeyMeta, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)i);
            long rowValue2 = UnsafeAccess.theUnsafe.getLong(row, (long)offsetAdj + (long)i);
            if ((rowValue2 & fuzzyMeta2) == fuzzyBytes2) continue;
            return SatisfiesCode.NEXT_EXISTS;
        }
        int off = j;
        if (length - off >= 4) {
            int fuzzyBytes3 = UnsafeAccess.theUnsafe.getInt(fuzzyKeyBytes, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)off);
            fuzzyMeta = UnsafeAccess.theUnsafe.getInt(fuzzyKeyMeta, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)off);
            int rowValue3 = UnsafeAccess.theUnsafe.getInt(row, (long)offsetAdj + (long)off);
            if ((rowValue3 & fuzzyMeta) != fuzzyBytes3) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 4;
        }
        if (length - off >= 2) {
            short fuzzyBytes4 = UnsafeAccess.theUnsafe.getShort(fuzzyKeyBytes, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)off);
            fuzzyMeta = UnsafeAccess.theUnsafe.getShort(fuzzyKeyMeta, (long)UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)off);
            short rowValue4 = UnsafeAccess.theUnsafe.getShort(row, (long)offsetAdj + (long)off);
            if ((rowValue4 & fuzzyMeta) != fuzzyBytes4) {
                return SatisfiesCode.NEXT_EXISTS;
            }
            off += 2;
        }
        if (length - off >= 1 && ((rowValue = row[offset + off] & 0xFF) & (fuzzyMeta = fuzzyKeyMeta[off] & 0xFF)) != (fuzzyBytes = fuzzyKeyBytes[off] & 0xFF)) {
            return SatisfiesCode.NEXT_EXISTS;
        }
        return SatisfiesCode.YES;
    }

    static SatisfiesCode satisfiesNoUnsafe(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        Order order = Order.orderFor(reverse);
        boolean nextRowKeyCandidateExists = false;
        for (int i = 0; i < fuzzyKeyMeta.length && i < length; ++i) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i] != row[i + offset];
            if (fixedByteIncorrect) {
                boolean rowByteLessThanFixed;
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean bl2 = rowByteLessThanFixed = (row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF);
                if (rowByteLessThanFixed && !reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                if (!rowByteLessThanFixed && reverse) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                return SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i] != 1 || order.isMax(fuzzyKeyBytes[i])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    @VisibleForTesting
    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(false, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @VisibleForTesting
    static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(reverse, row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    @VisibleForTesting
    static byte[] getNextForFuzzyRule(boolean reverse, byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i;
        byte[] result = Arrays.copyOf(fuzzyKeyBytes, length > fuzzyKeyBytes.length ? length : fuzzyKeyBytes.length);
        if (reverse && length > fuzzyKeyBytes.length) {
            for (int i2 = fuzzyKeyBytes.length; i2 < result.length; ++i2) {
                result[i2] = -1;
            }
        }
        int toInc = -1;
        Order order = Order.orderFor(reverse);
        boolean increased = false;
        for (i = 0; i < result.length; ++i) {
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] == 0) {
                result[i] = row[offset + i];
                if (order.isMax(row[offset + i])) continue;
                toInc = i;
                continue;
            }
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] != -1) continue;
            if (order.lt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) {
                increased = true;
                break;
            }
            if (order.gt(row[i + offset] & 0xFF, fuzzyKeyBytes[i] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            result[toInc] = order.inc(result[toInc]);
            for (i = toInc + 1; i < result.length; ++i) {
                if (i < fuzzyKeyMeta.length && fuzzyKeyMeta[i] != 0) continue;
                result[i] = order.min();
            }
        }
        return reverse ? result : FuzzyRowFilter.trimTrailingZeroes(result, fuzzyKeyMeta, toInc);
    }

    private static byte[] trimTrailingZeroes(byte[] result, byte[] fuzzyKeyMeta, int toInc) {
        int off;
        int n = off = fuzzyKeyMeta.length >= result.length ? result.length - 1 : fuzzyKeyMeta.length - 1;
        while (off >= 0 && fuzzyKeyMeta[off] == 0) {
            --off;
        }
        if (off < toInc) {
            off = toInc;
        }
        byte[] retValue = new byte[off + 1];
        System.arraycopy(result, 0, retValue, 0, retValue.length);
        return retValue;
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzyRowFilter)) {
            return false;
        }
        FuzzyRowFilter other = (FuzzyRowFilter)o;
        if (this.fuzzyKeysData.size() != other.fuzzyKeysData.size()) {
            return false;
        }
        for (int i = 0; i < this.fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> thisData = this.fuzzyKeysData.get(i);
            Pair<byte[], byte[]> otherData = other.fuzzyKeysData.get(i);
            if (Bytes.equals((byte[])((byte[])thisData.getFirst()), (byte[])((byte[])otherData.getFirst())) && Bytes.equals((byte[])((byte[])thisData.getSecond()), (byte[])((byte[])otherData.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private static enum Order {
        ASC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val + 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == -1;
            }

            @Override
            public byte min() {
                return 0;
            }
        }
        ,
        DESC{

            @Override
            public boolean lt(int lhs, int rhs) {
                return lhs > rhs;
            }

            @Override
            public boolean gt(int lhs, int rhs) {
                return lhs < rhs;
            }

            @Override
            public byte inc(byte val) {
                return (byte)(val - 1);
            }

            @Override
            public boolean isMax(byte val) {
                return val == 0;
            }

            @Override
            public byte min() {
                return -1;
            }
        };


        public static Order orderFor(boolean reverse) {
            return reverse ? DESC : ASC;
        }

        public abstract boolean lt(int var1, int var2);

        public abstract boolean gt(int var1, int var2);

        public abstract byte inc(byte var1);

        public abstract boolean isMax(byte var1);

        public abstract byte min();
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }

    private class RowTracker {
        private final PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>> nextRows;
        private boolean initialized = false;

        RowTracker() {
            this.nextRows = new PriorityQueue<Pair<byte[], Pair<byte[], byte[]>>>(FuzzyRowFilter.this.fuzzyKeysData.size(), new Comparator<Pair<byte[], Pair<byte[], byte[]>>>(){

                @Override
                public int compare(Pair<byte[], Pair<byte[], byte[]>> o1, Pair<byte[], Pair<byte[], byte[]>> o2) {
                    return FuzzyRowFilter.this.isReversed() ? Bytes.compareTo((byte[])((byte[])o2.getFirst()), (byte[])((byte[])o1.getFirst())) : Bytes.compareTo((byte[])((byte[])o1.getFirst()), (byte[])((byte[])o2.getFirst()));
                }
            });
        }

        byte[] nextRow() {
            if (this.nextRows.isEmpty()) {
                throw new IllegalStateException("NextRows should not be empty, make sure to call nextRow() after updateTracker() return true");
            }
            return (byte[])this.nextRows.peek().getFirst();
        }

        boolean updateTracker(Cell currentCell) {
            if (!this.initialized) {
                for (Pair fuzzyData : FuzzyRowFilter.this.fuzzyKeysData) {
                    this.updateWith(currentCell, (Pair<byte[], byte[]>)fuzzyData);
                }
                this.initialized = true;
            } else {
                while (!this.nextRows.isEmpty() && !this.lessThan(currentCell, (byte[])this.nextRows.peek().getFirst())) {
                    Pair<byte[], Pair<byte[], byte[]>> head = this.nextRows.poll();
                    Pair fuzzyData = (Pair)head.getSecond();
                    this.updateWith(currentCell, (Pair<byte[], byte[]>)fuzzyData);
                }
            }
            return !this.nextRows.isEmpty();
        }

        boolean lessThan(Cell currentCell, byte[] nextRowKey) {
            int compareResult = Bytes.compareTo((byte[])currentCell.getRowArray(), (int)currentCell.getRowOffset(), (int)currentCell.getRowLength(), (byte[])nextRowKey, (int)0, (int)nextRowKey.length);
            return !FuzzyRowFilter.this.isReversed() && compareResult < 0 || FuzzyRowFilter.this.isReversed() && compareResult > 0;
        }

        void updateWith(Cell currentCell, Pair<byte[], byte[]> fuzzyData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(FuzzyRowFilter.this.isReversed(), currentCell.getRowArray(), currentCell.getRowOffset(), currentCell.getRowLength(), (byte[])fuzzyData.getFirst(), (byte[])fuzzyData.getSecond());
            if (nextRowKeyCandidate != null) {
                this.nextRows.add((Pair<byte[], Pair<byte[], byte[]>>)new Pair((Object)nextRowKeyCandidate, fuzzyData));
            }
        }
    }
}

