/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClientSmallReversedScanner;
import org.apache.hadoop.hbase.client.ClientSmallScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RegionCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HTable
implements HTableInterface,
RegionLocator {
    private static final Log LOG = LogFactory.getLog(HTable.class);
    protected ClusterConnection connection;
    private final TableName tableName;
    private volatile Configuration configuration;
    private ConnectionConfiguration connConfiguration;
    protected BufferedMutatorImpl mutator;
    private boolean autoFlush = true;
    private boolean closed = false;
    protected int scannerCaching;
    protected long scannerMaxResultSize;
    private ExecutorService pool;
    private int operationTimeout;
    private int rpcTimeout;
    private final boolean cleanupPoolOnClose;
    private final boolean cleanupConnectionOnClose;
    private Consistency defaultConsistency = Consistency.STRONG;
    private HRegionLocator locator;
    protected AsyncProcess multiAp;
    private RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcControllerFactory;

    @Deprecated
    public HTable(Configuration conf, String tableName) throws IOException {
        this(conf, TableName.valueOf((String)tableName));
    }

    @Deprecated
    public HTable(Configuration conf, byte[] tableName) throws IOException {
        this(conf, TableName.valueOf((byte[])tableName));
    }

    @Deprecated
    public HTable(Configuration conf, TableName tableName) throws IOException {
        this.tableName = tableName;
        this.cleanupConnectionOnClose = true;
        this.cleanupPoolOnClose = true;
        if (conf == null) {
            this.connection = null;
            return;
        }
        this.connection = ConnectionManager.getConnectionInternal(conf);
        this.configuration = conf;
        this.pool = HTable.getDefaultExecutor(conf);
        this.finishSetup();
    }

    @Deprecated
    public HTable(TableName tableName, Connection connection) throws IOException {
        this.tableName = tableName;
        this.cleanupPoolOnClose = true;
        this.cleanupConnectionOnClose = false;
        this.connection = (ClusterConnection)connection;
        this.configuration = connection.getConfiguration();
        this.pool = HTable.getDefaultExecutor(this.configuration);
        this.finishSetup();
    }

    @InterfaceAudience.Private
    public static ThreadPoolExecutor getDefaultExecutor(Configuration conf) {
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"htable"));
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    @Deprecated
    public HTable(Configuration conf, byte[] tableName, ExecutorService pool) throws IOException {
        this(conf, TableName.valueOf((byte[])tableName), pool);
    }

    @Deprecated
    public HTable(Configuration conf, TableName tableName, ExecutorService pool) throws IOException {
        this.connection = ConnectionManager.getConnectionInternal(conf);
        this.configuration = conf;
        this.pool = pool;
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(conf);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = true;
        this.finishSetup();
    }

    @Deprecated
    public HTable(byte[] tableName, Connection connection, ExecutorService pool) throws IOException {
        this(TableName.valueOf((byte[])tableName), connection, pool);
    }

    @Deprecated
    public HTable(TableName tableName, Connection connection, ExecutorService pool) throws IOException {
        this(tableName, (ClusterConnection)connection, null, null, null, pool);
    }

    @Deprecated
    public HTable(TableName tableName, HConnection connection) throws IOException {
        this.tableName = tableName;
        this.cleanupPoolOnClose = true;
        this.cleanupConnectionOnClose = false;
        this.connection = (ClusterConnection)connection;
        this.configuration = connection.getConfiguration();
        this.pool = HTable.getDefaultExecutor(this.configuration);
        this.finishSetup();
    }

    @Deprecated
    public HTable(byte[] tableName, HConnection connection, ExecutorService pool) throws IOException {
        this(TableName.valueOf((byte[])tableName), connection, pool);
    }

    @Deprecated
    public HTable(TableName tableName, HConnection connection, ExecutorService pool) throws IOException {
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = false;
        this.cleanupPoolOnClose = false;
        this.connection = (ClusterConnection)connection;
        this.configuration = connection.getConfiguration();
        this.pool = pool;
        this.finishSetup();
    }

    @InterfaceAudience.Private
    public HTable(TableName tableName, ClusterConnection connection, ConnectionConfiguration tableConfig, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool) throws IOException {
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = false;
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.connConfiguration = tableConfig;
        this.pool = pool;
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(this.configuration);
            this.cleanupPoolOnClose = true;
        } else {
            this.cleanupPoolOnClose = false;
        }
        this.rpcCallerFactory = rpcCallerFactory;
        this.rpcControllerFactory = rpcControllerFactory;
        this.finishSetup();
    }

    @VisibleForTesting
    protected HTable(ClusterConnection conn, BufferedMutatorParams params) throws IOException {
        this.connection = conn;
        this.tableName = params.getTableName();
        this.connConfiguration = new ConnectionConfiguration(this.connection.getConfiguration());
        this.cleanupPoolOnClose = false;
        this.cleanupConnectionOnClose = false;
        this.mutator = new BufferedMutatorImpl(conn, null, null, params);
    }

    public static int getMaxKeyValueSize(Configuration conf) {
        return conf.getInt("hbase.client.keyvalue.maxsize", -1);
    }

    private void finishSetup() throws IOException {
        if (this.connConfiguration == null) {
            this.connConfiguration = new ConnectionConfiguration(this.configuration);
        }
        this.operationTimeout = this.tableName.isSystemTable() ? this.connConfiguration.getMetaOperationTimeout() : this.connConfiguration.getOperationTimeout();
        this.rpcTimeout = this.configuration.getInt("hbase.rpc.timeout", 60000);
        this.scannerCaching = this.connConfiguration.getScannerCaching();
        this.scannerMaxResultSize = this.connConfiguration.getScannerMaxResultSize();
        if (this.rpcCallerFactory == null) {
            this.rpcCallerFactory = this.connection.getNewRpcRetryingCallerFactory(this.configuration);
        }
        if (this.rpcControllerFactory == null) {
            this.rpcControllerFactory = RpcControllerFactory.instantiate(this.configuration);
        }
        this.multiAp = this.connection.getAsyncProcess();
        this.closed = false;
        this.locator = new HRegionLocator(this.tableName, this.connection);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public static boolean isTableEnabled(String tableName) throws IOException {
        return HTable.isTableEnabled(TableName.valueOf((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(byte[] tableName) throws IOException {
        return HTable.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(TableName tableName) throws IOException {
        return HTable.isTableEnabled(HBaseConfiguration.create(), tableName);
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, String tableName) throws IOException {
        return HTable.isTableEnabled(conf, TableName.valueOf((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, byte[] tableName) throws IOException {
        return HTable.isTableEnabled(conf, TableName.valueOf((byte[])tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, final TableName tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.isTableEnabled(tableName);
            }
        });
    }

    @Deprecated
    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.getRegionLocation(Bytes.toBytes((String)row), false);
    }

    @Override
    @Deprecated
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.locator.getRegionLocation(row);
    }

    @Override
    @Deprecated
    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.locator.getRegionLocation(row, reload);
    }

    @Override
    public byte[] getTableName() {
        return this.tableName.getName();
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Deprecated
    @VisibleForTesting
    public HConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    public int getScannerCaching() {
        return this.scannerCaching;
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        return this.mutator == null ? null : this.mutator.getWriteBuffer();
    }

    @Deprecated
    public void setScannerCaching(int scannerCaching) {
        this.scannerCaching = scannerCaching;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        HTableDescriptor htd = HBaseAdmin.getTableDescriptor(this.tableName, this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.rpcTimeout);
        if (htd != null) {
            return new UnmodifyableHTableDescriptor(htd);
        }
        return null;
    }

    @Override
    @Deprecated
    public byte[][] getStartKeys() throws IOException {
        return this.locator.getStartKeys();
    }

    @Override
    @Deprecated
    public byte[][] getEndKeys() throws IOException {
        return this.locator.getEndKeys();
    }

    @Override
    @Deprecated
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.locator.getStartEndKeys();
    }

    @Deprecated
    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return MetaScanner.allTableRegions(this.connection, this.getName());
    }

    @Override
    @Deprecated
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.locator.getAllRegionLocations();
    }

    @Deprecated
    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        return this.getRegionsInRange(startKey, endKey, false);
    }

    @Deprecated
    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        return (List)this.getKeysAndRegionsInRange(startKey, endKey, false, reload).getSecond();
    }

    @Deprecated
    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey) throws IOException {
        return this.getKeysAndRegionsInRange(startKey, endKey, includeEndKey, false);
    }

    @Deprecated
    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, reload);
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    @Override
    @Deprecated
    public Result getRowOrBefore(byte[] row, final byte[] family) throws IOException {
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((Connection)this.connection, this.tableName, row){

            @Override
            public Result call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                ClientProtos.GetRequest request = RequestConverter.buildGetRowOrBeforeRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family);
                try {
                    ClientProtos.GetResponse response = this.getStub().get((RpcController)controller, request);
                    if (!response.hasResult()) {
                        return null;
                    }
                    return ProtobufUtil.toResult(response.getResult());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        if (scan.getBatch() > 0 && scan.isSmall()) {
            throw new IllegalArgumentException("Small scan should not be used with batching");
        }
        if (scan.getCaching() <= 0) {
            scan.setCaching(this.getScannerCaching());
        }
        if (scan.getMaxResultSize() <= 0L) {
            scan.setMaxResultSize(this.scannerMaxResultSize);
        }
        if (scan.isReversed()) {
            if (scan.isSmall()) {
                return new ClientSmallReversedScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
            }
            return new ReversedClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
        }
        if (scan.isSmall()) {
            return new ClientSmallScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
        }
        return new ClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(Get get) throws IOException {
        return this.get(get, get.isCheckExistenceOnly());
    }

    private Result get(Get get, boolean checkExistenceOnly) throws IOException {
        if (get.isCheckExistenceOnly() != checkExistenceOnly || get.getConsistency() == null) {
            get = (Get)ReflectionUtils.newInstance(get.getClass(), (Object[])new Object[]{get});
            get.setCheckExistenceOnly(checkExistenceOnly);
            if (get.getConsistency() == null) {
                get.setConsistency(this.defaultConsistency);
            }
        }
        if (get.getConsistency() == Consistency.STRONG) {
            final Get getReq = get;
            RegionServerCallable<Result> callable = new RegionServerCallable<Result>((Connection)this.connection, this.getName(), get.getRow()){

                @Override
                public Result call(int callTimeout) throws IOException {
                    ClientProtos.GetRequest request = RequestConverter.buildGetRequest(this.getLocation().getRegionInfo().getRegionName(), getReq);
                    PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                    controller.setPriority(this.tableName);
                    controller.setCallTimeout(callTimeout);
                    try {
                        ClientProtos.GetResponse response = this.getStub().get((RpcController)controller, request);
                        if (response == null) {
                            return null;
                        }
                        return ProtobufUtil.toResult(response.getResult());
                    }
                    catch (ServiceException se) {
                        throw ProtobufUtil.getRemoteException(se);
                    }
                }
            };
            return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
        }
        RpcRetryingCallerWithReadReplicas callable = new RpcRetryingCallerWithReadReplicas(this.rpcControllerFactory, this.tableName, this.connection, get, this.pool, this.connConfiguration.getRetriesNumber(), this.operationTimeout, this.connConfiguration.getPrimaryCallTimeoutMicroSecond());
        return callable.call(this.operationTimeout);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() == 1) {
            return new Result[]{this.get(gets.get(0))};
        }
        try {
            Object[] r1 = this.batch(gets);
            Result[] results = new Result[r1.length];
            int i = 0;
            for (Object o : r1) {
                results[i++] = (Result)o;
            }
            return results;
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        AsyncProcess.AsyncRequestFuture ars = this.multiAp.submitAll(this.pool, this.tableName, actions, null, results);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    @Deprecated
    public Object[] batch(List<? extends Row> actions) throws InterruptedException, IOException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, callback);
    }

    @Override
    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batchCallback(actions, results, callback);
        return results;
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.tableName, delete.getRow()){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), delete);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.batch(deletes, results);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(Put put) throws IOException {
        this.getBufferedMutator().mutate(put);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        this.getBufferedMutator().mutate(puts);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    @Override
    public void mutateRow(final RowMutations rm) throws IOException {
        RegionServerCallable<Void> callable = new RegionServerCallable<Void>((Connection)this.connection, this.getName(), rm.getRow()){

            @Override
            public Void call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.RegionAction.Builder regionMutationBuilder = RequestConverter.buildRegionAction(this.getLocation().getRegionInfo().getRegionName(), rm);
                    regionMutationBuilder.setAtomic(true);
                    ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(regionMutationBuilder.build()).build();
                    ClientProtos.MultiResponse response = this.getStub().multi((RpcController)controller, request);
                    ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                    if (res.hasException()) {
                        Throwable ex = ProtobufUtil.toException(res.getException());
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new IOException("Failed to mutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                    }
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                return null;
            }
        };
        this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public Result append(final Append append) throws IOException {
        if (append.numFamilies() == 0) {
            throw new IOException("Invalid arguments to append, no columns specified");
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((Connection)this.connection, this.getName(), append.getRow()){

            @Override
            public Result call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.getTableName());
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), append, nonceGroup, nonce);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    if (!response.hasResult()) {
                        return null;
                    }
                    return ProtobufUtil.toResult(response.getResult(), controller.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Result> callable = new RegionServerCallable<Result>((Connection)this.connection, this.getName(), increment.getRow()){

            @Override
            public Result call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.getTableName());
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), increment, nonceGroup, nonce);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return ProtobufUtil.toResult(response.getResult(), controller.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    @Override
    @Deprecated
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
    }

    @Override
    public long incrementColumnValue(byte[] row, final byte[] family, final byte[] qualifier, final long amount, final Durability durability) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("family is null");
        } else if (qualifier == null) {
            npe = new NullPointerException("qualifier is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        NonceGenerator ng = this.connection.getNonceGenerator();
        final long nonceGroup = ng.getNonceGroup();
        final long nonce = ng.newNonce();
        RegionServerCallable<Long> callable = new RegionServerCallable<Long>((Connection)this.connection, this.getName(), row){

            @Override
            public Long call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.getTableName());
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildIncrementRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, amount, durability, nonceGroup, nonce);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    Result result = ProtobufUtil.toResult(response.getResult(), controller.cellScanner());
                    return Bytes.toLong((byte[])result.getValue(family, qualifier));
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.getName(), row){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, put);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final Put put) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.getName(), row){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = new PayloadCarryingRpcController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, put);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndDelete(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Delete delete) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.getName(), row){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, delete);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndDelete(byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final Delete delete) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.getName(), row){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, delete);
                    ClientProtos.MutateResponse response = this.getStub().mutate((RpcController)controller, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller(this.rpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndMutate(byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final RowMutations rm) throws IOException {
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>((Connection)this.connection, this.getName(), row){

            @Override
            public Boolean call(int callTimeout) throws IOException {
                PayloadCarryingRpcController controller = HTable.this.rpcControllerFactory.newController();
                controller.setPriority(this.tableName);
                controller.setCallTimeout(callTimeout);
                try {
                    HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                    ClientProtos.MultiRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, rm);
                    ClientProtos.MultiResponse response = this.getStub().multi((RpcController)controller, request);
                    ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                    if (res.hasException()) {
                        Throwable ex = ProtobufUtil.toException(res.getException());
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new IOException("Failed to checkAndMutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                    }
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean exists(Get get) throws IOException {
        Result r = this.get(get, true);
        assert (r.getExists() != null);
        return r.getExists();
    }

    @Override
    public boolean[] existsAll(List<Get> gets) throws IOException {
        Object[] r1;
        if (gets.isEmpty()) {
            return new boolean[0];
        }
        if (gets.size() == 1) {
            return new boolean[]{this.exists(gets.get(0))};
        }
        ArrayList<Get> exists = new ArrayList<Get>(gets.size());
        for (Get g : gets) {
            Get ge = new Get(g);
            ge.setCheckExistenceOnly(true);
            exists.add(ge);
        }
        try {
            r1 = this.batch(exists);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        boolean[] results = new boolean[r1.length];
        int i = 0;
        for (Object o : r1) {
            results[i++] = ((Result)o).getExists();
        }
        return results;
    }

    @Override
    @Deprecated
    public Boolean[] exists(List<Get> gets) throws IOException {
        boolean[] results = this.existsAll(gets);
        Boolean[] objectResults = new Boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            objectResults[i] = results[i];
        }
        return objectResults;
    }

    @Override
    public void flushCommits() throws IOException {
        if (this.mutator == null) {
            return;
        }
        this.getBufferedMutator().flush();
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(list, results, callback);
    }

    public void processBatch(List<? extends Row> list, Object[] results) throws IOException, InterruptedException {
        this.batch(list, results);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flushCommits();
        if (this.cleanupPoolOnClose) {
            this.pool.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                this.pool.shutdownNow();
                LOG.warn((Object)"waitForTermination interrupted");
            }
        }
        if (this.cleanupConnectionOnClose && this.connection != null) {
            this.connection.close();
        }
        this.closed = true;
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.connConfiguration.getMaxKeyValueSize());
    }

    public static void validatePut(Put put, int maxKeyValueSize) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (maxKeyValueSize > 0) {
            for (List list : put.getFamilyCellMap().values()) {
                for (Cell cell : list) {
                    if (KeyValueUtil.length((Cell)cell) <= maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    @Override
    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    @Override
    @Deprecated
    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    @Override
    public void setAutoFlushTo(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    @Override
    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
    }

    @Override
    public long getWriteBufferSize() {
        if (this.mutator == null) {
            return this.connConfiguration.getWriteBufferSize();
        }
        return this.mutator.getWriteBufferSize();
    }

    @Override
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.getBufferedMutator();
        this.mutator.setWriteBufferSize(writeBufferSize);
    }

    ExecutorService getPool() {
        return this.pool;
    }

    @Deprecated
    public static void setRegionCachePrefetch(byte[] tableName, boolean enable) throws IOException {
    }

    @Deprecated
    public static void setRegionCachePrefetch(TableName tableName, boolean enable) throws IOException {
    }

    @Deprecated
    public static void setRegionCachePrefetch(Configuration conf, byte[] tableName, boolean enable) throws IOException {
    }

    @Deprecated
    public static void setRegionCachePrefetch(Configuration conf, TableName tableName, boolean enable) throws IOException {
    }

    @Deprecated
    public static boolean getRegionCachePrefetch(Configuration conf, byte[] tableName) throws IOException {
        return false;
    }

    @Deprecated
    public static boolean getRegionCachePrefetch(Configuration conf, TableName tableName) throws IOException {
        return false;
    }

    @Deprecated
    public static boolean getRegionCachePrefetch(byte[] tableName) throws IOException {
        return false;
    }

    @Deprecated
    public static boolean getRegionCachePrefetch(TableName tableName) throws IOException {
        return false;
    }

    public void clearRegionCache() {
        this.connection.clearRegionCache();
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.connection, this.tableName, row);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.coprocessorService(service, startKey, endKey, callable, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R value) {
                if (region != null) {
                    results.put(region, value);
                }
            }
        });
        return results;
    }

    @Override
    public <T extends Service, R> void coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (final byte[] byArray : keys) {
            final RegionCoprocessorRpcChannel channel = new RegionCoprocessorRpcChannel(this.connection, this.tableName, byArray);
            Future future = this.pool.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Object instance = ProtobufUtil.newServiceStub(service, channel);
                    Object result = callable.call(instance);
                    byte[] region = channel.getLastRegion();
                    if (callback != null) {
                        callback.update(region, byArray, result);
                    }
                    return result;
                }
            });
            futures.put(byArray, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException ee) {
                LOG.warn((Object)("Error calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))), (Throwable)ee);
                throw ee.getCause();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
            }
        }
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        return (List)this.getKeysAndRegionsInRange(start, end, true).getFirst();
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public String toString() {
        return this.tableName + ";" + this.connection;
    }

    @Override
    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R result) {
                if (region != null) {
                    results.put(region, result);
                }
            }
        });
        return results;
    }

    @Override
    public <R extends Message> void batchCoprocessorService(final Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, final R responsePrototype, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        if (endKey == null) {
            endKey = HConstants.EMPTY_END_ROW;
        }
        Pair<List<byte[]>, List<HRegionLocation>> keysAndRegions = this.getKeysAndRegionsInRange(startKey, endKey, true);
        List keys = (List)keysAndRegions.getFirst();
        List regions = (List)keysAndRegions.getSecond();
        if (keys.isEmpty()) {
            LOG.info((Object)("No regions were selected by key range start=" + Bytes.toStringBinary((byte[])startKey) + ", end=" + Bytes.toStringBinary((byte[])endKey)));
            return;
        }
        ArrayList<RegionCoprocessorServiceExec> execs = new ArrayList<RegionCoprocessorServiceExec>();
        final TreeMap<byte[], RegionCoprocessorServiceExec> execsByRow = new TreeMap<byte[], RegionCoprocessorServiceExec>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < keys.size(); ++i) {
            byte[] rowKey = (byte[])keys.get(i);
            byte[] region = ((HRegionLocation)regions.get(i)).getRegionInfo().getRegionName();
            RegionCoprocessorServiceExec exec = new RegionCoprocessorServiceExec(region, rowKey, methodDescriptor, request);
            execs.add(exec);
            execsByRow.put(rowKey, exec);
        }
        final ArrayList<Throwable> callbackErrorExceptions = new ArrayList<Throwable>();
        final ArrayList<Row> callbackErrorActions = new ArrayList<Row>();
        final ArrayList<String> callbackErrorServers = new ArrayList<String>();
        Object[] results = new Object[execs.size()];
        AsyncProcess asyncProcess = new AsyncProcess(this.connection, this.configuration, this.pool, RpcRetryingCallerFactory.instantiate(this.configuration, this.connection.getStatisticsTracker()), true, RpcControllerFactory.instantiate(this.configuration));
        AsyncProcess.AsyncRequestFuture future = asyncProcess.submitAll(this.tableName, execs, new Batch.Callback<ClientProtos.CoprocessorServiceResult>(){

            @Override
            public void update(byte[] region, byte[] row, ClientProtos.CoprocessorServiceResult serviceResult) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Received result for endpoint " + methodDescriptor.getFullName() + ": region=" + Bytes.toStringBinary((byte[])region) + ", row=" + Bytes.toStringBinary((byte[])row) + ", value=" + serviceResult.getValue().getValue()));
                }
                try {
                    Message.Builder builder = responsePrototype.newBuilderForType();
                    ProtobufUtil.mergeFrom(builder, serviceResult.getValue().getValue());
                    callback.update(region, row, builder.build());
                }
                catch (IOException e) {
                    LOG.error((Object)("Unexpected response type from endpoint " + methodDescriptor.getFullName()), (Throwable)e);
                    callbackErrorExceptions.add(e);
                    callbackErrorActions.add(execsByRow.get(row));
                    callbackErrorServers.add("null");
                }
            }
        }, results);
        future.waitUntilDone();
        if (future.hasError()) {
            throw future.getErrors();
        }
        if (!callbackErrorExceptions.isEmpty()) {
            throw new RetriesExhaustedWithDetailsException(callbackErrorExceptions, callbackErrorActions, callbackErrorServers);
        }
    }

    public RegionLocator getRegionLocator() {
        return this.locator;
    }

    @VisibleForTesting
    BufferedMutator getBufferedMutator() throws IOException {
        if (this.mutator == null) {
            this.mutator = (BufferedMutatorImpl)this.connection.getBufferedMutator(new BufferedMutatorParams(this.tableName).pool(this.pool).writeBufferSize(this.connConfiguration.getWriteBufferSize()).maxKeyValueSize(this.connConfiguration.getMaxKeyValueSize()));
        }
        return this.mutator;
    }
}

