/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;

@InterfaceAudience.Private
public class QuotaStatusCalls {
    public static QuotaProtos.GetSpaceQuotaRegionSizesResponse getMasterRegionSizes(ClusterConnection clusterConn, int timeout) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        RpcRetryingCallerFactory rpcCaller = clusterConn.getRpcRetryingCallerFactory();
        return QuotaStatusCalls.getMasterRegionSizes(clusterConn, rpcController, rpcCaller, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuotaProtos.GetSpaceQuotaRegionSizesResponse getMasterRegionSizes(ClusterConnection conn, final RpcControllerFactory factory, RpcRetryingCallerFactory rpcCaller, int timeout) throws IOException {
        RpcRetryingCaller<QuotaProtos.GetSpaceQuotaRegionSizesResponse> caller = rpcCaller.newCaller();
        try (MasterCallable<QuotaProtos.GetSpaceQuotaRegionSizesResponse> callable = new MasterCallable<QuotaProtos.GetSpaceQuotaRegionSizesResponse>((HConnection)conn){

            @Override
            public QuotaProtos.GetSpaceQuotaRegionSizesResponse call(int callTimeout) throws Exception {
                return this.master.getSpaceQuotaRegionSizes(factory.newController(), RequestConverter.buildGetSpaceQuotaRegionSizesRequest());
            }
        };){
            QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizesResponse = caller.callWithoutRetries(callable, timeout);
            return getSpaceQuotaRegionSizesResponse;
        }
    }

    public static QuotaProtos.GetQuotaStatesResponse getMasterQuotaStates(ClusterConnection clusterConn, int timeout) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        RpcRetryingCallerFactory rpcCaller = clusterConn.getRpcRetryingCallerFactory();
        return QuotaStatusCalls.getMasterQuotaStates(clusterConn, rpcController, rpcCaller, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuotaProtos.GetQuotaStatesResponse getMasterQuotaStates(ClusterConnection conn, final RpcControllerFactory factory, RpcRetryingCallerFactory rpcCaller, int timeout) throws IOException {
        RpcRetryingCaller<QuotaProtos.GetQuotaStatesResponse> caller = rpcCaller.newCaller();
        try (MasterCallable<QuotaProtos.GetQuotaStatesResponse> callable = new MasterCallable<QuotaProtos.GetQuotaStatesResponse>((HConnection)conn){

            @Override
            public QuotaProtos.GetQuotaStatesResponse call(int callTimeout) throws Exception {
                return this.master.getQuotaStates(factory.newController(), RequestConverter.buildGetQuotaStatesRequest());
            }
        };){
            QuotaProtos.GetQuotaStatesResponse getQuotaStatesResponse = caller.callWithoutRetries(callable, timeout);
            return getQuotaStatesResponse;
        }
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsResponse getRegionServerQuotaSnapshot(ClusterConnection clusterConn, int timeout, ServerName sn) throws IOException {
        RpcControllerFactory rpcController = clusterConn.getRpcControllerFactory();
        return QuotaStatusCalls.getRegionServerQuotaSnapshot(clusterConn, rpcController, timeout, sn);
    }

    public static QuotaProtos.GetSpaceQuotaSnapshotsResponse getRegionServerQuotaSnapshot(ClusterConnection conn, RpcControllerFactory factory, int timeout, ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = conn.getAdmin(sn);
        try {
            return admin.getSpaceQuotaSnapshots((RpcController)factory.newController(), RequestConverter.buildGetSpaceQuotaSnapshotsRequest());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }
}

