/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupClientUtil {
    protected static final Log LOG = LogFactory.getLog(BackupClientUtil.class);
    public static final String LOGNAME_SEPARATOR = ".";

    private BackupClientUtil() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static boolean checkPathExist(String backupStr, Configuration conf) throws IOException {
        boolean isExist = false;
        Path backupPath = new Path(backupStr);
        FileSystem fileSys = backupPath.getFileSystem(conf);
        String targetFsScheme = fileSys.getUri().getScheme();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Schema of given url: " + backupStr + " is: " + targetFsScheme));
        }
        if (fileSys.exists(backupPath)) {
            isExist = true;
        }
        return isExist;
    }

    public static void checkTargetDir(String backupRootPath, Configuration conf) throws IOException {
        boolean targetExists = false;
        try {
            targetExists = BackupClientUtil.checkPathExist(backupRootPath, conf);
        }
        catch (IOException e) {
            String expMsg = e.getMessage();
            String newMsg = null;
            if (expMsg.contains("No FileSystem for scheme")) {
                newMsg = "Unsupported filesystem scheme found in the backup target url. Error Message: " + newMsg;
                LOG.error((Object)newMsg);
                throw new IOException(newMsg);
            }
            throw e;
        }
        if (targetExists) {
            LOG.info((Object)("Using existing backup root dir: " + backupRootPath));
        } else {
            LOG.info((Object)("Backup root dir " + backupRootPath + " does not exist. Will be created."));
        }
    }

    public static <T> Long getMinValue(HashMap<T, Long> map) {
        Long minTimestamp = null;
        if (map != null) {
            ArrayList<Long> timestampList = new ArrayList<Long>(map.values());
            Collections.sort(timestampList);
            minTimestamp = timestampList.get(0);
        }
        return minTimestamp;
    }

    public static String parseHostFromOldLog(Path p) throws IOException {
        try {
            String n = p.getName();
            int idx = n.lastIndexOf(LOGNAME_SEPARATOR);
            String s = URLDecoder.decode(n.substring(0, idx), "UTF8");
            return ServerName.parseHostname(s) + ":" + ServerName.parsePort(s);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to parse " + p), (Throwable)e);
            return null;
        }
    }

    public static Long getCreationTime(Path p) throws IOException {
        int idx = p.getName().lastIndexOf(LOGNAME_SEPARATOR);
        if (idx < 0) {
            throw new IOException("Cannot parse timestamp from path " + p);
        }
        String ts = p.getName().substring(idx + 1);
        return Long.parseLong(ts);
    }

    public static List<String> getFiles(FileSystem fs, Path rootDir, List<String> files, PathFilter filter) throws FileNotFoundException, IOException {
        RemoteIterator it = fs.listFiles(rootDir, true);
        while (it.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)it.next();
            if (lfs.isDirectory() || !filter.accept(lfs.getPath())) continue;
            files.add(lfs.getPath().toString());
        }
        return files;
    }

    public static void cleanupBackupData(BackupInfo context, Configuration conf) throws IOException {
        BackupClientUtil.cleanupHLogDir(context, conf);
        BackupClientUtil.cleanupTargetDir(context, conf);
    }

    private static void cleanupHLogDir(BackupInfo backupContext, Configuration conf) throws IOException {
        String logDir = backupContext.getHLogTargetDir();
        if (logDir == null) {
            LOG.warn((Object)("No log directory specified for " + backupContext.getBackupId()));
            return;
        }
        Path rootPath = new Path(logDir).getParent();
        FileSystem fs = FileSystem.get((URI)rootPath.toUri(), (Configuration)conf);
        FileStatus[] files = BackupClientUtil.listStatus(fs, rootPath, null);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            LOG.debug((Object)("Delete log files: " + file.getPath().getName()));
            fs.delete(file.getPath(), true);
        }
    }

    private static void cleanupTargetDir(BackupInfo backupContext, Configuration conf) {
        try {
            LOG.debug((Object)("Trying to cleanup up target dir : " + backupContext.getBackupId()));
            String targetDir = backupContext.getTargetRootDir();
            if (targetDir == null) {
                LOG.warn((Object)("No target directory specified for " + backupContext.getBackupId()));
                return;
            }
            FileSystem outputFs = FileSystem.get((URI)new Path(backupContext.getTargetRootDir()).toUri(), (Configuration)conf);
            for (TableName table : backupContext.getTables()) {
                FileStatus[] backups;
                Path tableDir;
                Path targetDirPath = new Path(BackupClientUtil.getTableBackupDir(backupContext.getTargetRootDir(), backupContext.getBackupId(), table));
                if (outputFs.delete(targetDirPath, true)) {
                    LOG.info((Object)("Cleaning up backup data at " + targetDirPath.toString() + " done."));
                } else {
                    LOG.info((Object)("No data has been found in " + targetDirPath.toString() + LOGNAME_SEPARATOR));
                }
                if ((tableDir = targetDirPath.getParent()) == null || (backups = BackupClientUtil.listStatus(outputFs, tableDir, null)) != null && backups.length != 0) continue;
                outputFs.delete(tableDir, true);
                LOG.debug((Object)(tableDir.toString() + " is empty, remove it."));
            }
            outputFs.delete(new Path(targetDir, backupContext.getBackupId()), true);
        }
        catch (IOException e1) {
            LOG.error((Object)("Cleaning up backup data of " + backupContext.getBackupId() + " at " + backupContext.getTargetRootDir() + " failed due to " + e1.getMessage() + LOGNAME_SEPARATOR));
        }
    }

    public static String getTableBackupDir(String backupRootDir, String backupId, TableName tableName) {
        return backupRootDir + "/" + backupId + "/" + tableName.getNamespaceAsString() + "/" + tableName.getQualifierAsString() + "/";
    }

    public static TableName[] parseTableNames(String tables) {
        if (tables == null) {
            return null;
        }
        String[] tableArray = tables.split(",");
        TableName[] ret = new TableName[tableArray.length];
        for (int i = 0; i < tableArray.length; ++i) {
            ret[i] = TableName.valueOf((String)tableArray[i]);
        }
        return ret;
    }

    public static ArrayList<BackupInfo> sortHistoryListDesc(ArrayList<BackupInfo> historyList) {
        ArrayList<BackupInfo> list = new ArrayList<BackupInfo>();
        TreeMap<String, BackupInfo> map = new TreeMap<String, BackupInfo>();
        for (BackupInfo h : historyList) {
            map.put(Long.toString(h.getStartTs()), h);
        }
        Iterator i = map.descendingKeySet().iterator();
        while (i.hasNext()) {
            list.add((BackupInfo)map.get(i.next()));
        }
        return list;
    }

    public static String getUniqueWALFileNamePart(String walFileName) throws IOException {
        return BackupClientUtil.getUniqueWALFileNamePart(new Path(walFileName));
    }

    public static String getUniqueWALFileNamePart(Path p) throws IOException {
        return p.getName();
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir, PathFilter filter) throws IOException {
        FileStatus[] status;
        block3: {
            status = null;
            try {
                status = filter == null ? fs.listStatus(dir) : fs.listStatus(dir, filter);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)(dir + " doesn't exist"));
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        return status;
    }

    public static String getPath(Path p) {
        return p.toUri().getPath();
    }

    public static String getLogBackupDir(String backupRootDir, String backupId) {
        return backupRootDir + "/" + backupId + "/" + "WALs";
    }
}

