/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.backup.RestoreClient;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupRestoreClientFactory {
    private static final Log LOG = LogFactory.getLog(BackupRestoreClientFactory.class);

    private BackupRestoreClientFactory() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static RestoreClient getRestoreClient(Configuration conf) {
        try {
            Class cls = conf.getClassByName("org.apache.hadoop.hbase.backup.impl.RestoreClientImpl");
            RestoreClient client = (RestoreClient)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
            client.setConf(conf);
            return client;
        }
        catch (Exception e) {
            LOG.error((Object)"Can not instantiate RestoreClient. Make sure you have hbase-server jar in CLASSPATH", (Throwable)e);
            return null;
        }
    }
}

