/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.common.base.Stopwatch;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaTableLocator {
    private static final Log LOG = LogFactory.getLog(MetaTableLocator.class);
    static final byte[] META_REGION_NAME = HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
    private volatile boolean stopped = false;

    public boolean isLocationAvailable(ZooKeeperWatcher zkw) {
        return this.getMetaRegionLocation(zkw) != null;
    }

    public List<Pair<HRegionInfo, ServerName>> getMetaRegionsAndLocations(ZooKeeperWatcher zkw) {
        ServerName serverName = new MetaTableLocator().getMetaRegionLocation(zkw);
        ArrayList<Pair<HRegionInfo, ServerName>> list = new ArrayList<Pair<HRegionInfo, ServerName>>();
        list.add(new Pair((Object)HRegionInfo.FIRST_META_REGIONINFO, (Object)serverName));
        return list;
    }

    public List<HRegionInfo> getMetaRegions(ZooKeeperWatcher zkw) {
        List<Pair<HRegionInfo, ServerName>> result = this.getMetaRegionsAndLocations(zkw);
        return this.getListOfHRegionInfos(result);
    }

    private List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add((HRegionInfo)pair.getFirst());
        }
        return result;
    }

    @Nullable
    public ServerName getMetaRegionLocation(ZooKeeperWatcher zkw) {
        try {
            RegionState state = MetaTableLocator.getMetaRegionState(zkw);
            return state.isOpened() ? state.getServerName() : null;
        }
        catch (KeeperException ke) {
            return null;
        }
    }

    public ServerName waitMetaRegionLocation(ZooKeeperWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error((Object)errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("KeeperException while trying to check baseZNode:", e);
        }
        ServerName sn = this.blockUntilAvailable(zkw, timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public void waitMetaRegionLocation(ZooKeeperWatcher zkw) throws InterruptedException {
        Stopwatch stopwatch = new Stopwatch().start();
        while (!this.stopped) {
            try {
                if (this.waitMetaRegionLocation(zkw, 100L) != null) break;
                long sleepTime = stopwatch.elapsedMillis();
                if ((sleepTime + 1L) % 10000L != 0L) continue;
                LOG.warn((Object)("Have been waiting for meta to be assigned for " + sleepTime + "ms"));
            }
            catch (NotAllMetaRegionsOnlineException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("hbase:meta still not available, sleeping and retrying. Reason: " + e.getMessage()));
            }
        }
    }

    public boolean verifyMetaRegionLocation(HConnection hConnection, ZooKeeperWatcher zkw, long timeout) throws InterruptedException, IOException {
        AdminProtos.AdminService.BlockingInterface service = null;
        try {
            service = this.getMetaServerConnection(hConnection, zkw, timeout);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningYetException e) {
        }
        catch (UnknownHostException e) {
        }
        catch (RegionServerStoppedException e) {
            // empty catch block
        }
        return service != null && this.verifyRegionLocation(service, this.getMetaRegionLocation(zkw), META_REGION_NAME);
    }

    private boolean verifyRegionLocation(AdminProtos.AdminService.BlockingInterface hostingServer, ServerName address, byte[] regionName) throws IOException {
        Throwable t;
        if (hostingServer == null) {
            LOG.info((Object)"Passed hostingServer is null");
            return false;
        }
        try {
            return ProtobufUtil.getRegionInfo(hostingServer, regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RetriesExhaustedException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info((Object)("Failed verification of " + Bytes.toStringBinary((byte[])regionName) + " at address=" + address + ", exception=" + t.getMessage()));
        return false;
    }

    private AdminProtos.AdminService.BlockingInterface getMetaServerConnection(HConnection hConnection, ZooKeeperWatcher zkw, long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return MetaTableLocator.getCachedConnection(hConnection, this.waitMetaRegionLocation(zkw, timeout));
    }

    private static AdminProtos.AdminService.BlockingInterface getCachedConnection(HConnection hConnection, ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface service;
        block11: {
            if (sn == null) {
                return null;
            }
            service = null;
            try {
                service = hConnection.getAdmin(sn);
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug((Object)("Timed out connecting to " + sn));
            }
            catch (NoRouteToHostException e) {
                LOG.debug((Object)("Connecting to " + sn), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)("Exception connecting to " + sn));
            }
            catch (UnknownHostException e) {
                LOG.debug((Object)("Unknown host exception connecting to  " + sn));
            }
            catch (FailedServerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Server " + sn + " is in failed server list."));
                }
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (ioe instanceof ConnectException || cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase().contains("connection reset")) break block11;
                throw ioe;
            }
        }
        return service;
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName serverName, RegionState.State state) throws KeeperException {
        LOG.info((Object)("Setting hbase:meta region location in ZooKeeper as " + serverName));
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName(serverName)).setRpcVersion(0).setState(state.convert()).build();
        byte[] data = ProtobufUtil.prependPBMagic(pbrsr.toByteArray());
        try {
            ZKUtil.setData(zookeeper, zookeeper.metaServerZNode, data);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.debug((Object)"META region location doesn't existed, create it");
            ZKUtil.createAndWatch(zookeeper, zookeeper.metaServerZNode, data);
        }
    }

    public static RegionState getMetaRegionState(ZooKeeperWatcher zkw) throws KeeperException {
        ServerName serverName;
        RegionState.State state;
        block8: {
            state = RegionState.State.OPEN;
            serverName = null;
            try {
                byte[] data = ZKUtil.getData(zkw, zkw.metaServerZNode);
                if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix(data)) {
                    try {
                        int prefixLen = ProtobufUtil.lengthOfPBMagic();
                        ZooKeeperProtos.MetaRegionServer rl = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                        if (rl.hasState()) {
                            state = RegionState.State.convert(rl.getState());
                        }
                        HBaseProtos.ServerName sn = rl.getServer();
                        serverName = ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
                        break block8;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new DeserializationException("Unable to parse meta region location");
                    }
                }
                serverName = ServerName.parseFrom(data);
            }
            catch (DeserializationException e) {
                throw ZKUtil.convert(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(HRegionInfo.FIRST_META_REGIONINFO, state, serverName);
    }

    public void deleteMetaLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        LOG.info((Object)"Deleting hbase:meta region location in ZooKeeper");
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.metaServerZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName blockUntilAvailable(ZooKeeperWatcher zkw, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        Stopwatch sw = new Stopwatch().start();
        ServerName sn = null;
        try {
            while ((sn = this.getMetaRegionLocation(zkw)) == null) {
                if (sw.elapsedMillis() > timeout - 200L) {
                    break;
                }
                Thread.sleep(200L);
            }
        }
        finally {
            sw.stop();
        }
        return sn;
    }

    public void stop() {
        if (!this.stopped) {
            LOG.debug((Object)"Stopping MetaTableLocator");
            this.stopped = true;
        }
    }
}

