/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VisibilityClient {
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Configuration conf, String label) throws Throwable {
        return VisibilityClient.addLabels(conf, new String[]{label});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Configuration conf, final String[] labels) throws Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                    for (String label : labels) {
                        if (label.length() <= 0) continue;
                        VisibilityLabelsProtos.VisibilityLabel.Builder newBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
                        newBuilder.setLabel(ByteStringer.wrap((byte[])Bytes.toBytes((String)label)));
                        builder.addVisLabel(newBuilder.build());
                    }
                    service.addLabels((RpcController)this.controller, builder.build(), this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Configuration conf, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(conf, auths, user, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Configuration conf, final String user) throws Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.GetAuthsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.GetAuthsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.GetAuthsRequest.Builder getAuthReqBuilder = VisibilityLabelsProtos.GetAuthsRequest.newBuilder();
                    getAuthReqBuilder.setUser(ByteStringer.wrap((byte[])Bytes.toBytes((String)user)));
                    service.getAuths((RpcController)this.controller, getAuthReqBuilder.build(), this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], VisibilityLabelsProtos.GetAuthsResponse> result = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = result.values().iterator().next();
            return getAuthsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Configuration conf, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(conf, auths, user, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VisibilityLabelsProtos.VisibilityLabelsResponse setOrClearAuths(Configuration conf, final String[] auths, final String user, final boolean setOrClear) throws IOException, ServiceException, Throwable {
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.SetAuthsRequest.Builder setAuthReqBuilder = VisibilityLabelsProtos.SetAuthsRequest.newBuilder();
                    setAuthReqBuilder.setUser(ByteStringer.wrap((byte[])Bytes.toBytes((String)user)));
                    for (String auth : auths) {
                        if (auth.length() <= 0) continue;
                        setAuthReqBuilder.addAuth(ByteStringer.wrap((byte[])Bytes.toBytes((String)auth)));
                    }
                    if (setOrClear) {
                        service.setAuths((RpcController)this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    } else {
                        service.clearAuths((RpcController)this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    }
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = ht.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }
}

