/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public final class MultiAction<R> {
    public Map<byte[], List<Action<R>>> actions = new TreeMap<byte[], List<Action<R>>>(Bytes.BYTES_COMPARATOR);
    private long nonceGroup = 0L;

    public int size() {
        int size = 0;
        for (List<Action<R>> l : this.actions.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Action<R> a) {
        List<Action<R>> rsActions = this.actions.get(regionName);
        if (rsActions == null) {
            rsActions = new ArrayList<Action<R>>();
            this.actions.put(regionName, rsActions);
        }
        rsActions.add(a);
    }

    public void setNonceGroup(long nonceGroup) {
        this.nonceGroup = nonceGroup;
    }

    public Set<byte[]> getRegions() {
        return this.actions.keySet();
    }

    public List<Action<R>> allActions() {
        ArrayList<Action<R>> res = new ArrayList<Action<R>>();
        for (List<Action<R>> lst : this.actions.values()) {
            res.addAll(lst);
        }
        return res;
    }

    public boolean hasNonceGroup() {
        return this.nonceGroup != 0L;
    }

    public long getNonceGroup() {
        return this.nonceGroup;
    }
}

