/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.base.Splitter;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationId
implements Comparable<ApplicationId> {
    private static Splitter _spliter = Splitter.on((char)'_').trimResults();
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appIdStrPrefix = "application";
    static final ThreadLocal<NumberFormat> appIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ApplicationId newInstance(long clusterTimestamp, int id) {
        ApplicationId appId = Records.newRecord(ApplicationId.class);
        appId.setClusterTimestamp(clusterTimestamp);
        appId.setId(id);
        appId.build();
        return appId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getClusterTimestamp();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setClusterTimestamp(long var1);

    protected abstract void build();

    @Override
    public int compareTo(ApplicationId other) {
        if (this.getClusterTimestamp() - other.getClusterTimestamp() == 0L) {
            return this.getId() - other.getId();
        }
        return this.getClusterTimestamp() > other.getClusterTimestamp() ? 1 : (this.getClusterTimestamp() < other.getClusterTimestamp() ? -1 : 0);
    }

    public String toString() {
        return "application_" + this.getClusterTimestamp() + "_" + appIdFormat.get().format(this.getId());
    }

    private static ApplicationId toApplicationId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        return appId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationId fromString(String appIdStr) {
        Iterator<String> it = _spliter.split((CharSequence)appIdStr).iterator();
        if (!((String)it.next()).equals(appIdStrPrefix)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + appIdStr + ". The valid ApplicationId should start with prefix " + appIdStrPrefix);
        }
        try {
            return ApplicationId.toApplicationId(it);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, n);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, e);
        }
    }

    public int hashCode() {
        int prime = 371237;
        int result = 6521;
        long clusterTimestamp = this.getClusterTimestamp();
        result = 371237 * result + (int)(clusterTimestamp ^ clusterTimestamp >>> 32);
        result = 371237 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationId other = (ApplicationId)obj;
        if (this.getClusterTimestamp() != other.getClusterTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

