/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;

public class JobCounterUpdateEvent
extends JobEvent {
    List<CounterIncrementalUpdate> counterUpdates = new ArrayList<CounterIncrementalUpdate>();

    public JobCounterUpdateEvent(JobId jobId) {
        super(jobId, JobEventType.JOB_COUNTER_UPDATE);
    }

    public void addCounterUpdate(Enum<?> key, long incrValue) {
        this.counterUpdates.add(new CounterIncrementalUpdate(key, incrValue));
    }

    public List<CounterIncrementalUpdate> getCounterUpdates() {
        return this.counterUpdates;
    }

    public static class CounterIncrementalUpdate {
        Enum<?> key;
        long incrValue;

        public CounterIncrementalUpdate(Enum<?> key, long incrValue) {
            this.key = key;
            this.incrValue = incrValue;
        }

        public Enum<?> getCounterKey() {
            return this.key;
        }

        public long getIncrementValue() {
            return this.incrValue;
        }
    }
}

