/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;

@InterfaceStability.Evolving
public interface Table<KEY, VALUE>
extends AutoCloseable {
    public void put(KEY var1, VALUE var2) throws IOException;

    public void putWithBatch(BatchOperation var1, KEY var2, VALUE var3) throws IOException;

    public boolean isEmpty() throws IOException;

    public boolean isExist(KEY var1) throws IOException;

    public VALUE get(KEY var1) throws IOException;

    public void delete(KEY var1) throws IOException;

    public void deleteWithBatch(BatchOperation var1, KEY var2) throws IOException;

    public TableIterator<KEY, ? extends KeyValue<KEY, VALUE>> iterator();

    public String getName() throws IOException;

    public long getEstimatedKeyCount() throws IOException;

    default public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        throw new NotImplementedException("addCacheEntry is not implemented");
    }

    default public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        throw new NotImplementedException("getCacheValue is not implemented");
    }

    default public void cleanupCache(List<Long> epochs) {
        throw new NotImplementedException("cleanupCache is not implemented");
    }

    default public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        throw new NotImplementedException("cacheIterator is not implemented");
    }

    public static interface KeyValue<KEY, VALUE> {
        public KEY getKey() throws IOException;

        public VALUE getValue() throws IOException;
    }
}

