/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class RDBMetrics {
    private static final String SOURCE_NAME = RDBMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numDBKeyMayExistChecks;
    @Metric
    private MutableCounterLong numDBKeyMayExistMisses;

    public static RDBMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (RDBMetrics)ms.register(SOURCE_NAME, "Rocks DB Metrics", (Object)new RDBMetrics());
    }

    public void incNumDBKeyMayExistChecks() {
        this.numDBKeyMayExistChecks.incr();
    }

    public void incNumDBKeyMayExistMisses() {
        this.numDBKeyMayExistMisses.incr();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistChecks() {
        return this.numDBKeyMayExistChecks.value();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistMisses() {
        return this.numDBKeyMayExistMisses.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

