/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.DBConfigFromFile;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.TableConfig;
import org.eclipse.jetty.util.StringUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DBStoreBuilder.class);
    public static final Logger ROCKS_DB_LOGGER = LoggerFactory.getLogger(RocksDB.class);
    private static final String DEFAULT_COLUMN_FAMILY_NAME = StringUtils.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY);
    public static final DBProfile HDDS_DEFAULT_DB_PROFILE = DBProfile.DISK;
    private Set<TableConfig> tables = new HashSet<TableConfig>();
    private DBProfile dbProfile;
    private DBOptions rocksDBOption;
    private String dbname;
    private Path dbPath;
    private List<String> tableNames = new LinkedList<String>();
    private Configuration configuration;
    private CodecRegistry registry;
    private String rocksDbStat;
    private RocksDBConfiguration rocksDBConfiguration;

    private DBStoreBuilder(OzoneConfiguration configuration) {
        this(configuration, (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class));
    }

    private DBStoreBuilder(OzoneConfiguration configuration, RocksDBConfiguration rocksDBConfiguration) {
        this.configuration = configuration;
        this.registry = new CodecRegistry();
        this.rocksDbStat = configuration.getTrimmed("ozone.metastore.rocksdb.statistics", "OFF");
        this.rocksDBConfiguration = rocksDBConfiguration;
    }

    public static DBStoreBuilder newBuilder(OzoneConfiguration configuration) {
        return new DBStoreBuilder(configuration);
    }

    public static DBStoreBuilder newBuilder(OzoneConfiguration configuration, RocksDBConfiguration rocksDBConfiguration) {
        return new DBStoreBuilder(configuration, rocksDBConfiguration);
    }

    public DBStoreBuilder setProfile(DBProfile profile) {
        this.dbProfile = profile;
        return this;
    }

    public DBStoreBuilder setName(String name) {
        this.dbname = name;
        return this;
    }

    public DBStoreBuilder addTable(String tableName) {
        this.tableNames.add(tableName);
        return this;
    }

    public <T> DBStoreBuilder addCodec(Class<T> type, Codec<T> codec) {
        this.registry.addCodec(type, codec);
        return this;
    }

    public DBStoreBuilder addTable(String tableName, ColumnFamilyOptions option) throws IOException {
        LOG.debug("using custom profile for table: {}", (Object)tableName);
        return this.addTableDefinition(tableName, option);
    }

    private DBStoreBuilder addTableDefinition(String tableName, ColumnFamilyOptions option) throws IOException {
        TableConfig tableConfig = new TableConfig(tableName, option);
        if (!this.tables.add(tableConfig)) {
            String message = "Unable to add the table: " + tableName + ".  Please check if this table name is already in use.";
            LOG.error(message);
            throw new IOException(message);
        }
        return this;
    }

    public DBStoreBuilder setDBOption(DBOptions option) {
        this.rocksDBOption = option;
        return this;
    }

    public DBStoreBuilder setPath(Path path) {
        Preconditions.checkNotNull((Object)path);
        this.dbPath = path;
        return this;
    }

    public DBStore build() throws IOException {
        if (StringUtil.isBlank((String)this.dbname) || this.dbPath == null) {
            LOG.error("Required Parameter missing.");
            throw new IOException("Required parameter is missing. Please make sure sure Path and DB name is provided.");
        }
        this.processDBProfile();
        this.processTables();
        DBOptions options = this.getDbProfile();
        WriteOptions writeOptions = new WriteOptions();
        writeOptions.setSync(this.rocksDBConfiguration.getSyncOption());
        File dbFile = this.getDBFile();
        if (!dbFile.getParentFile().exists()) {
            throw new IOException("The DB destination directory should exist.");
        }
        return new RDBStore(dbFile, options, writeOptions, this.tables, this.registry);
    }

    private void processDBProfile() {
        if (this.dbProfile == null) {
            this.dbProfile = (DBProfile)this.configuration.getEnum("hdds.db.profile", (Enum)HDDS_DEFAULT_DB_PROFILE);
        }
        LOG.debug("default profile:{}", (Object)this.dbProfile);
    }

    private void processTables() throws IOException {
        ArrayList<String> list = new ArrayList<String>(this.tableNames);
        list.add(DEFAULT_COLUMN_FAMILY_NAME);
        for (String name : list) {
            LOG.debug("using default profile for table:{}", (Object)name);
            this.addTableDefinition(name, this.dbProfile.getColumnFamilyOptions());
        }
    }

    private DBOptions getDbProfile() {
        if (this.rocksDBOption != null) {
            return this.rocksDBOption;
        }
        DBOptions option = null;
        if (StringUtil.isNotBlank((String)this.dbname)) {
            LinkedList<ColumnFamilyDescriptor> columnFamilyDescriptors = new LinkedList<ColumnFamilyDescriptor>();
            for (TableConfig tc : this.tables) {
                columnFamilyDescriptors.add(tc.getDescriptor());
            }
            if (columnFamilyDescriptors.size() > 0) {
                try {
                    option = DBConfigFromFile.readFromFile(this.dbname, columnFamilyDescriptors);
                    if (option != null) {
                        LOG.info("Using Configs from {}.ini file", (Object)this.dbname);
                    }
                }
                catch (IOException ex) {
                    LOG.info("Unable to read RocksDB config from {}", (Object)this.dbname, (Object)ex);
                }
            }
        }
        if (option == null) {
            LOG.debug("Using default options: {}", (Object)this.dbProfile);
            option = this.dbProfile.getDBOptions();
        }
        if (this.rocksDBConfiguration.isRocksdbLoggingEnabled()) {
            org.rocksdb.Logger logger = new org.rocksdb.Logger(option){

                protected void log(InfoLogLevel infoLogLevel, String s) {
                    ROCKS_DB_LOGGER.info(s);
                }
            };
            InfoLogLevel level = InfoLogLevel.valueOf((String)(this.rocksDBConfiguration.getRocksdbLogLevel() + "_LEVEL"));
            logger.setInfoLogLevel(level);
            option.setLogger(logger);
        }
        if (!this.rocksDbStat.equals("OFF")) {
            Statistics statistics = new Statistics();
            statistics.setStatsLevel(StatsLevel.valueOf((String)this.rocksDbStat));
            option = option.setStatistics(statistics);
        }
        return option;
    }

    private File getDBFile() throws IOException {
        if (this.dbPath == null) {
            LOG.error("DB path is required.");
            throw new IOException("A Path to for DB file is needed.");
        }
        if (StringUtil.isBlank((String)this.dbname)) {
            LOG.error("DBName is a required.");
            throw new IOException("A valid DB name is required.");
        }
        return Paths.get(this.dbPath.toString(), this.dbname).toFile();
    }
}

