/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResourceType;

class DynoResource {
    private final String name;
    private final LocalResourceType type;
    private final String resourcePath;

    DynoResource(String name, LocalResourceType type, String resourcePath) {
        this.name = name;
        this.type = type;
        this.resourcePath = resourcePath;
    }

    public Path getPath(Map<String, String> env) {
        return new Path(env.get(this.getLocationEnvVar()));
    }

    public long getTimestamp(Map<String, String> env) {
        return Long.parseLong(env.get(this.getTimestampEnvVar()));
    }

    public long getLength(Map<String, String> env) {
        return Long.parseLong(env.get(this.getLengthEnvVar()));
    }

    public String getLocationEnvVar() {
        return this.name + "_LOCATION";
    }

    public String getTimestampEnvVar() {
        return this.name + "_TIMESTAMP";
    }

    public String getLengthEnvVar() {
        return this.name + "_LENGTH";
    }

    public LocalResourceType getType() {
        return this.type;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String toString() {
        return this.name;
    }
}

