/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.AbstractServiceLauncherTestBase;
import org.apache.hadoop.service.launcher.ExitTrackingServiceLauncher;
import org.apache.hadoop.service.launcher.InterruptEscalator;
import org.apache.hadoop.service.launcher.IrqHandler;
import org.apache.hadoop.service.launcher.testservices.FailureTestService;
import org.apache.hadoop.util.ExitCodeProvider;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceInterruptHandling
extends AbstractServiceLauncherTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceInterruptHandling.class);

    @Test
    public void testRegisterAndRaise() throws Throwable {
        InterruptCatcher catcher = new InterruptCatcher();
        String name = "INT";
        IrqHandler irqHandler = new IrqHandler(name, (IrqHandler.Interrupted)catcher);
        irqHandler.bind();
        TestServiceInterruptHandling.assertEquals((long)0L, (long)irqHandler.getSignalCount());
        irqHandler.raise();
        Thread.sleep(500L);
        IrqHandler.InterruptData data = catcher.interruptData;
        TestServiceInterruptHandling.assertNotNull((String)"interrupt data", (Object)data);
        TestServiceInterruptHandling.assertEquals((Object)name, (Object)data.getName());
        TestServiceInterruptHandling.assertEquals((long)1L, (long)irqHandler.getSignalCount());
    }

    @Test
    public void testInterruptEscalationShutdown() throws Throwable {
        ExitTrackingServiceLauncher launcher = new ExitTrackingServiceLauncher(BreakableService.class.getName());
        BreakableService service = new BreakableService();
        launcher.setService((Service)service);
        InterruptEscalator escalator = new InterruptEscalator(launcher, 500);
        try {
            escalator.interrupted(new IrqHandler.InterruptData("INT", 3));
            TestServiceInterruptHandling.fail((String)("Expected an exception to be raised in " + escalator));
        }
        catch (ExitUtil.ExitException e) {
            this.assertExceptionDetails(3, "", (ExitCodeProvider)e);
        }
        this.assertStopped((Service)service);
        TestServiceInterruptHandling.assertTrue((String)("isSignalAlreadyReceived() == false in " + escalator), (boolean)escalator.isSignalAlreadyReceived());
        TestServiceInterruptHandling.assertFalse((String)("isForcedShutdownTimedOut() == true in " + escalator), (boolean)escalator.isForcedShutdownTimedOut());
        try {
            escalator.interrupted(new IrqHandler.InterruptData("INT", 3));
            TestServiceInterruptHandling.fail((String)("Expected an exception to be raised in " + escalator));
        }
        catch (ExitUtil.HaltException e) {
            this.assertExceptionDetails(3, "", (ExitCodeProvider)e);
        }
    }

    @Test
    public void testBlockingShutdownTimeouts() throws Throwable {
        ExitTrackingServiceLauncher launcher = new ExitTrackingServiceLauncher(FailureTestService.class.getName());
        FailureTestService service = new FailureTestService(false, false, false, 2000);
        launcher.setService((Service)service);
        InterruptEscalator escalator = new InterruptEscalator(launcher, 500);
        try {
            escalator.interrupted(new IrqHandler.InterruptData("INT", 3));
            TestServiceInterruptHandling.fail((String)("Expected an exception to be raised from " + escalator));
        }
        catch (ExitUtil.ExitException e) {
            this.assertExceptionDetails(3, "", (ExitCodeProvider)e);
        }
        TestServiceInterruptHandling.assertTrue((String)("isForcedShutdownTimedOut() == false in " + escalator), (boolean)escalator.isForcedShutdownTimedOut());
    }

    private static class InterruptCatcher
    implements IrqHandler.Interrupted {
        public IrqHandler.InterruptData interruptData;

        private InterruptCatcher() {
        }

        public void interrupted(IrqHandler.InterruptData data) {
            LOG.info("Interrupt caught");
            this.interruptData = data;
        }
    }
}

