/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.sasl.SaslException;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRetryProxy {
    private UnreliableImplementation unreliableImpl;
    private RetryPolicy.RetryAction caughtRetryAction = null;

    @Before
    public void setUp() throws Exception {
        this.unreliableImpl = new UnreliableImplementation();
    }

    private void setupMockPolicy(RetryPolicy mockPolicy, final RetryPolicy realPolicy) throws Exception {
        Mockito.when((Object)mockPolicy.shouldRetry((Exception)Matchers.any(Exception.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean())).thenAnswer((Answer)new Answer<RetryPolicy.RetryAction>(){

            public RetryPolicy.RetryAction answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Exception e = (Exception)args[0];
                int retries = (Integer)args[1];
                int failovers = (Integer)args[2];
                boolean isIdempotentOrAtMostOnce = (Boolean)args[3];
                TestRetryProxy.this.caughtRetryAction = realPolicy.shouldRetry(e, retries, failovers, isIdempotentOrAtMostOnce);
                return TestRetryProxy.this.caughtRetryAction;
            }
        });
    }

    @Test
    public void testTryOnceThenFail() throws Exception {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicies.TryOnceThenFail.class);
        RetryPolicy realPolicy = RetryPolicies.TRY_ONCE_THEN_FAIL;
        this.setupMockPolicy(policy, realPolicy);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)policy);
        unreliable.alwaysSucceeds();
        try {
            unreliable.failsOnceThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException e) {
            ((RetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)1))).shouldRetry((Exception)Matchers.any(Exception.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean());
            Assert.assertEquals((Object)RetryPolicy.RetryAction.RetryDecision.FAIL, (Object)this.caughtRetryAction.action);
            Assert.assertEquals((Object)"try once and fail.", (Object)this.caughtRetryAction.reason);
        }
        catch (Exception e) {
            Assert.fail((String)"Other exception other than UnreliableException should also get failed.");
        }
    }

    @Test
    public void testRpcInvocation() throws Exception {
        final UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        Assert.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation((Object)unreliable));
        final AtomicInteger count = new AtomicInteger();
        ProtocolTranslator xlator = new ProtocolTranslator(){

            public Object getUnderlyingProxyObject() {
                count.getAndIncrement();
                return unreliable;
            }
        };
        Assert.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation((Object)xlator));
        Assert.assertEquals((long)1L, (long)count.get());
        Assert.assertFalse((boolean)RetryInvocationHandler.isRpcInvocation((Object)new Object()));
    }

    @Test
    public void testRetryForever() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        unreliable.failsTenTimesThenSucceeds();
    }

    @Test
    public void testRetryForeverWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryForeverWithFixedSleep((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        unreliable.failsTenTimesThenSucceeds();
    }

    @Test
    public void testRetryUpToMaximumCountWithFixedSleep() throws Exception {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicies.RetryUpToMaximumCountWithFixedSleep.class);
        int maxRetries = 8;
        RetryPolicy realPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetries, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS);
        this.setupMockPolicy(policy, realPolicy);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)policy);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException e) {
            ((RetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)(maxRetries + 2)))).shouldRetry((Exception)Matchers.any(Exception.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean());
            Assert.assertEquals((Object)RetryPolicy.RetryAction.RetryDecision.FAIL, (Object)this.caughtRetryAction.action);
            Assert.assertEquals((Object)RetryPolicies.RetryUpToMaximumCountWithFixedSleep.constructReasonString((int)maxRetries), (Object)this.caughtRetryAction.reason);
        }
        catch (Exception e) {
            Assert.fail((String)"Other exception other than UnreliableException should also get failed.");
        }
    }

    @Test
    public void testRetryUpToMaximumTimeWithFixedSleep() throws Exception {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicies.RetryUpToMaximumTimeWithFixedSleep.class);
        long maxTime = 80L;
        RetryPolicy realPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)maxTime, (long)10L, (TimeUnit)TimeUnit.NANOSECONDS);
        this.setupMockPolicy(policy, realPolicy);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)policy);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException e) {
            ((RetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)((int)(maxTime / 10L) + 2)))).shouldRetry((Exception)Matchers.any(Exception.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean());
            Assert.assertEquals((Object)RetryPolicy.RetryAction.RetryDecision.FAIL, (Object)this.caughtRetryAction.action);
            Assert.assertEquals((Object)RetryPolicies.RetryUpToMaximumTimeWithFixedSleep.constructReasonString((long)maxTime, (TimeUnit)TimeUnit.NANOSECONDS), (Object)this.caughtRetryAction.reason);
        }
        catch (Exception e) {
            Assert.fail((String)"Other exception other than UnreliableException should also get failed.");
        }
    }

    @Test
    public void testRetryUpToMaximumCountWithProportionalSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithProportionalSleep((int)8, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testExponentialRetry() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)5, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryByException() throws UnreliableInterface.UnreliableException {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.alwaysFailsWithFatalException();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.FatalException fatalException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryByRemoteException() {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        try {
            unreliable.alwaysFailsWithRemoteFatalException();
            Assert.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryOtherThanRemoteException() throws Throwable {
        Map<Class<IOException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(IOException.class, RetryPolicies.RETRY_FOREVER);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryOtherThanRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap));
        unreliable.failsOnceWithIOException();
        try {
            unreliable.failsOnceWithRemoteException();
            Assert.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryInterruptible() throws Throwable {
        final UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)10L, (long)10L, (TimeUnit)TimeUnit.SECONDS));
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference futureThread = new AtomicReference();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Throwable> future = exec.submit(new Callable<Throwable>(){

            @Override
            public Throwable call() throws Exception {
                futureThread.set(Thread.currentThread());
                latch.countDown();
                try {
                    unreliable.alwaysFailsWithFatalException();
                }
                catch (UndeclaredThrowableException ute) {
                    return ute.getCause();
                }
                return null;
            }
        });
        latch.await();
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)((Thread)futureThread.get()).isAlive());
        ((Thread)futureThread.get()).interrupt();
        Throwable e = future.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals(InterruptedIOException.class, e.getClass());
        Assert.assertEquals((Object)"Retry interrupted", (Object)e.getMessage());
        Assert.assertEquals(InterruptedException.class, e.getCause().getClass());
        Assert.assertEquals((Object)"sleep interrupted", (Object)e.getCause().getMessage());
    }

    @Test
    public void testNoRetryOnSaslError() throws Exception {
        RetryPolicy policy = (RetryPolicy)Mockito.mock(RetryPolicy.class);
        RetryPolicy realPolicy = RetryPolicies.failoverOnNetworkException((int)5);
        this.setupMockPolicy(policy, realPolicy);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)policy);
        try {
            unreliable.failsWithSASLExceptionTenTimes();
            Assert.fail((String)"Should fail");
        }
        catch (SaslException e) {
            ((RetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)1))).shouldRetry((Exception)Matchers.any(Exception.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean());
            Assert.assertEquals((Object)RetryPolicy.RetryAction.RetryDecision.FAIL, (Object)this.caughtRetryAction.action);
        }
    }
}

