/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.Deque;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.FilterExpression;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFilterExpression {
    private Expression expr;
    private FilterExpression test;
    @Rule
    public Timeout globalTimeout = new Timeout(10000);

    @Before
    public void setup() {
        this.expr = (Expression)Mockito.mock(Expression.class);
        this.test = new FilterExpression(this.expr){};
    }

    @Test
    public void expression() throws IOException {
        Assert.assertEquals((Object)this.expr, (Object)this.test.expression);
    }

    @Test
    public void setOptions() throws IOException {
        FindOptions options = (FindOptions)Mockito.mock(FindOptions.class);
        this.test.setOptions(options);
        ((Expression)Mockito.verify((Object)this.expr)).setOptions(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void apply() throws IOException {
        PathData item = (PathData)Mockito.mock(PathData.class);
        Mockito.when((Object)this.expr.apply(item, -1)).thenReturn((Object)Result.PASS).thenReturn((Object)Result.FAIL);
        Assert.assertEquals((Object)Result.PASS, (Object)this.test.apply(item, -1));
        Assert.assertEquals((Object)Result.FAIL, (Object)this.test.apply(item, -1));
        ((Expression)Mockito.verify((Object)this.expr, (VerificationMode)Mockito.times((int)2))).apply(item, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void finish() throws IOException {
        this.test.finish();
        ((Expression)Mockito.verify((Object)this.expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void getUsage() {
        Object[] usage = new String[]{"Usage 1", "Usage 2", "Usage 3"};
        Mockito.when((Object)this.expr.getUsage()).thenReturn((Object)usage);
        Assert.assertArrayEquals((Object[])usage, (Object[])this.test.getUsage());
        ((Expression)Mockito.verify((Object)this.expr)).getUsage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void getHelp() {
        Object[] help = new String[]{"Help 1", "Help 2", "Help 3"};
        Mockito.when((Object)this.expr.getHelp()).thenReturn((Object)help);
        Assert.assertArrayEquals((Object[])help, (Object[])this.test.getHelp());
        ((Expression)Mockito.verify((Object)this.expr)).getHelp();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void isAction() {
        Mockito.when((Object)this.expr.isAction()).thenReturn((Object)true).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.test.isAction());
        Assert.assertFalse((boolean)this.test.isAction());
        ((Expression)Mockito.verify((Object)this.expr, (VerificationMode)Mockito.times((int)2))).isAction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void isOperator() {
        Mockito.when((Object)this.expr.isAction()).thenReturn((Object)true).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.test.isAction());
        Assert.assertFalse((boolean)this.test.isAction());
        ((Expression)Mockito.verify((Object)this.expr, (VerificationMode)Mockito.times((int)2))).isAction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void getPrecedence() {
        int precedence = 12345;
        Mockito.when((Object)this.expr.getPrecedence()).thenReturn((Object)precedence);
        Assert.assertEquals((long)precedence, (long)this.test.getPrecedence());
        ((Expression)Mockito.verify((Object)this.expr)).getPrecedence();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void addChildren() {
        Deque expressions = (Deque)Mockito.mock(Deque.class);
        this.test.addChildren(expressions);
        ((Expression)Mockito.verify((Object)this.expr)).addChildren(expressions);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }

    @Test
    public void addArguments() {
        Deque args = (Deque)Mockito.mock(Deque.class);
        this.test.addArguments(args);
        ((Expression)Mockito.verify((Object)this.expr)).addArguments(args);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.expr});
    }
}

