/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ServiceConfigurationError;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSystemInitialization {
    @Test
    public void testInitializationWithRegisteredStreamFactory() {
        Configuration conf = new Configuration();
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory(conf));
        try {
            FileSystem.getFileSystemClass((String)"file", (Configuration)conf);
        }
        catch (IOException ok) {
            Assert.assertFalse((boolean)false);
        }
    }

    @Test
    public void testMissingLibraries() {
        try {
            Configuration conf = new Configuration();
            Class fs = FileSystem.getFileSystemClass((String)"s3a", (Configuration)conf);
            Assert.fail((String)("Expected an exception, got a filesystem: " + fs));
        }
        catch (Exception | ServiceConfigurationError throwable) {
            // empty catch block
        }
    }
}

