/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

@InterfaceAudience.Private
public class ZKUtil {
    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    throw new BadAclFormatException("Invalid permission '" + c + "' in permission string '" + permString + "'");
                }
            }
        }
        return perm;
    }

    public static List<ACL> parseACLs(String aclString) throws BadAclFormatException {
        ArrayList acl = Lists.newArrayList();
        if (aclString == null) {
            return acl;
        }
        ArrayList aclComps = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)aclString));
        for (String a : aclComps) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                throw new BadAclFormatException("ACL '" + a + "' not of expected form scheme:id:perm");
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZKUtil.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    public static List<ZKAuthInfo> parseAuth(String authString) throws BadAuthFormatException {
        ArrayList ret = Lists.newArrayList();
        if (authString == null) {
            return ret;
        }
        ArrayList authComps = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)authString));
        for (String comp : authComps) {
            String[] parts = comp.split(":", 2);
            if (parts.length != 2) {
                throw new BadAuthFormatException("Auth '" + comp + "' not of expected form scheme:auth");
            }
            ret.add(new ZKAuthInfo(parts[0], parts[1].getBytes(Charsets.UTF_8)));
        }
        return ret;
    }

    public static String resolveConfIndirection(String valInConf) throws IOException {
        if (valInConf == null) {
            return null;
        }
        if (!valInConf.startsWith("@")) {
            return valInConf;
        }
        String path = valInConf.substring(1).trim();
        return Files.toString((File)new File(path), (Charset)Charsets.UTF_8).trim();
    }

    @InterfaceAudience.Private
    public static class BadAuthFormatException
    extends HadoopIllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public BadAuthFormatException(String message) {
            super(message);
        }
    }

    @InterfaceAudience.Private
    public static class BadAclFormatException
    extends HadoopIllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public BadAclFormatException(String message) {
            super(message);
        }
    }

    @InterfaceAudience.Private
    public static class ZKAuthInfo {
        private final String scheme;
        private final byte[] auth;

        public ZKAuthInfo(String scheme, byte[] auth) {
            this.scheme = scheme;
            this.auth = auth;
        }

        public String getScheme() {
            return this.scheme;
        }

        public byte[] getAuth() {
            return this.auth;
        }
    }
}

