/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.shaded.com.google.common.base.Function;
import org.apache.hadoop.shaded.org.apache.curator.RetryLoop;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.CuratorWatcher;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.PredicateResults;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.locks.RevocationSpec;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.org.apache.curator.utils.PathUtils;
import org.apache.hadoop.shaded.org.apache.curator.utils.ThreadUtils;
import org.apache.hadoop.shaded.org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.shaded.org.apache.zookeeper.Watcher;

public class LockInternals {
    private final WatcherRemoveCuratorFramework client;
    private final String path;
    private final String basePath;
    private final LockInternalsDriver driver;
    private final String lockName;
    private final AtomicReference<RevocationSpec> revocable = new AtomicReference<Object>(null);
    private final CuratorWatcher revocableWatcher = new CuratorWatcher(){

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                LockInternals.this.checkRevocableWatcher(event.getPath());
            }
        }
    };
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            LockInternals.this.client.postSafeNotify(LockInternals.this);
        }
    };
    private volatile int maxLeases;
    static final byte[] REVOKE_MESSAGE = "__REVOKE__".getBytes();

    public void clean() throws Exception {
        try {
            this.client.delete().forPath(this.basePath);
        }
        catch (KeeperException.BadVersionException badVersionException) {
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
            // empty catch block
        }
    }

    LockInternals(CuratorFramework client, LockInternalsDriver driver, String path, String lockName, int maxLeases) {
        this.driver = driver;
        this.lockName = lockName;
        this.maxLeases = maxLeases;
        this.client = client.newWatcherRemoveCuratorFramework();
        this.basePath = PathUtils.validatePath(path);
        this.path = ZKPaths.makePath(path, lockName);
    }

    synchronized void setMaxLeases(int maxLeases) {
        this.maxLeases = maxLeases;
        this.notifyAll();
    }

    void makeRevocable(RevocationSpec entry) {
        this.revocable.set(entry);
    }

    final void releaseLock(String lockPath) throws Exception {
        this.client.removeWatchers();
        this.revocable.set(null);
        this.deleteOurPath(lockPath);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    public static Collection<String> getParticipantNodes(CuratorFramework client, final String basePath, String lockName, LockInternalsSorter sorter) throws Exception {
        List<String> names = LockInternals.getSortedChildren(client, basePath, lockName, sorter);
        Iterable<String> transformed = Iterables.transform(names, new Function<String, String>(){

            @Override
            public String apply(String name) {
                return ZKPaths.makePath(basePath, name);
            }
        });
        return ImmutableList.copyOf(transformed);
    }

    public static List<String> getSortedChildren(CuratorFramework client, String basePath, final String lockName, final LockInternalsSorter sorter) throws Exception {
        try {
            List children = (List)client.getChildren().forPath(basePath);
            ArrayList<String> sortedList = Lists.newArrayList(children);
            Collections.sort(sortedList, new Comparator<String>(){

                @Override
                public int compare(String lhs, String rhs) {
                    return sorter.fixForSorting(lhs, lockName).compareTo(sorter.fixForSorting(rhs, lockName));
                }
            });
            return sortedList;
        }
        catch (KeeperException.NoNodeException ignore) {
            return Collections.emptyList();
        }
    }

    public static List<String> getSortedChildren(final String lockName, final LockInternalsSorter sorter, List<String> children) {
        ArrayList<String> sortedList = Lists.newArrayList(children);
        Collections.sort(sortedList, new Comparator<String>(){

            @Override
            public int compare(String lhs, String rhs) {
                return sorter.fixForSorting(lhs, lockName).compareTo(sorter.fixForSorting(rhs, lockName));
            }
        });
        return sortedList;
    }

    List<String> getSortedChildren() throws Exception {
        return LockInternals.getSortedChildren(this.client, this.basePath, this.lockName, this.driver);
    }

    String getLockName() {
        return this.lockName;
    }

    LockInternalsDriver getDriver() {
        return this.driver;
    }

    String attemptLock(long time, TimeUnit unit, byte[] lockNodeBytes) throws Exception {
        long startMillis = System.currentTimeMillis();
        Long millisToWait = unit != null ? Long.valueOf(unit.toMillis(time)) : null;
        byte[] localLockNodeBytes = this.revocable.get() != null ? new byte[]{} : lockNodeBytes;
        int retryCount = 0;
        String ourPath = null;
        boolean hasTheLock = false;
        boolean isDone = false;
        while (!isDone) {
            isDone = true;
            try {
                ourPath = this.driver.createsTheLock(this.client, this.path, localLockNodeBytes);
                hasTheLock = this.internalLockLoop(startMillis, millisToWait, ourPath);
            }
            catch (KeeperException.NoNodeException e) {
                if (this.client.getZookeeperClient().getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMillis, RetryLoop.getDefaultRetrySleeper())) {
                    isDone = false;
                    continue;
                }
                throw e;
            }
        }
        if (hasTheLock) {
            return ourPath;
        }
        return null;
    }

    private void checkRevocableWatcher(String path) throws Exception {
        RevocationSpec entry = this.revocable.get();
        if (entry != null) {
            try {
                byte[] bytes = (byte[])((BackgroundPathable)this.client.getData().usingWatcher(this.revocableWatcher)).forPath(path);
                if (Arrays.equals(bytes, REVOKE_MESSAGE)) {
                    entry.getExecutor().execute(entry.getRunnable());
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalLockLoop(long startMillis, Long millisToWait, String ourPath) throws Exception {
        boolean haveTheLock = false;
        boolean doDelete = false;
        try {
            if (this.revocable.get() != null) {
                ((BackgroundPathable)this.client.getData().usingWatcher(this.revocableWatcher)).forPath(ourPath);
            }
            while (this.client.getState() == CuratorFrameworkState.STARTED) {
                String sequenceNodeName;
                if (haveTheLock) return haveTheLock;
                List<String> children = this.getSortedChildren();
                PredicateResults predicateResults = this.driver.getsTheLock(this.client, children, sequenceNodeName = ourPath.substring(this.basePath.length() + 1), this.maxLeases);
                if (predicateResults.getsTheLock()) {
                    haveTheLock = true;
                    continue;
                }
                String previousSequencePath = this.basePath + "/" + predicateResults.getPathToWatch();
                LockInternals lockInternals = this;
                synchronized (lockInternals) {
                    try {
                        ((BackgroundPathable)this.client.getData().usingWatcher(this.watcher)).forPath(previousSequencePath);
                        if (millisToWait != null) {
                            millisToWait = millisToWait - (System.currentTimeMillis() - startMillis);
                            startMillis = System.currentTimeMillis();
                            if (millisToWait <= 0L) {
                                doDelete = true;
                                return haveTheLock;
                            }
                            this.wait(millisToWait);
                        } else {
                            this.wait();
                        }
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                }
            }
            return haveTheLock;
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            doDelete = true;
            throw e;
        }
        finally {
            if (doDelete) {
                this.deleteOurPath(ourPath);
            }
        }
    }

    private void deleteOurPath(String ourPath) throws Exception {
        try {
            ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(ourPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }
}

