/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.util.PlatformName;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosUtil {
    public static final Oid GSS_SPNEGO_MECH_OID = KerberosUtil.getNumericOidInstance("1.3.6.1.5.5.2");
    public static final Oid GSS_KRB5_MECH_OID = KerberosUtil.getNumericOidInstance("1.2.840.113554.1.2.2");
    public static final Oid NT_GSS_KRB5_PRINCIPAL_OID = KerberosUtil.getNumericOidInstance("1.2.840.113554.1.2.2.1");

    public static String getKrb5LoginModuleName() {
        return PlatformName.IBM_JAVA ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    private static Oid getNumericOidInstance(String oidName) {
        try {
            return new Oid(oidName);
        }
        catch (GSSException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Oid getOidInstance(String oidName) throws ClassNotFoundException, GSSException, NoSuchFieldException, IllegalAccessException {
        Class<?> oidClass;
        if (PlatformName.IBM_JAVA) {
            if ("NT_GSS_KRB5_PRINCIPAL".equals(oidName)) {
                return new Oid("1.2.840.113554.1.2.2.1");
            }
            oidClass = Class.forName("com.ibm.security.jgss.GSSUtil");
        } else {
            oidClass = Class.forName("sun.security.jgss.GSSUtil");
        }
        Field oidField = oidClass.getDeclaredField(oidName);
        return (Oid)oidField.get(oidClass);
    }

    public static String getDefaultRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return new KerberosPrincipal("tmp", 1).getRealm();
    }

    public static String getDefaultRealmProtected() {
        try {
            return KerberosUtil.getDefaultRealm();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDomainRealm(String shortprinc) {
        String realmString = null;
        try {
            Class<?> classRef = PlatformName.IBM_JAVA ? Class.forName("com.ibm.security.krb5.PrincipalName") : Class.forName("sun.security.krb5.PrincipalName");
            int tKrbNtSrvHst = classRef.getField("KRB_NT_SRV_HST").getInt(null);
            Object principalName = classRef.getConstructor(String.class, Integer.TYPE).newInstance(shortprinc, tKrbNtSrvHst);
            realmString = (String)classRef.getMethod("getRealmString", new Class[0]).invoke(principalName, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == realmString || realmString.equals("")) {
            return KerberosUtil.getDefaultRealmProtected();
        }
        return realmString;
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static final String getServicePrincipal(String service, String hostname) throws UnknownHostException {
        String fqdn = hostname;
        String shortprinc = null;
        String realmString = null;
        if (null == fqdn || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = KerberosUtil.getLocalHostName();
        }
        fqdn = fqdn.toLowerCase(Locale.US);
        shortprinc = service + "/" + fqdn;
        realmString = KerberosUtil.getDomainRealm(shortprinc);
        if (null == realmString || realmString.equals("")) {
            return shortprinc;
        }
        return shortprinc + "@" + realmString;
    }

    static final String[] getPrincipalNames(String keytabFileName) throws IOException {
        Keytab keytab = Keytab.loadKeytab((File)new File(keytabFileName));
        HashSet<String> principals = new HashSet<String>();
        List entries = keytab.getPrincipals();
        for (PrincipalName entry : entries) {
            principals.add(entry.getName().replace("\\", "/"));
        }
        return principals.toArray(new String[0]);
    }

    public static final String[] getPrincipalNames(String keytab, Pattern pattern) throws IOException {
        String[] principals = KerberosUtil.getPrincipalNames(keytab);
        if (principals.length != 0) {
            ArrayList<String> matchingPrincipals = new ArrayList<String>();
            for (String principal : principals) {
                if (!pattern.matcher(principal).matches()) continue;
                matchingPrincipals.add(principal);
            }
            principals = matchingPrincipals.toArray(new String[0]);
        }
        return principals;
    }

    public static boolean hasKerberosKeyTab(Subject subject) {
        return !subject.getPrivateCredentials(KeyTab.class).isEmpty();
    }

    public static boolean hasKerberosTicket(Subject subject) {
        return !subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
    }

    public static String getTokenServerName(byte[] rawToken) {
        DER token = new DER(rawToken);
        DER oid = token.next();
        if (oid.equals(DER.SPNEGO_MECH_OID)) {
            token = token.next().get(160, 48, 162, 4).next();
            oid = token.next();
        }
        if (!oid.equals(DER.KRB5_MECH_OID)) {
            throw new IllegalArgumentException("Malformed gss token");
        }
        if (token.next().getTag() != 1) {
            throw new IllegalArgumentException("Not an AP-REQ token");
        }
        DER ticket = token.next().get(110, 48, 163, 97, 48);
        String realm = ticket.get(161, 27).getAsString();
        DER names = ticket.get(162, 48, 161, 48);
        StringBuilder sb = new StringBuilder();
        while (names.hasNext()) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(names.next().getAsString());
        }
        return sb.append('@').append(realm).toString();
    }

    private static class DER
    implements Iterator<DER> {
        static final DER SPNEGO_MECH_OID = DER.getDER(GSS_SPNEGO_MECH_OID);
        static final DER KRB5_MECH_OID = DER.getDER(GSS_KRB5_MECH_OID);
        private final int tag;
        private final ByteBuffer bb;

        private static DER getDER(Oid oid) {
            try {
                return new DER(oid.getDER());
            }
            catch (GSSException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        DER(byte[] buf) {
            this(ByteBuffer.wrap(buf));
        }

        DER(ByteBuffer srcbb) {
            this.tag = srcbb.get() & 0xFF;
            int length = DER.readLength(srcbb);
            this.bb = srcbb.slice();
            this.bb.limit(length);
            srcbb.position(srcbb.position() + length);
        }

        int getTag() {
            return this.tag;
        }

        private static int readLength(ByteBuffer bb) {
            int length = bb.get();
            if ((length & 0xFFFFFF80) != 0) {
                int varlength = length & 0x7F;
                length = 0;
                for (int i = 0; i < varlength; ++i) {
                    length = length << 8 | bb.get() & 0xFF;
                }
            }
            return length;
        }

        DER choose(int subtag) {
            while (this.hasNext()) {
                DER der = this.next();
                if (der.getTag() != subtag) continue;
                return der;
            }
            return null;
        }

        DER get(int ... tags) {
            DER der = this;
            for (int i = 0; i < tags.length; ++i) {
                int expectedTag = tags[i];
                if (der.getTag() != expectedTag) {
                    DER dER = der = der.hasNext() ? der.choose(expectedTag) : null;
                }
                if (der != null) continue;
                StringBuilder sb = new StringBuilder("Tag not found:");
                for (int ii = 0; ii <= i; ++ii) {
                    sb.append(" 0x").append(Integer.toHexString(tags[ii]));
                }
                throw new IllegalStateException(sb.toString());
            }
            return der;
        }

        String getAsString() {
            try {
                return new String(this.bb.array(), this.bb.arrayOffset() + this.bb.position(), this.bb.remaining(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalCharsetNameException("UTF-8");
            }
        }

        public int hashCode() {
            return 31 * this.tag + this.bb.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DER && this.tag == ((DER)o).tag && this.bb.equals(((DER)o).bb);
        }

        @Override
        public boolean hasNext() {
            return ((this.tag & 0x30) != 0 || this.tag == 4) && this.bb.hasRemaining();
        }

        @Override
        public DER next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new DER(this.bb);
        }

        public String toString() {
            return "[tag=0x" + Integer.toHexString(this.tag) + " bb=" + this.bb + "]";
        }
    }
}

