/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;

public class SpecificData
extends GenericData {
    private static final SpecificData INSTANCE = new SpecificData();
    private Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    private final WeakHashMap<Type, Schema> schemaCache = new WeakHashMap();

    protected SpecificData() {
    }

    public static SpecificData get() {
        return INSTANCE;
    }

    @Override
    protected boolean isRecord(Object datum) {
        return datum instanceof SpecificRecord;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        return ((SpecificRecord)record).getSchema();
    }

    @Override
    protected boolean isEnum(Object datum) {
        return datum instanceof Enum;
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case ENUM: {
                return datum instanceof Enum && schema.getEnumSymbols().contains(((Enum)datum).name());
            }
        }
        return super.validate(schema, datum);
    }

    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case ENUM: 
            case FIXED: 
            case RECORD: {
                String name = schema.getFullName();
                Class<?> c = this.classCache.get(name);
                if (c == null) {
                    try {
                        c = Class.forName(this.getClassName(schema));
                        this.classCache.put(name, c);
                    }
                    catch (ClassNotFoundException e) {
                        throw new AvroRuntimeException(e);
                    }
                }
                return c;
            }
            case ARRAY: {
                return GenericArray.class;
            }
            case MAP: {
                return Map.class;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return this.getClass(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return Object.class;
            }
            case STRING: {
                return Utf8.class;
            }
            case BYTES: {
                return ByteBuffer.class;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case NULL: {
                return Void.TYPE;
            }
        }
        throw new AvroRuntimeException("Unknown type: " + schema);
    }

    public String getClassName(Schema schema) {
        String namespace = schema.getNamespace();
        String name = schema.getName();
        if (namespace == null) {
            return name;
        }
        String dot = namespace.endsWith("$") ? "" : ".";
        return namespace + dot + name;
    }

    public Schema getSchema(Type type) {
        Schema schema = this.schemaCache.get(type);
        if (schema == null) {
            schema = this.createSchema(type, new LinkedHashMap<String, Schema>());
            this.schemaCache.put(type, schema);
        }
        return schema;
    }

    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type == Utf8.class) {
            return Schema.create(Schema.Type.STRING);
        }
        if (type == ByteBuffer.class) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Schema.create(Schema.Type.INT);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Schema.create(Schema.Type.LONG);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (type == Double.class || type == Double.TYPE) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        if (type == Void.class || type == Void.TYPE) {
            return Schema.create(Schema.Type.NULL);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (GenericArray.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                return Schema.createArray(this.createSchema(params[0], names));
            }
            if (Map.class.isAssignableFrom(raw)) {
                Type key = params[0];
                Type value = params[1];
                if (key != Utf8.class) {
                    throw new AvroTypeException("Map key class not Utf8: " + key);
                }
                return Schema.createMap(this.createSchema(value, names));
            }
            return this.createSchema(raw, names);
        }
        if (type instanceof Class) {
            Class c = (Class)type;
            String fullName = c.getName();
            Schema schema = names.get(fullName);
            if (schema == null) {
                try {
                    schema = (Schema)c.getDeclaredField("SCHEMA$").get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new AvroRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new AvroRuntimeException(e);
                }
            }
            names.put(fullName, schema);
            return schema;
        }
        throw new AvroTypeException("Unknown type: " + type);
    }

    public Protocol getProtocol(Class iface) {
        try {
            return (Protocol)iface.getDeclaredField("PROTOCOL").get(null);
        }
        catch (NoSuchFieldException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public int compare(Object o1, Object o2, Schema s) {
        switch (s.getType()) {
            case ENUM: {
                return ((Enum)o1).ordinal() - ((Enum)o2).ordinal();
            }
        }
        return super.compare(o1, o2, s);
    }
}

