/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.CombinedCodecIdentifier;
import org.grails.encoder.DefaultEncodingStateRegistry;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodingState;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.StreamingEncoderEncodedAppender;

public class ChainedEncoder
implements Encoder,
StreamingEncoder {
    private final StreamingEncoder[] encoders;
    private final CodecIdentifier combinedCodecIdentifier;
    private final boolean safe;
    private final ThreadLocal<ChainedEncoderCacheItem> cacheItemThreadLocal = new ThreadLocal<ChainedEncoderCacheItem>(){

        @Override
        protected ChainedEncoderCacheItem initialValue() {
            return new ChainedEncoderCacheItem();
        }
    };

    public ChainedEncoder(List<StreamingEncoder> encoders, boolean safe) {
        this(encoders.toArray(new StreamingEncoder[encoders.size()]), safe);
    }

    public ChainedEncoder(StreamingEncoder[] encoders, boolean safe) {
        this.encoders = Arrays.copyOf(encoders, encoders.length);
        this.combinedCodecIdentifier = this.createCodecIdentifier(encoders);
        this.safe = safe;
    }

    public static StreamingEncoder createFor(StreamingEncoder[] encoders) {
        return ChainedEncoder.createFor(Arrays.asList(encoders));
    }

    public static StreamingEncoder createFor(List<StreamingEncoder> encoders) {
        return ChainedEncoder.createFor(encoders, null);
    }

    public static StreamingEncoder createFor(List<StreamingEncoder> encoders, Boolean safe) {
        if (encoders == null) {
            return null;
        }
        if (encoders.size() == 0) {
            return DefaultEncodingStateRegistry.NONE_ENCODER;
        }
        if (encoders.size() == 1) {
            return encoders.get(0);
        }
        if (safe == null) {
            for (StreamingEncoder encoder : encoders) {
                if (!encoder.isSafe()) continue;
                safe = true;
                break;
            }
        }
        return new ChainedEncoder(encoders, safe != null ? safe : false);
    }

    protected CombinedCodecIdentifier createCodecIdentifier(StreamingEncoder[] encoders) {
        return new CombinedCodecIdentifier(encoders);
    }

    @Override
    public CodecIdentifier getCodecIdentifier() {
        return this.combinedCodecIdentifier;
    }

    @Override
    public void encodeToStream(Encoder thisInstance, CharSequence source, int offset, int len, EncodedAppender appender, EncodingState encodingState) throws IOException {
        EncodedAppender target = this.chainEncodersAndCachePerThread(appender);
        StreamingEncoder encoder = this.encoders[0];
        if (appender.shouldEncode(encoder, encodingState.getPreviousEncodingState())) {
            encoder.encodeToStream(encoder, source, offset, len, target, encodingState.getPreviousEncodingState());
        } else {
            target.appendEncoded((Encoder)encoder, encodingState.getPreviousEncodingState(), source, offset, len);
        }
    }

    protected EncodedAppender chainEncodersAndCachePerThread(EncodedAppender appender) {
        ChainedEncoderCacheItem cacheItem = this.cacheItemThreadLocal.get();
        EncodedAppender target = cacheItem.getCached(appender);
        if (target == null) {
            target = this.doChainEncoders(appender);
            cacheItem.putInCache(appender, target);
        }
        return target;
    }

    protected EncodedAppender doChainEncoders(EncodedAppender appender) {
        EncodedAppender target = appender;
        for (int i = this.encoders.length - 1; i >= 1; --i) {
            StreamingEncoder encoder = this.encoders[i];
            target = new StreamingEncoderEncodedAppender(encoder, target);
            target.setIgnoreEncodingState(appender.isIgnoreEncodingState());
        }
        return target;
    }

    @Override
    public Object encode(Object o) {
        if (o == null) {
            return o;
        }
        Object encoded = o;
        for (StreamingEncoder encoder : this.encoders) {
            encoded = encoder.encode(encoded);
        }
        return encoded;
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public boolean isApplyToSafelyEncoded() {
        return true;
    }

    @Override
    public void markEncoded(CharSequence string) {
    }

    private static class ChainedEncoderCacheItem {
        EncodedAppender lastAppenderForCached;
        boolean lastIgnoreEncodingStateForCached;
        EncodedAppender cachedChainedAppender;

        private ChainedEncoderCacheItem() {
        }

        void putInCache(EncodedAppender appender, EncodedAppender target) {
            this.lastAppenderForCached = appender;
            this.lastIgnoreEncodingStateForCached = appender.isIgnoreEncodingState();
            this.cachedChainedAppender = target;
        }

        EncodedAppender getCached(EncodedAppender appender) {
            if (this.lastAppenderForCached == appender && this.lastIgnoreEncodingStateForCached == appender.isIgnoreEncodingState()) {
                return this.cachedChainedAppender;
            }
            return null;
        }
    }
}

