/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.pages;

import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.plugins.PluginManagerAware;
import grails.util.GrailsStringUtils;
import groovy.text.Template;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.gsp.GroovyPageTemplate;
import org.grails.gsp.GroovyPagesTemplateEngine;
import org.grails.gsp.io.GroovyPageCompiledScriptSource;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.plugins.BinaryGrailsPlugin;
import org.grails.web.pages.GSPResponseWriter;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.GrailsApplicationAttributes;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.util.WebUtils;

public class GroovyPagesServlet
extends FrameworkServlet
implements PluginManagerAware {
    private static final long serialVersionUID = -1918149859392123495L;
    private static final String WEB_INF = "/WEB-INF";
    private static final String GRAILS_APP = "/grails-app";
    private ServletContext context;
    private GrailsApplicationAttributes grailsAttributes;
    public static final String SERVLET_INSTANCE = "org.codehaus.groovy.grails.GSP_SERVLET";
    private GroovyPagesTemplateEngine groovyPagesTemplateEngine;
    private GrailsPluginManager pluginManager;
    private final Map<String, Class> binaryPluginViewsMap = new ConcurrentHashMap<String, Class>();

    public GroovyPagesServlet() {
        this.setContextAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    protected ServletRequestAttributes buildRequestAttributes(HttpServletRequest request, HttpServletResponse response, RequestAttributes previousAttributes) {
        if (previousAttributes instanceof GrailsWebRequest) {
            return null;
        }
        return super.buildRequestAttributes(request, response, previousAttributes);
    }

    protected void initFrameworkServlet() throws BeansException {
        this.context = this.getServletContext();
        this.context.log("GSP servlet initialized");
        this.context.setAttribute(SERVLET_INSTANCE, (Object)this);
        WebApplicationContext webApplicationContext = this.getWebApplicationContext();
        this.grailsAttributes = (GrailsApplicationAttributes)GrailsFactoriesLoader.loadFactoriesWithArguments(GrailsApplicationAttributes.class, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Object[])new Object[]{this.context}).get(0);
        AutowireCapableBeanFactory autowireCapableBeanFactory = webApplicationContext.getAutowireCapableBeanFactory();
        if (autowireCapableBeanFactory != null) {
            autowireCapableBeanFactory.autowireBeanProperties((Object)this, 2, false);
        }
        this.groovyPagesTemplateEngine = (GroovyPagesTemplateEngine)webApplicationContext.getBean("groovyPagesTemplateEngine", GroovyPagesTemplateEngine.class);
    }

    public void setGroovyPagesTemplateEngine(GroovyPagesTemplateEngine groovyPagesTemplateEngine) {
        this.groovyPagesTemplateEngine = groovyPagesTemplateEngine;
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isNotInclude;
        request.setAttribute("org.codehaus.groovy.grails.GRAILS_APPLICATION_ATTRIBUTES", (Object)this.grailsAttributes);
        request.setAttribute(SERVLET_INSTANCE, (Object)this);
        String pageName = (String)request.getAttribute("org.grails.GSP_TO_RENDER");
        if (GrailsStringUtils.isBlank((String)pageName)) {
            pageName = this.getCurrentRequestUri(request);
        }
        boolean bl = isNotInclude = !WebUtils.isIncludeRequest((ServletRequest)request);
        if (isNotInclude && this.isSecurePath(pageName)) {
            this.sendNotFound(response, pageName);
        } else {
            GroovyPageScriptSource scriptSource = this.groovyPagesTemplateEngine.findScriptSource(pageName);
            if (scriptSource == null) {
                scriptSource = this.findPageInBinaryPlugins(pageName);
            }
            if (scriptSource == null || isNotInclude && !scriptSource.isPublic()) {
                this.sendNotFound(response, pageName);
                return;
            }
            this.renderPageWithEngine(this.groovyPagesTemplateEngine, request, response, scriptSource);
        }
    }

    protected String getCurrentRequestUri(HttpServletRequest request) {
        Object includePath = request.getAttribute("jakarta.servlet.include.servlet_path");
        if (includePath != null) {
            return (String)includePath;
        }
        return request.getServletPath();
    }

    public GroovyPagesTemplateEngine getGroovyPagesTemplateEngine() {
        return this.groovyPagesTemplateEngine;
    }

    protected boolean isSecurePath(String pageName) {
        return pageName.startsWith(WEB_INF) || pageName.startsWith(GRAILS_APP);
    }

    protected void sendNotFound(HttpServletResponse response, String pageName) throws IOException {
        this.context.log("GroovyPagesServlet:  \"" + pageName + "\" not found");
        response.sendError(404, "\"" + pageName + "\" not found.");
    }

    protected GroovyPageScriptSource findPageInBinaryPlugins(String pageName) {
        if (pageName != null) {
            Class pageClass = this.binaryPluginViewsMap.get(pageName);
            if (pageClass == null && this.pluginManager != null) {
                GrailsPlugin[] allPlugins;
                for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
                    BinaryGrailsPlugin binaryPlugin;
                    if (!(plugin instanceof BinaryGrailsPlugin) || (pageClass = (binaryPlugin = (BinaryGrailsPlugin)plugin).resolveView(pageName)) == null) continue;
                    this.binaryPluginViewsMap.put(pageName, pageClass);
                    break;
                }
            }
            if (pageClass != null) {
                return new GroovyPageCompiledScriptSource(pageName, pageName, pageClass);
            }
        }
        return null;
    }

    protected void renderPageWithEngine(GroovyPagesTemplateEngine engine, HttpServletRequest request, HttpServletResponse response, GroovyPageScriptSource scriptSource) throws Exception {
        request.setAttribute("org.grails.rendering.view", (Object)Boolean.TRUE);
        try (GSPResponseWriter out = this.createResponseWriter(response);){
            Template template = engine.createTemplate((ScriptSource)scriptSource);
            if (template instanceof GroovyPageTemplate) {
                ((GroovyPageTemplate)template).setAllowSettingContentType(true);
            }
            template.make().writeTo((Writer)((Object)out));
        }
    }

    protected GSPResponseWriter createResponseWriter(HttpServletResponse response) {
        GSPResponseWriter out = GSPResponseWriter.getInstance((ServletResponse)response);
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        webRequest.setOut((Writer)((Object)out));
        return out;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }
}

