/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler;

import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.grails.cli.compiler.CompilerAutoConfiguration;
import org.grails.cli.compiler.DependencyCustomizer;
import org.grails.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.core.annotation.Order;

@Order(value=-2147483448)
public class DependencyAutoConfigurationTransformation
implements ASTTransformation {
    public static final int ORDER = -2147483448;
    private final GroovyClassLoader loader;
    private final DependencyResolutionContext dependencyResolutionContext;
    private final Iterable<CompilerAutoConfiguration> compilerAutoConfigurations;

    public DependencyAutoConfigurationTransformation(GroovyClassLoader loader, DependencyResolutionContext dependencyResolutionContext, Iterable<CompilerAutoConfiguration> compilerAutoConfigurations) {
        this.loader = loader;
        this.dependencyResolutionContext = dependencyResolutionContext;
        this.compilerAutoConfigurations = compilerAutoConfigurations;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        for (ASTNode astNode : nodes) {
            if (!(astNode instanceof ModuleNode)) continue;
            this.visitModule((ModuleNode)astNode);
        }
    }

    private void visitModule(ModuleNode module) {
        DependencyCustomizer dependencies = new DependencyCustomizer(this.loader, module, this.dependencyResolutionContext);
        for (ClassNode classNode : module.getClasses()) {
            for (CompilerAutoConfiguration autoConfiguration : this.compilerAutoConfigurations) {
                if (!autoConfiguration.matches(classNode)) continue;
                autoConfiguration.applyDependencies(dependencies);
            }
        }
    }
}

